/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import sun.misc.Unsafe;

public abstract class AbstractQueuedLongSynchronizer
extends AbstractOwnableSynchronizer
implements Serializable {
    private static final long serialVersionUID = 7373984972572414692L;
    private volatile transient Node head;
    private volatile transient Node tail;
    private volatile long state;
    static final long spinForTimeoutThreshold = 1000L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long stateOffset;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long waitStatusOffset;
    private static final long nextOffset;

    protected AbstractQueuedLongSynchronizer() {
    }

    protected final long getState() {
        return this.state;
    }

    protected final void setState(long l) {
        this.state = l;
    }

    protected final boolean compareAndSetState(long l, long l2) {
        return unsafe.compareAndSwapLong(this, stateOffset, l, l2);
    }

    private Node enq(Node node) {
        Node node2;
        while (true) {
            if ((node2 = this.tail) == null) {
                if (!this.compareAndSetHead(new Node())) continue;
                this.tail = this.head;
                continue;
            }
            node.prev = node2;
            if (this.compareAndSetTail(node2, node)) break;
        }
        node2.next = node;
        return node2;
    }

    private Node addWaiter(Node node) {
        Node node2 = new Node(Thread.currentThread(), node);
        Node node3 = this.tail;
        if (node3 != null) {
            node2.prev = node3;
            if (this.compareAndSetTail(node3, node2)) {
                node3.next = node2;
                return node2;
            }
        }
        this.enq(node2);
        return node2;
    }

    private void setHead(Node node) {
        this.head = node;
        node.thread = null;
        node.prev = null;
    }

    private void unparkSuccessor(Node node) {
        Node node2;
        int n = node.waitStatus;
        if (n < 0) {
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, n, 0);
        }
        if ((node2 = node.next) == null || node2.waitStatus > 0) {
            node2 = null;
            Node node3 = this.tail;
            while (node3 != null && node3 != node) {
                if (node3.waitStatus <= 0) {
                    node2 = node3;
                }
                node3 = node3.prev;
            }
        }
        if (node2 != null) {
            LockSupport.unpark(node2.thread);
        }
    }

    private void doReleaseShared() {
        while (true) {
            Node node;
            if ((node = this.head) != null && node != this.tail) {
                int n = node.waitStatus;
                if (n == -1) {
                    if (!AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -1, 0)) continue;
                    this.unparkSuccessor(node);
                } else if (n == 0 && !AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, 0, -3)) continue;
            }
            if (node == this.head) break;
        }
    }

    private void setHeadAndPropagate(Node node, long l) {
        Node node2;
        Node node3 = this.head;
        this.setHead(node);
        if (!(l <= 0L && node3 != null && node3.waitStatus >= 0 && (node3 = this.head) != null && node3.waitStatus >= 0 || (node2 = node.next) != null && !node2.isShared())) {
            this.doReleaseShared();
        }
    }

    private void cancelAcquire(Node node) {
        if (node == null) {
            return;
        }
        node.thread = null;
        Node node2 = node.prev;
        while (node2.waitStatus > 0) {
            node.prev = node2 = node2.prev;
        }
        Node node3 = node2.next;
        node.waitStatus = 1;
        if (node == this.tail && this.compareAndSetTail(node, node2)) {
            AbstractQueuedLongSynchronizer.compareAndSetNext(node2, node3, null);
        } else {
            int n;
            if (node2 != this.head && ((n = node2.waitStatus) == -1 || n <= 0 && AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, n, -1)) && node2.thread != null) {
                Node node4 = node.next;
                if (node4 != null && node4.waitStatus <= 0) {
                    AbstractQueuedLongSynchronizer.compareAndSetNext(node2, node3, node4);
                }
            } else {
                this.unparkSuccessor(node);
            }
            node.next = node;
        }
    }

    private static boolean shouldParkAfterFailedAcquire(Node node, Node node2) {
        int n = node.waitStatus;
        if (n == -1) {
            return true;
        }
        if (n > 0) {
            do {
                node2.prev = node = node.prev;
            } while (node.waitStatus > 0);
            node.next = node2;
        } else {
            AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, n, -1);
        }
        return false;
    }

    static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    private final boolean parkAndCheckInterrupt() {
        LockSupport.park(this);
        return Thread.interrupted();
    }

    final boolean acquireQueued(Node node, long l) {
        boolean bl = true;
        try {
            boolean bl2 = false;
            while (true) {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(l)) {
                    this.setHead(node);
                    node2.next = null;
                    bl = false;
                    boolean bl3 = bl2;
                    return bl3;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireInterruptibly(long l) throws InterruptedException {
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean bl = true;
        try {
            Node node2;
            do {
                if ((node2 = node.predecessor()) != this.head || !this.tryAcquire(l)) continue;
                this.setHead(node);
                node2.next = null;
                bl = false;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
            throw new InterruptedException();
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    private boolean doAcquireNanos(long l, long l2) throws InterruptedException {
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.nanoTime() + l2;
        Node node = this.addWaiter(Node.EXCLUSIVE);
        boolean bl = true;
        try {
            do {
                Node node2;
                if ((node2 = node.predecessor()) == this.head && this.tryAcquire(l)) {
                    this.setHead(node);
                    node2.next = null;
                    bl = false;
                    boolean bl2 = true;
                    return bl2;
                }
                l2 = l3 - System.nanoTime();
                if (l2 <= 0L) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || l2 <= 1000L) continue;
                LockSupport.parkNanos(this, l2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireShared(long l) {
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            boolean bl2 = false;
            while (true) {
                long l2;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (l2 = this.tryAcquireShared(l)) >= 0L) {
                    this.setHeadAndPropagate(node, l2);
                    node2.next = null;
                    if (bl2) {
                        AbstractQueuedLongSynchronizer.selfInterrupt();
                    }
                    bl = false;
                    return;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt()) continue;
                bl2 = true;
            }
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    private void doAcquireSharedInterruptibly(long l) throws InterruptedException {
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            Node node2;
            do {
                long l2;
                if ((node2 = node.predecessor()) != this.head || (l2 = this.tryAcquireShared(l)) < 0L) continue;
                this.setHeadAndPropagate(node, l2);
                node2.next = null;
                bl = false;
                return;
            } while (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || !this.parkAndCheckInterrupt());
            throw new InterruptedException();
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    private boolean doAcquireSharedNanos(long l, long l2) throws InterruptedException {
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.nanoTime() + l2;
        Node node = this.addWaiter(Node.SHARED);
        boolean bl = true;
        try {
            do {
                long l4;
                Node node2;
                if ((node2 = node.predecessor()) == this.head && (l4 = this.tryAcquireShared(l)) >= 0L) {
                    this.setHeadAndPropagate(node, l4);
                    node2.next = null;
                    bl = false;
                    boolean bl2 = true;
                    return bl2;
                }
                l2 = l3 - System.nanoTime();
                if (l2 <= 0L) {
                    boolean bl3 = false;
                    return bl3;
                }
                if (!AbstractQueuedLongSynchronizer.shouldParkAfterFailedAcquire(node2, node) || l2 <= 1000L) continue;
                LockSupport.parkNanos(this, l2);
            } while (!Thread.interrupted());
            throw new InterruptedException();
        }
        finally {
            if (bl) {
                this.cancelAcquire(node);
            }
        }
    }

    protected boolean tryAcquire(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryRelease(long l) {
        throw new UnsupportedOperationException();
    }

    protected long tryAcquireShared(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean tryReleaseShared(long l) {
        throw new UnsupportedOperationException();
    }

    protected boolean isHeldExclusively() {
        throw new UnsupportedOperationException();
    }

    public final void acquire(long l) {
        if (!this.tryAcquire(l) && this.acquireQueued(this.addWaiter(Node.EXCLUSIVE), l)) {
            AbstractQueuedLongSynchronizer.selfInterrupt();
        }
    }

    public final void acquireInterruptibly(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.tryAcquire(l)) {
            this.doAcquireInterruptibly(l);
        }
    }

    public final boolean tryAcquireNanos(long l, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquire(l) || this.doAcquireNanos(l, l2);
    }

    public final boolean release(long l) {
        if (this.tryRelease(l)) {
            Node node = this.head;
            if (node != null && node.waitStatus != 0) {
                this.unparkSuccessor(node);
            }
            return true;
        }
        return false;
    }

    public final void acquireShared(long l) {
        if (this.tryAcquireShared(l) < 0L) {
            this.doAcquireShared(l);
        }
    }

    public final void acquireSharedInterruptibly(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.tryAcquireShared(l) < 0L) {
            this.doAcquireSharedInterruptibly(l);
        }
    }

    public final boolean tryAcquireSharedNanos(long l, long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryAcquireShared(l) >= 0L || this.doAcquireSharedNanos(l, l2);
    }

    public final boolean releaseShared(long l) {
        if (this.tryReleaseShared(l)) {
            this.doReleaseShared();
            return true;
        }
        return false;
    }

    public final boolean hasQueuedThreads() {
        Node node = this.tail;
        Node node2 = this.head;
        while (node != node2 && node != null) {
            if (node.waitStatus <= 0) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    public final boolean hasContended() {
        return this.head != null;
    }

    public final Thread getFirstQueuedThread() {
        return this.head == this.tail ? null : this.fullGetFirstQueuedThread();
    }

    private Thread fullGetFirstQueuedThread() {
        Thread thread;
        Node node;
        Node node2 = this.head;
        if (node2 != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null || (node2 = this.head) != null && (node = node2.next) != null && node.prev == this.head && (thread = node.thread) != null) {
            return thread;
        }
        Node node3 = this.tail;
        Thread thread2 = null;
        while (node3 != null && node3 != this.head) {
            Thread thread3 = node3.thread;
            if (thread3 != null) {
                thread2 = thread3;
            }
            node3 = node3.prev;
        }
        return thread2;
    }

    public final boolean isQueued(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        Node node = this.tail;
        while (node != null) {
            if (node.thread == thread) {
                return true;
            }
            node = node.prev;
        }
        return false;
    }

    final boolean apparentlyFirstQueuedIsExclusive() {
        Node node;
        Node node2 = this.head;
        return node2 != null && (node = node2.next) != null && !node.isShared() && node.thread != null;
    }

    public final boolean hasQueuedPredecessors() {
        Node node = this.head;
        if (node != null) {
            Node node2 = node.next;
            if (node2 == null || node2.waitStatus > 0) {
                node2 = null;
                Node node3 = this.tail;
                while (node3 != node && node3 != null) {
                    if (node3.waitStatus <= 0) {
                        node2 = node3;
                    }
                    node3 = node3.prev;
                }
            }
            if (node2 != null && node2.thread != Thread.currentThread()) {
                return true;
            }
        }
        return false;
    }

    public final int getQueueLength() {
        int n = 0;
        Node node = this.tail;
        while (node != null) {
            if (node.thread != null) {
                ++n;
            }
            node = node.prev;
        }
        return n;
    }

    public final Collection<Thread> getQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread = node.thread;
            if (thread != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getExclusiveQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (!node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public final Collection<Thread> getSharedQueuedThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Node node = this.tail;
        while (node != null) {
            Thread thread;
            if (node.isShared() && (thread = node.thread) != null) {
                arrayList.add(thread);
            }
            node = node.prev;
        }
        return arrayList;
    }

    public String toString() {
        long l = this.getState();
        String string = this.hasQueuedThreads() ? "non" : "";
        return super.toString() + "[State = " + l + ", " + string + "empty queue]";
    }

    final boolean isOnSyncQueue(Node node) {
        if (node.waitStatus == -2 || node.prev == null) {
            return false;
        }
        if (node.next != null) {
            return true;
        }
        return this.findNodeFromTail(node);
    }

    private boolean findNodeFromTail(Node node) {
        Node node2 = this.tail;
        while (node2 != node) {
            if (node2 == null) {
                return false;
            }
            node2 = node2.prev;
        }
        return true;
    }

    final boolean transferForSignal(Node node) {
        if (!AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            return false;
        }
        Node node2 = this.enq(node);
        int n = node2.waitStatus;
        if (n > 0 || !AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node2, n, -1)) {
            LockSupport.unpark(node.thread);
        }
        return true;
    }

    final boolean transferAfterCancelledWait(Node node) {
        if (AbstractQueuedLongSynchronizer.compareAndSetWaitStatus(node, -2, 0)) {
            this.enq(node);
            return true;
        }
        while (!this.isOnSyncQueue(node)) {
            Thread.yield();
        }
        return false;
    }

    final long fullyRelease(Node node) {
        boolean bl = true;
        try {
            long l = this.getState();
            if (this.release(l)) {
                bl = false;
                long l2 = l;
                return l2;
            }
            throw new IllegalMonitorStateException();
        }
        finally {
            if (bl) {
                node.waitStatus = 1;
            }
        }
    }

    public final boolean owns(ConditionObject conditionObject) {
        return conditionObject.isOwnedBy(this);
    }

    public final boolean hasWaiters(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.hasWaiters();
    }

    public final int getWaitQueueLength(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitQueueLength();
    }

    public final Collection<Thread> getWaitingThreads(ConditionObject conditionObject) {
        if (!this.owns(conditionObject)) {
            throw new IllegalArgumentException("Not owner");
        }
        return conditionObject.getWaitingThreads();
    }

    private final boolean compareAndSetHead(Node node) {
        return unsafe.compareAndSwapObject(this, headOffset, null, node);
    }

    private final boolean compareAndSetTail(Node node, Node node2) {
        return unsafe.compareAndSwapObject(this, tailOffset, node, node2);
    }

    private static final boolean compareAndSetWaitStatus(Node node, int n, int n2) {
        return unsafe.compareAndSwapInt(node, waitStatusOffset, n, n2);
    }

    private static final boolean compareAndSetNext(Node node, Node node2, Node node3) {
        return unsafe.compareAndSwapObject(node, nextOffset, node2, node3);
    }

    static {
        try {
            stateOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("state"));
            headOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("head"));
            tailOffset = unsafe.objectFieldOffset(AbstractQueuedLongSynchronizer.class.getDeclaredField("tail"));
            waitStatusOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("waitStatus"));
            nextOffset = unsafe.objectFieldOffset(Node.class.getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public class ConditionObject
    implements Condition,
    Serializable {
        private static final long serialVersionUID = 1173984872572414699L;
        private transient Node firstWaiter;
        private transient Node lastWaiter;
        private static final int REINTERRUPT = 1;
        private static final int THROW_IE = -1;

        private Node addConditionWaiter() {
            Node node = this.lastWaiter;
            if (node != null && node.waitStatus != -2) {
                this.unlinkCancelledWaiters();
                node = this.lastWaiter;
            }
            Node node2 = new Node(Thread.currentThread(), -2);
            if (node == null) {
                this.firstWaiter = node2;
            } else {
                node.nextWaiter = node2;
            }
            this.lastWaiter = node2;
            return node2;
        }

        private void doSignal(Node node) {
            do {
                if ((this.firstWaiter = node.nextWaiter) == null) {
                    this.lastWaiter = null;
                }
                node.nextWaiter = null;
            } while (!AbstractQueuedLongSynchronizer.this.transferForSignal(node) && (node = this.firstWaiter) != null);
        }

        private void doSignalAll(Node node) {
            Node node2;
            this.firstWaiter = null;
            this.lastWaiter = null;
            do {
                node2 = node.nextWaiter;
                node.nextWaiter = null;
                AbstractQueuedLongSynchronizer.this.transferForSignal(node);
            } while ((node = node2) != null);
        }

        private void unlinkCancelledWaiters() {
            Node node = this.firstWaiter;
            Node node2 = null;
            while (node != null) {
                Node node3 = node.nextWaiter;
                if (node.waitStatus != -2) {
                    node.nextWaiter = null;
                    if (node2 == null) {
                        this.firstWaiter = node3;
                    } else {
                        node2.nextWaiter = node3;
                    }
                    if (node3 == null) {
                        this.lastWaiter = node2;
                    }
                } else {
                    node2 = node;
                }
                node = node3;
            }
        }

        @Override
        public final void signal() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignal(node);
            }
        }

        @Override
        public final void signalAll() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            if (node != null) {
                this.doSignalAll(node);
            }
        }

        @Override
        public final void awaitUninterruptibly() {
            Node node = this.addConditionWaiter();
            long l = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            boolean bl = false;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                if (!Thread.interrupted()) continue;
                bl = true;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, l) || bl) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        private int checkInterruptWhileWaiting(Node node) {
            return Thread.interrupted() ? (AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node) ? -1 : 1) : 0;
        }

        private void reportInterruptAfterWait(int n) throws InterruptedException {
            if (n == -1) {
                throw new InterruptedException();
            }
            if (n == 1) {
                AbstractQueuedLongSynchronizer.selfInterrupt();
            }
        }

        @Override
        public final void await() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long l = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                LockSupport.park(this);
                n = this.checkInterruptWhileWaiting(node);
                if (n == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, l) && n != -1) {
                n = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
        }

        @Override
        public final long awaitNanos(long l) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long l2 = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            long l3 = System.nanoTime() + l;
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (l <= 0L) {
                    AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                if (l >= 1000L) {
                    LockSupport.parkNanos(this, l);
                }
                if ((n = this.checkInterruptWhileWaiting(node)) != 0) break;
                l = l3 - System.nanoTime();
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, l2) && n != -1) {
                n = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return l3 - System.nanoTime();
        }

        @Override
        public final boolean awaitUntil(Date date) throws InterruptedException {
            long l = date.getTime();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long l2 = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            boolean bl = false;
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (System.currentTimeMillis() > l) {
                    bl = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                LockSupport.parkUntil(this, l);
                n = this.checkInterruptWhileWaiting(node);
                if (n == 0) continue;
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, l2) && n != -1) {
                n = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return !bl;
        }

        @Override
        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            long l2 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Node node = this.addConditionWaiter();
            long l3 = AbstractQueuedLongSynchronizer.this.fullyRelease(node);
            long l4 = System.nanoTime() + l2;
            boolean bl = false;
            int n = 0;
            while (!AbstractQueuedLongSynchronizer.this.isOnSyncQueue(node)) {
                if (l2 <= 0L) {
                    bl = AbstractQueuedLongSynchronizer.this.transferAfterCancelledWait(node);
                    break;
                }
                if (l2 >= 1000L) {
                    LockSupport.parkNanos(this, l2);
                }
                if ((n = this.checkInterruptWhileWaiting(node)) != 0) break;
                l2 = l4 - System.nanoTime();
            }
            if (AbstractQueuedLongSynchronizer.this.acquireQueued(node, l3) && n != -1) {
                n = 1;
            }
            if (node.nextWaiter != null) {
                this.unlinkCancelledWaiters();
            }
            if (n != 0) {
                this.reportInterruptAfterWait(n);
            }
            return !bl;
        }

        final boolean isOwnedBy(AbstractQueuedLongSynchronizer abstractQueuedLongSynchronizer) {
            return abstractQueuedLongSynchronizer == AbstractQueuedLongSynchronizer.this;
        }

        protected final boolean hasWaiters() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    return true;
                }
                node = node.nextWaiter;
            }
            return false;
        }

        protected final int getWaitQueueLength() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int n = 0;
            Node node = this.firstWaiter;
            while (node != null) {
                if (node.waitStatus == -2) {
                    ++n;
                }
                node = node.nextWaiter;
            }
            return n;
        }

        protected final Collection<Thread> getWaitingThreads() {
            if (!AbstractQueuedLongSynchronizer.this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            ArrayList<Thread> arrayList = new ArrayList<Thread>();
            Node node = this.firstWaiter;
            while (node != null) {
                Thread thread;
                if (node.waitStatus == -2 && (thread = node.thread) != null) {
                    arrayList.add(thread);
                }
                node = node.nextWaiter;
            }
            return arrayList;
        }
    }

    static final class Node {
        static final Node SHARED = new Node();
        static final Node EXCLUSIVE = null;
        static final int CANCELLED = 1;
        static final int SIGNAL = -1;
        static final int CONDITION = -2;
        static final int PROPAGATE = -3;
        volatile int waitStatus;
        volatile Node prev;
        volatile Node next;
        volatile Thread thread;
        Node nextWaiter;

        final boolean isShared() {
            return this.nextWaiter == SHARED;
        }

        final Node predecessor() throws NullPointerException {
            Node node = this.prev;
            if (node == null) {
                throw new NullPointerException();
            }
            return node;
        }

        Node() {
        }

        Node(Thread thread, Node node) {
            this.nextWaiter = node;
            this.thread = thread;
        }

        Node(Thread thread, int n) {
            this.waitStatus = n;
            this.thread = thread;
        }
    }
}

