/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class ColoredLink
extends Canvas {
    private String text = null;
    private static final int INDENT = 3;
    private TextLayout layout = null;
    private Color linkColor = null;
    private int hIndent = 3;
    private int vIndent = 3;
    private Rectangle rect = null;
    private Font font = null;

    public ColoredLink(Composite parent, int style, Font font) {
        super(parent, style);
        this.font = font;
        this.layout = new TextLayout((Device)this.getDisplay());
        this.layout.setOrientation(0x3000000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ColoredLink.this.onPaint(event);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                ColoredLink.this.setCursor(new Cursor(null, 21));
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (ColoredLink.this.rect != null && ColoredLink.this.rect.contains(event.x, event.y)) {
                    Event e = new Event();
                    e.widget = ColoredLink.this;
                    ColoredLink.this.notifyListeners(13, e);
                    ColoredLink.this.redraw();
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ColoredLink.this.redraw();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ((Canvas)e.getSource()).redraw();
            }

            public void focusLost(FocusEvent e) {
                ((Canvas)e.getSource()).redraw();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.addAccessibility();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
    }

    private void addAccessibility() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ColoredLink.this.getBounds();
                if (location != null) {
                    Point pt = ColoredLink.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (ColoredLink.this.isFocusControl()) {
                    e.detail |= 4;
                }
            }

            public void getSelection(AccessibleControlEvent e) {
                if (ColoredLink.this.isFocusControl()) {
                    e.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                if (ColoredLink.this.isFocusControl()) {
                    e.childID = -1;
                }
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SWT.getMessage((String)"SWT_Press");
            }
        });
    }

    void onPaint(PaintEvent event) {
        Rectangle txtRect = this.layout.getBounds();
        Rectangle ctlRect = this.getBounds();
        this.hIndent = 0;
        this.vIndent = ctlRect.height - txtRect.height;
        this.vIndent = (this.vIndent > 0 ? this.vIndent : 0) / 2;
        this.layout.draw(event.gc, this.hIndent, this.vIndent);
        this.rect = new Rectangle(this.hIndent, this.vIndent, txtRect.width, txtRect.height);
        if (this.isFocusControl()) {
            event.gc.drawFocus(this.hIndent, this.vIndent, txtRect.width, txtRect.height);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.layout.setText(this.text);
        TextStyle txtStyle = new TextStyle(this.font, this.linkColor, null);
        txtStyle.underline = true;
        this.layout.setStyle(txtStyle, 0, text == null || text.length() == 0 ? 0 : text.length());
    }

    public void setLinkColor(Color linkColor) {
        this.linkColor = linkColor;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle txtRect = this.getBounds();
        int width = wHint;
        int height = hHint;
        if (wHint != -1) {
            width = txtRect.width;
        }
        if (hHint != -1) {
            height = txtRect.height;
        }
        return new Point(width + 2, height + 2);
    }
}

