/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui;

import com.vendor.platform.api.IDeviceChangedListener;
import com.vendor.platform.api.IDeviceManager;
import com.vendor.platform.api.chips.Chip;
import com.vendor.platform.core.StopLicenceCheck;
import com.vendor.platform.ui.internal.AbstractUIActivator;
import com.vendor.platform.ui.internal.LanguageMenuBuilder;
import com.vendor.platform.ui.internal.MenuUtils;
import com.vendor.platform.ui.internal.NTP;
import com.vendor.platform.ui.internal.PlatformStateControlUtils;
import com.vendor.platform.ui.internal.ShowLogDialog;
import com.vendor.platform.ui.internal.ToolMenuBuilder;
import com.vendor.platform.ui.internal.UpdateDeviceDialog;
import com.vendor.platform.ui.update.UpdateAgent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

public class PlatformUIActivator
extends AbstractUIActivator {
    public static final String PLUGIN_ID = "com.vendor.platform.ui";
    private static PlatformUIActivator plugin;
    private static Font font;
    private static Image image;
    public static final String TOOL_PNG = "TOOL.PNG";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PlatformUIActivator.registerActivator(this);
        this.onBundleStart(context);
    }

    public void stop(BundleContext context) throws Exception {
        PlatformUIActivator.unregisterActivator();
        super.stop(context);
        this.onBundleStop();
    }

    private static void registerActivator(PlatformUIActivator activator) {
        plugin = activator;
    }

    private static void unregisterActivator() {
        plugin = null;
    }

    public static PlatformUIActivator getDefault() {
        return plugin;
    }

    public Action createShowLogAction(String title, final Shell shell) {
        Action action = new Action(title){

            public void run() {
                ShowLogDialog dialog = new ShowLogDialog(shell);
                dialog.open();
            }
        };
        action.setId("com.vendor.showLog");
        return action;
    }

    public Action createUpdateDeviceAction(String title, final Shell shell) {
        Action action = new Action(title){

            public void run() {
                UpdateDeviceDialog dialog = new UpdateDeviceDialog(shell);
                dialog.open();
            }
        };
        action.setId("com.vendor.updateDeviceList");
        return action;
    }

    public Action showCurrentDeviceAction(final String title) {
        IDeviceManager m = this.getDeviceManager();
        final Action action = new Action(String.valueOf(title) + m.getCurrentDevice()){};
        action.setId("com.vendor.currentDevice");
        IDeviceChangedListener listener = new IDeviceChangedListener(){

            public void deviceChanged(Chip device) {
                String deviceName = "";
                if (device != null) {
                    deviceName = device.getName();
                }
                action.setText(String.valueOf(title) + deviceName);
            }
        };
        m.addDeviceChangedListener(listener);
        return action;
    }

    public Action updateToolAction(String title) {
        Action action = new Action(title){

            public void run() {
                UpdateAgent.INSTANCE.runHiUpdate(false);
            }
        };
        action.setId("com.vendor.updatetool");
        return action;
    }

    public void addToolMenuListener(MenuManager toolMenu) {
        ToolMenuBuilder listener = new ToolMenuBuilder("allTools");
        toolMenu.addMenuListener((IMenuListener)listener);
    }

    public void addLanguageMenuListener(MenuManager languageMenu) {
        LanguageMenuBuilder builder = new LanguageMenuBuilder();
        languageMenu.addMenuListener((IMenuListener)builder);
        builder.fillMenu((IMenuManager)languageMenu);
    }

    public void createDeviceMenuList(MenuManager newMenu) {
        IDeviceManager m = this.getDeviceManager();
        MenuUtils.fillDeviceList(newMenu, m);
    }

    public void postWindowOpen() {
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        pm.remove("org.eclipse.tm.terminal.TerminalPreferencePage");
        pm.remove("org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage");
        pm.remove("org.eclipse.help.ui.browsersPreferencePage");
        pm.remove("org.eclipse.ui.preferencePages.Workbench");
        pm.remove("org.eclipse.oomph.ui.preferences.OomphPreferencePage");
        pm.remove("org.eclipse.m2e.core.preferences.Maven2PreferencePage");
        pm.remove("ValidationPreferencePage");
        pm.remove("org.eclipse.debug.ui.DebugPreferencePage");
        pm.remove("org.eclipse.team.ui.TeamPreferences");
        pm.remove("org.eclipse.wst.xml.ui.preferences.xml");
        pm.remove("org.eclipse.mylyn.preferencePages.Mylyn");
        pm.remove("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage");
        pm.remove("org.eclipse.buildship.ui.preferences");
        pm.remove("org.eclipse.ant.ui.AntPreferencePage");
        pm.remove("org.eclipse.pde.ui.MainPreferencePage");
        pm.remove("org.eclipse.swtbot.eclipse.ui.preferences.SWTBotPreferencePage");
        pm.remove("org.eclipse.e4.tools.emf.editor3x.modeleditor");
        this.onWindowOpen();
    }

    public void preWindowOpen() {
        if (StopLicenceCheck.openCheck()) {
            NTP.init();
        }
    }

    public IMenuListener createMenuStateListener(final Action action) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                action.setEnabled(PlatformStateControlUtils.isPlatformEnabled());
            }
        };
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return PlatformUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Font getToolFont() {
        if (font == null) {
            font = new Font((Device)Display.getDefault(), "Arial", 15, 1);
        }
        return font;
    }

    public static Image getToolDefaultImage() {
        ImageDescriptor imageDescriptor;
        if (image == null && (imageDescriptor = PlatformUIActivator.getImageDescriptor("icons/TOOL.PNG")) != null) {
            image = imageDescriptor.createImage();
        }
        return image;
    }
}

