/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui;

import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.PlatformUIActivator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.vendor.preferences.Activator;
import org.vendor.preferences.ToolPreferences;
import org.vendor.tftp.prefences.TFTPPreferences;

public class ToolPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String TOOL_PREF_DIALOG_ON_TOP = "dialog_on_top";
    private Button dialogOnTopBtn;
    private DeviceManager instance;
    private Button defaultChipBtn;
    private Text tftpTimeoutText;
    private Text KOText;

    public ToolPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.instance = (DeviceManager)DeviceManager.getInstance();
    }

    protected Control createContents(Composite parent) {
        Group globalSettings = new Group(parent, 0);
        globalSettings.setText(Messages.ToolPreferencePage_0);
        globalSettings.setLayout((Layout)new GridLayout(2, false));
        globalSettings.setLayoutData((Object)new GridData(768));
        this.dialogOnTopBtn = new Button((Composite)globalSettings, 32);
        this.dialogOnTopBtn.setText(Messages.AbstractUIActivator_3);
        this.dialogOnTopBtn.setSelection(Activator.getDefault().getPreferenceStore().getBoolean(TOOL_PREF_DIALOG_ON_TOP));
        this.defaultChipBtn = new Button((Composite)globalSettings, 32);
        this.defaultChipBtn.setText(Messages.AbstractUIActivator_2);
        this.defaultChipBtn.setSelection(this.instance.needPopupDevice());
        Group netSettings = new Group(parent, 0);
        netSettings.setText(Messages.ToolPreferencePage_1);
        netSettings.setLayout((Layout)new GridLayout(2, false));
        netSettings.setLayoutData((Object)new GridData(768));
        new Label((Composite)netSettings, 0).setText(String.valueOf(org.vendor.tftp.prefences.Messages.Preferences_Timeout) + " (s)");
        this.tftpTimeoutText = new Text((Composite)netSettings, 2048);
        this.tftpTimeoutText.setText("" + TFTPPreferences.getTimeout());
        this.tftpTimeoutText.setLayoutData((Object)new GridData(768));
        this.tftpTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ToolPreferencePage.this.validate();
            }
        });
        Group KOSettings = new Group(parent, 0);
        KOSettings.setText(org.vendor.preferences.Messages.PreferencePage_InstallKOCommand);
        KOSettings.setLayout((Layout)new GridLayout(2, false));
        KOSettings.setLayoutData((Object)new GridData(768));
        new Label((Composite)KOSettings, 0).setText(org.vendor.preferences.Messages.PreferencePage_InstallKOCommand);
        this.KOText = new Text((Composite)KOSettings, 2048);
        this.KOText.setText(ToolPreferences.getPreferenceKOCommand());
        this.KOText.setLayoutData((Object)new GridData(768));
        return parent;
    }

    protected void validate() {
        String timeout = this.tftpTimeoutText.getText();
        String timeoutWarning = JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{1, 60});
        try {
            int iTimeout = Integer.parseInt(timeout);
            if (iTimeout < 1 || iTimeout > 60) {
                this.setErrorMessage(timeoutWarning);
                this.setValid(false);
                this.updateApplyButton();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(timeoutWarning);
            this.setValid(false);
            this.updateApplyButton();
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        this.updateApplyButton();
    }

    public boolean performOk() {
        try {
            Activator.getDefault().getPreferenceStore().setValue(TOOL_PREF_DIALOG_ON_TOP, this.dialogOnTopBtn.getSelection());
            this.instance.updateDevicePopup(this.defaultChipBtn.getSelection());
            TFTPPreferences.setTimeout((int)Integer.parseInt(this.tftpTimeoutText.getText()));
            ToolPreferences.setKOCommand((String)this.KOText.getText());
        }
        catch (NumberFormatException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return super.performOk();
    }
}

