/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.api.IDeviceChangedListener;
import com.vendor.platform.api.IDeviceManager;
import com.vendor.platform.api.ILanguageManager;
import com.vendor.platform.api.IUIInitial;
import com.vendor.platform.api.chips.Chip;
import com.vendor.platform.core.IToolManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.StopLicenceCheck;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.core.internal.PreferenceUtils;
import com.vendor.platform.ui.PlatformUIActivator;
import com.vendor.platform.ui.ToolUtils;
import com.vendor.platform.ui.internal.ChipsSelectDialog;
import com.vendor.platform.ui.internal.IUIInitialImpl;
import com.vendor.platform.ui.internal.LanguageManager;
import com.vendor.platform.ui.internal.MenuUtils;
import com.vendor.platform.ui.internal.PerspectiveUtil;
import com.vendor.platform.ui.internal.PlatformStateControlUtils;
import com.vendor.platform.ui.internal.RegisterUtils;
import com.vendor.platform.ui.internal.TestBuildUtils;
import com.vendor.platform.ui.internal.ToolEntryBarManager;
import com.vendor.platform.ui.internal.ToolStateControlUtils;
import com.vendor.platform.ui.internal.ToolUpdateUtils;
import com.vendor.platform.ui.update.UpdateAgent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class AbstractUIActivator
extends AbstractUIPlugin
implements IExtensionChangeHandler {
    public static final int PLATFROM_DISABLE_EVENT = -1;
    public static final int TOOL_DISABLE_EVENT = -10;
    private ServiceRegistration<ILanguageManager> languageManager;
    private ServiceRegistration<IUIInitial> uiInitial;
    private IDeviceManager deviceManager;
    private static ExtensionTracker tracker;
    private static final String TOOL_PLATFORMCONFIGURATION = "Resources/Common/ChipProperties/PlatformConfiguration";

    public BundleContext getContext() {
        return this.getBundle().getBundleContext();
    }

    public IDeviceManager getDeviceManager() {
        if (this.deviceManager == null) {
            ServiceReference reference = this.getContext().getServiceReference(IDeviceManager.class.getName());
            this.deviceManager = (IDeviceManager)this.getContext().getService(reference);
            assert (this.deviceManager != null);
        }
        return this.deviceManager;
    }

    protected void onBundleStart(BundleContext context) {
        this.languageManager = context.registerService(ILanguageManager.class, (Object)new LanguageManager(), null);
        this.uiInitial = context.registerService(IUIInitial.class, (Object)new IUIInitialImpl(), null);
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        IDeviceManager dm = this.getDeviceManager();
        StateListener.onBundleStart(context, m, dm);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.updateWelcomeViewAfterExtensionChanged(extension, 1);
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        this.updateWelcomeViewAfterExtensionChanged(extension, 2);
    }

    private void updateWelcomeViewAfterExtensionChanged(IExtension extension, int type) {
        if (!extension.isValid()) {
            return;
        }
        IConfigurationElement[] configurationElements = extension.getConfigurationElements();
        if (configurationElements != null && configurationElements.length > 0) {
            HashMap<String, Integer> needUpdatePerspectiveIDS = new HashMap<String, Integer>();
            PlatformCoreActivator.getDefault().getToolManager();
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String perspectiveID = configurationElement.getAttribute("id");
                if (perspectiveID != null && perspectiveID.length() > 0 && perspectiveID.contains("com.vendor")) {
                    needUpdatePerspectiveIDS.put(perspectiveID, type);
                }
                ++n2;
            }
            PerspectiveUtil.addPerspectiveToWelcomeView(needUpdatePerspectiveIDS);
        }
    }

    protected void onBundleStop() {
        this.languageManager.unregister();
        this.uiInitial.unregister();
        if (tracker != null) {
            tracker.close();
            tracker = null;
        }
    }

    protected void onWindowOpen() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.ui.perspectives");
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)ep);
        tracker = new ExtensionTracker(reg);
        tracker.registerHandler((IExtensionChangeHandler)this, filter);
        ToolEntryBarManager.INSTANCE.init();
        StateListener.onWindowOpen();
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addExtension((IExtensionTracker)tracker, extensions[i]);
            ++i;
        }
    }

    private static void loadDefaultChipsListIfNeeded() {
        if (!PreferenceUtils.isAlsoImportedChipListFile()) {
            try {
                AbstractUIActivator.initializeDefaultPreferences();
                PreferenceUtils.updateAlsoImportedChipListFile((boolean)true);
            }
            catch (Exception e) {
                PlatformCoreActivator.log((Throwable)e);
            }
        }
    }

    private static void initializeDefaultPreferences() {
        File file = new File(String.valueOf(ToolUtils.getInstallPath()) + TOOL_PLATFORMCONFIGURATION);
        if (file.exists()) {
            try {
                DeviceManager instance = (DeviceManager)DeviceManager.getInstance();
                instance.updateDevices(file, false, false);
            }
            catch (Exception e) {
                PlatformCoreActivator.log((Throwable)e);
            }
            PreferenceUtils.updateAlsoImportedChipListFile((boolean)true);
        }
    }

    private static File resolveFile(URL url) {
        File source = null;
        try {
            source = new File(FileLocator.toFileURL((URL)url).toURI());
        }
        catch (Exception exception) {
            try {
                source = new File(FileLocator.toFileURL((URL)url).getFile());
            }
            catch (IOException iOException) {}
        }
        return source;
    }

    public static class StateListener {
        static void onBundleStart(BundleContext context, final IToolManager m, IDeviceManager dm) {
            AbstractUIActivator.loadDefaultChipsListIfNeeded();
            context.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == -1) {
                        PlatformStateControlUtils.setPlatformState(false);
                        ToolStateControlUtils.autoPlatformDisabledTools();
                    } else if (event.getType() == -10) {
                        Throwable throwable = event.getThrowable();
                        String toolName = throwable.getMessage();
                        ToolStateControlUtils.autoAuthorityDisabledTool(toolName);
                    }
                }
            });
            dm.addDeviceChangedListener(new IDeviceChangedListener(){

                public synchronized void deviceChanged(Chip device) {
                    List installTools = m.collectFeatureTools(m.getInstalledToolIUs());
                    if (installTools != null && installTools.size() > 0) {
                        String deviceName = "";
                        if (device != null) {
                            deviceName = device.getName();
                        }
                        int i = 0;
                        while (i < installTools.size()) {
                            try {
                                ToolStateControlUtils.updateToolStateForChipChange(deviceName, (ToolDescriptor)installTools.get(i), false);
                            }
                            catch (Exception e) {
                                PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < installTools.size()) {
                            try {
                                ToolStateControlUtils.updateToolStateForChipChange(deviceName, (ToolDescriptor)installTools.get(i), true);
                            }
                            catch (Exception e) {
                                PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                            }
                            ++i;
                        }
                    }
                    try {
                        if (Workbench.getInstance() != null && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                            StateListener.updateCurrentWindowTitle();
                        }
                    }
                    catch (Exception e) {
                        PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    }
                }
            });
            dm.setCurrentDevice(dm.getCurrentDevice());
        }

        static void onWindowOpen() {
            List installTools;
            IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
            if (StopLicenceCheck.openCheck()) {
                installTools = m.collectFeatureTools(m.getInstalledToolIUs());
                StateListener.checkBundleRegData(installTools);
            }
            if (StateListener.showSelectChipDialog()) {
                try {
                    MenuUtils.refreshDeviceMenu();
                }
                catch (Exception e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                }
            } else {
                IDeviceManager deviceManager = DeviceManager.getInstance();
                deviceManager.setCurrentDevice(deviceManager.getCurrentDevice());
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

                public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    super.perspectiveClosed(page, perspective);
                    WorkbenchPage workbenchPage = (WorkbenchPage)page;
                    IPerspectiveDescriptor somePerspective = PerspectiveUtil.findFirstPerspectiveShortcut();
                    if (somePerspective != null) {
                        workbenchPage.setPerspective(somePerspective);
                    }
                }
            });
            StateListener.updateCurrentWindowTitle();
            installTools = m.collectFeatureTools(m.getInstalledToolIUs());
            if (installTools != null && installTools.size() > 0) {
                int i = 0;
                while (i < installTools.size()) {
                    ToolStateControlUtils.reDisableToolsForBundleStateRestore((ToolDescriptor)installTools.get(i));
                    ++i;
                }
            }
            UpdateAgent.INSTANCE.runHiUpdate(true);
        }

        private static void updateCurrentWindowTitle() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            String currentTitle = shell.getText();
            IDeviceManager dm = PlatformUIActivator.getDefault().getDeviceManager();
            if (currentTitle != null && currentTitle.length() > 0) {
                if (currentTitle.indexOf("-") > 0) {
                    String substring = currentTitle.substring(0, currentTitle.lastIndexOf("-"));
                    shell.setText(String.valueOf(substring) + "-" + dm.getCurrentDevice());
                } else {
                    shell.setText(String.valueOf(currentTitle) + "-" + dm.getCurrentDevice());
                }
            }
        }

        private static void checkBundleRegData(List<ToolDescriptor> installTools) {
            if (installTools != null && installTools.size() > 0) {
                int i = 0;
                while (i < installTools.size()) {
                    String code;
                    ToolDescriptor tool = installTools.get(i);
                    if (!(TestBuildUtils.isTestBuild(tool.getProperties()) || RegisterUtils.isUnlimited(tool.getProperties()) || RegisterUtils.getRegisterDate(tool.getProperties()) == null || (code = RegisterUtils.getRegisterCode(tool)) == null || RegisterUtils.isValidRegisterCode(tool, code))) {
                        ToolUpdateUtils.setToolEnableState(tool, false);
                    }
                    ++i;
                }
            }
        }

        private static boolean showSelectChipDialog() {
            final boolean[] isDeviceChanged = new boolean[1];
            final Display display = Display.getDefault();
            DeviceManager instance = (DeviceManager)DeviceManager.getInstance();
            try {
                if (instance.needPopupDevice() && PlatformStateControlUtils.isPlatformEnabled()) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ChipsSelectDialog chipsSelectDialog = new ChipsSelectDialog(display.getActiveShell(), DeviceManager.getCurrentChips(), false);
                            chipsSelectDialog.open();
                            isDeviceChanged[0] = chipsSelectDialog.isDeviceChanged();
                        }
                    });
                }
            }
            catch (Exception e) {
                PlatformCoreActivator.log((Throwable)e);
            }
            return isDeviceChanged[0];
        }

        private static boolean firstLoadDefaultChips() {
            URL chips;
            boolean alsoImported = PreferenceUtils.isAlsoImportedChipListFile();
            if (!alsoImported && (chips = PlatformCoreActivator.getDefault().find((IPath)new Path("chips"))) != null) {
                try {
                    String file;
                    File chipList;
                    URL resolve = FileLocator.toFileURL((URL)chips);
                    if (resolve != null && (chipList = new File(file = resolve.getFile())).exists()) {
                        try {
                            DeviceManager instance = (DeviceManager)DeviceManager.getInstance();
                            instance.updateDevices(chipList, false, false);
                        }
                        catch (Exception e) {
                            PlatformCoreActivator.log((Throwable)e);
                        }
                    }
                    PreferenceUtils.updateAlsoImportedChipListFile((boolean)true);
                    return true;
                }
                catch (IOException e) {
                    PlatformCoreActivator.log((Throwable)e);
                }
            }
            return false;
        }
    }
}

