/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.api.chips.Chip;
import com.vendor.platform.api.chips.Chips;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.ui.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChipsSelectDialog
extends TitleAreaDialog {
    private Chips chips;
    private CCombo combo;
    private DeviceManager instance;
    private boolean deviceChanged = false;

    public ChipsSelectDialog(Shell parent, Chips chips, boolean firstLoad) {
        super(parent);
        this.chips = chips;
        this.instance = (DeviceManager)DeviceManager.getInstance();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChipsSelectDialog_0);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x20);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ChipsSelectDialog_3);
        this.setMessage(Messages.ChipsSelectDialog_4);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(container, 0);
        label.setText(Messages.ChipsSelectDialog_1);
        this.combo = new CCombo(container, 8);
        boolean findOld = false;
        if (this.chips != null && this.chips.getChips().size() > 0) {
            ArrayList list = this.chips.getChips();
            String currentDevice = this.instance.getCurrentDevice();
            int i = 0;
            while (i < list.size()) {
                Chip chip = (Chip)list.get(i);
                this.combo.add(chip.getName());
                if (!findOld && currentDevice.equals(chip.getName())) {
                    this.combo.setText(currentDevice);
                    findOld = true;
                }
                ++i;
            }
        }
        GridData gd = new GridData();
        gd.widthHint = 170;
        this.combo.setLayoutData((Object)gd);
        if (!findOld && this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (this.combo.getText() != null && this.combo.getText().length() > 0) {
                String device = this.combo.getText();
                if (!this.instance.getCurrentDevice().equals(device)) {
                    this.instance.setCurrentDevice(device);
                    this.deviceChanged = true;
                }
                if (!this.instance.isSetPopupDevice()) {
                    this.instance.updateDevicePopup(false);
                }
            }
            super.buttonPressed(buttonId);
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isDeviceChanged() {
        return this.deviceChanged;
    }
}

