/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.core.log.Log;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class LogUtils {
    public static TableViewer createTableViewer(Composite parent, int width, int height, int style, String[] columns, int[] colWidths) {
        Composite tableParent = new Composite(parent, 0);
        GridData data = new GridData(1808);
        if (width != -1) {
            data.widthHint = width;
        }
        if (height != -1) {
            data.heightHint = height;
        }
        tableParent.setLayoutData((Object)data);
        TableColumnLayout tcl = new TableColumnLayout();
        tableParent.setLayout((Layout)tcl);
        TableViewer tableViewer = new TableViewer(tableParent, 0x800 | style);
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        LogViewerSorter logViewerSorter = new LogViewerSorter();
        tableViewer.setSorter((ViewerSorter)logViewerSorter);
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            column.addSelectionListener((SelectionListener)new LogViewerColumnSelectionListener(tableViewer, column, i, logViewerSorter));
            ++i;
        }
        return tableViewer;
    }

    public static class LogViewerColumnSelectionListener
    extends SelectionAdapter {
        private final TableViewer tableViewer;
        private LogViewerSorter hiViewerSorter;
        private final int index;
        private TableColumn column;

        public LogViewerColumnSelectionListener(TableViewer tableViewer, TableColumn column, int i, LogViewerSorter hiViewerSorter) {
            this.tableViewer = tableViewer;
            this.hiViewerSorter = hiViewerSorter;
            this.column = column;
            this.index = i;
        }

        public void widgetSelected(SelectionEvent e) {
            this.hiViewerSorter.setColumn(this.index);
            int dir = this.tableViewer.getTable().getSortDirection();
            dir = this.tableViewer.getTable().getSortColumn() == this.column ? (dir == 128 ? 1024 : 128) : 128;
            this.tableViewer.getTable().setSortDirection(dir);
            this.tableViewer.getTable().setSortColumn(this.column);
            this.tableViewer.refresh();
        }
    }

    public static class LogViewerSorter
    extends ViewerSorter {
        private int propertyIndex;
        private int direction;
        private static final int ASCENDING = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public boolean isSorterProperty(Object element, String property) {
            return true;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Log log1 = (Log)e1;
            Log log2 = (Log)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = log1.getToolName().compareTo(log2.getToolName());
                    break;
                }
                case 1: {
                    rc = log1.getDate().compareTo(log2.getDate());
                    break;
                }
                case 2: {
                    rc = log1.getMessage().compareTo(log2.getMessage());
                    break;
                }
            }
            if (this.direction != 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

