/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.core.IToolManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.WelcomeView;
import com.vendor.platform.ui.internal.BundleUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class PerspectiveUtil {
    public static final String PERSPECTIVE_SEP = "@";
    public static boolean activateToolsByHand = false;

    public static synchronized IWorkbenchPage openPerspective(String perspectiveId) throws Exception {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null && (workbenchWindows = workbench.getWorkbenchWindows()) != null && workbenchWindows.length > 0) {
            activeWorkbenchWindow = workbenchWindows[0];
        }
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor desc = activeWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (desc == null) {
            throw new Exception("Perspective " + perspectiveId + " cannot be found.");
        }
        try {
            if (activePage != null) {
                activePage.setPerspective(desc);
            } else {
                IAdaptable input = ((Workbench)workbench).getDefaultPageInput();
                activePage = activeWorkbenchWindow.openPage(perspectiveId, input);
            }
        }
        catch (WorkbenchException e) {
            throw new ExecutionException("Perspective could not be opened.", (Throwable)e);
        }
        return activePage;
    }

    public static void closeAllPerpectives() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        activePage.closeAllPerspectives(true, false);
    }

    public static synchronized void closePerpective(String perspectiveId) {
        IWorkbenchPage activePage;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            IPerspectiveDescriptor desc = activeWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (desc == null) {
                return;
            }
            activePage.closePerspective(desc, true, false);
        }
    }

    public static void revertPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        IPerspectiveDescriptor desc = activePage.getPerspective();
        PerspectiveRegistry reg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        reg.revertPerspective(desc);
        activePage.resetPerspective();
    }

    public static IPerspectiveDescriptor findFirstPerspectiveShortcut() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IPerspectiveDescriptor[] descs = page.getOpenPerspectives();
        if (descs == null || descs.length < 1) {
            return null;
        }
        return descs[0];
    }

    public static synchronized void addPerspectiveShortcutForWelcome(List<String> ids) {
    }

    public static synchronized void removePerspectiveShortcut(ToolDescriptor tool) {
    }

    public static synchronized void removePerspectiveShortcut(String id) {
    }

    public static synchronized void removePerspectiveShortcuts(List<ToolDescriptor> installTools, Map<String, IExtension> reg) {
    }

    public static Map<String, IExtension> loadPerspectiveRegistry() {
        HashMap<String, IExtension> pluginExtensions = new HashMap<String, IExtension>();
        IExtension[] extensions = PerspectiveUtil.getExtensions("org.eclipse.ui.perspectives");
        if (extensions != null) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension e = iExtensionArray[n2];
                String pluginId = e.getContributor().getName();
                pluginExtensions.put(pluginId, e);
                ++n2;
            }
        }
        return pluginExtensions;
    }

    public static IExtension[] getExtensions(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(id);
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        return extensions;
    }

    public static List<String> finPerspectiveDeclareIds(IExtension e) {
        ArrayList<String> ids = new ArrayList<String>();
        IConfigurationElement[] elements = e.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("perspective")) {
                String id = elements[i].getAttribute("id");
                ids.add(id);
            }
            ++i;
        }
        return ids;
    }

    public static List<String> finPerspectiveDeclareIds(ToolDescriptor tool, Map<String, IExtension> reg) {
        String[] plugins;
        ArrayList<String> ids = new ArrayList<String>();
        String[] stringArray = plugins = tool.getPluginIds();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> list;
            String id = stringArray[n2];
            IExtension ext = reg.get(id);
            if (ext != null && !(list = PerspectiveUtil.finPerspectiveDeclareIds(ext)).isEmpty()) {
                ids.addAll(list);
            }
            ++n2;
        }
        return ids;
    }

    public static void openBundlePerspective(ToolDescriptor tool) {
        Map<String, IExtension> reg = PerspectiveUtil.loadPerspectiveRegistry();
        List<String> ids = PerspectiveUtil.finPerspectiveDeclareIds(tool, reg);
        if (ids.size() == 0) {
            return;
        }
        String id = ids.get(0);
        try {
            PerspectiveUtil.openPerspective(id);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.PerspectiveUtil_1, (String)(String.valueOf(Messages.PerspectiveUtil_2) + id));
        }
    }

    public static synchronized void openSpecifyPerspective(final String id) throws InvocationTargetException, InterruptedException {
        Job job = new Job(Messages.AbstractUIActivator_1){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.AbstractUIActivator_0, -1);
                int wait = 0;
                OpenDefaultPespective openDefaultPespective = new OpenDefaultPespective(monitor, id);
                while (wait < 2000) {
                    Display.getDefault().asyncExec((Runnable)openDefaultPespective);
                    if (openDefaultPespective.opened) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    wait += 100;
                }
                this.setName("");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static String getDefaultPerspective() {
        IWorkbenchWindow[] workbenchWindows;
        Map<String, IExtension> reg = PerspectiveUtil.loadPerspectiveRegistry();
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installIUs = m.getInstalledToolIUs();
        List installTools = m.collectFeatureTools(installIUs);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null && (workbenchWindows = workbench.getWorkbenchWindows()) != null && workbenchWindows.length > 0) {
            activeWorkbenchWindow = workbenchWindows[0];
        }
        if (activeWorkbenchWindow == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor perspective = activePage.getPerspective();
        String currentPerspectiveId = null;
        if (perspective != null) {
            currentPerspectiveId = perspective.getId();
        }
        for (ToolDescriptor t : installTools) {
            List<String> ids;
            if (!BundleUtils.isToolEnabled(t) || (ids = PerspectiveUtil.finPerspectiveDeclareIds(t, reg)).size() == 0) continue;
            String id = ids.get(0);
            IPerspectiveDescriptor desc = null;
            try {
                desc = activeWorkbenchWindow.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
            }
            catch (Exception exception) {}
            if (desc == null) continue;
            if (currentPerspectiveId != null && currentPerspectiveId.equals(id)) {
                return id;
            }
            list.add(id);
        }
        if (list.size() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public static void openPerspectiveOnTheRight(String id) throws Exception {
        PerspectiveUtil.openPerspective(id);
    }

    public static synchronized void addPerspectiveToWelcomeView(Map<String, Integer> needUpdatePerspectiveIDS) {
        WelcomeView.READED_BUNDLES.putAll(needUpdatePerspectiveIDS);
        WelcomeView wv = WelcomeView.getInstance();
        if (wv == null) {
            return;
        }
        wv.refreshPerspectiveButton(needUpdatePerspectiveIDS);
    }

    public static void relocatePerspectiveBtn(String lastPerspIDS) {
    }

    private static final class OpenDefaultPespective
    implements Runnable {
        private final IProgressMonitor monitor;
        private String id;
        public boolean opened = false;

        private OpenDefaultPespective(IProgressMonitor monitor, String id) {
            this.monitor = monitor;
            this.id = id;
        }

        @Override
        public void run() {
            this.monitor.beginTask(Messages.AbstractUIActivator_0, -1);
            if (this.id == null) {
                String[] defaultPerspective = new String[1];
                try {
                    defaultPerspective[0] = PerspectiveUtil.getDefaultPerspective();
                    if (defaultPerspective[0] != null) {
                        PerspectiveUtil.closePerpective("com.vendor.platform.ui.Perspective");
                        PerspectiveUtil.removePerspectiveShortcut("com.vendor.platform.ui.Perspective");
                        PerspectiveUtil.openPerspective(defaultPerspective[0]);
                        this.opened = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    PerspectiveUtil.openPerspective(this.id);
                    this.opened = true;
                }
                catch (Exception exception) {}
            }
            this.monitor.done();
        }
    }
}

