/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class ReflectUtil {
    public static boolean isStatic(Method method) {
        return (method.getModifiers() & 8) > 0;
    }

    public static boolean isAbstract(Class classToCheck) {
        return (classToCheck.getModifiers() & 0x400) > 0;
    }

    public static Method getMethod(Class parentClass, String methodName) {
        return ReflectUtil.getMethod(parentClass, methodName, new Class[0]);
    }

    public static Method getMethod(Class parentClass, String methodName, Class parameterType) {
        return ReflectUtil.getMethod(parentClass, methodName, new Class[]{parameterType});
    }

    public static Method getMethod(Class parentClass, String methodName, Class ... parameterTypes) {
        try {
            return parentClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method[] getMethodsWithName(Class parentClass, String methodName) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = parentClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(methodName)) {
                list.add(method);
            }
            ++i;
        }
        return list.toArray(new Method[list.size()]);
    }

    public static Constructor getConstructor(Class parentClass, Class ... parameterTypes) {
        try {
            return parentClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInstance(String name, String method, Object ... params) {
        Method m;
        block4: {
            Class<?> c = Class.forName(name);
            m = ReflectUtil.getMethod(c, method, params);
            if (m != null) break block4;
            return null;
        }
        try {
            return m.invoke(null, params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(String name, Object ... params) {
        try {
            return ReflectUtil.newInstance(Class.forName(name), params);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(Class parentClass, Object ... params) {
        try {
            Class[] parameterTypes = new Class[params.length];
            int i = 0;
            while (i < params.length) {
                parameterTypes[i] = params[i].getClass();
                ++i;
            }
            Constructor c = ReflectUtil.getConstructor(parentClass, parameterTypes);
            return c.newInstance(params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invoke(Object obj, String method) {
        try {
            Method m = ReflectUtil.getMethod(obj.getClass(), method);
            return m.invoke(obj, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invoke(Object obj, String method, Object ... params) {
        Method m;
        block4: {
            m = ReflectUtil.getMethod(obj.getClass(), method, params);
            if (m != null) break block4;
            return null;
        }
        try {
            return m.invoke(obj, params);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class cls, String method, Object ... params) {
        Method[] methods = ReflectUtil.getMethodsWithName(cls, method);
        if (methods == null || methods.length == 0) {
            return null;
        }
        if (methods.length == 1) {
            return methods[0];
        }
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Class<?>[] types = m.getParameterTypes();
            if (ReflectUtil.isMatch(types, params)) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isMatch(Class<?>[] types, Object[] params) {
        if (types.length != params.length) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            if (!ReflectUtil.isMatch(types[i], params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isMatch(Class<?> type, Object obj) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE && obj.getClass() == Integer.class) {
                return true;
            }
            if (type == Long.TYPE && obj.getClass() == Long.class) {
                return true;
            }
            if (type == Boolean.TYPE && obj.getClass() == Boolean.class) {
                return true;
            }
            if (type == Float.TYPE && obj.getClass() == Float.class) {
                return true;
            }
            if (type == Double.TYPE && obj.getClass() == Double.class) {
                return true;
            }
            if (type == Byte.TYPE && obj.getClass() == Byte.class) {
                return true;
            }
            if (type == Short.TYPE && obj.getClass() == Short.class) {
                return true;
            }
            if (type == Character.TYPE && obj.getClass() == Character.class) {
                return true;
            }
        }
        return type.isAssignableFrom(obj.getClass());
    }
}

