/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.PlatformUIActivator;
import com.vendor.platform.ui.internal.Base64;
import com.vendor.platform.ui.internal.BundleUtils;
import com.vendor.platform.ui.internal.Encrypter;
import com.vendor.platform.ui.internal.NTP;
import com.vendor.platform.ui.internal.RC4;
import com.vendor.platform.ui.internal.TestBuildUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;

public class RegisterUtils {
    private static Properties registry;
    private static DecimalFormat ellapseTimeFormat;

    static {
        ellapseTimeFormat = new DecimalFormat("#.#");
    }

    static synchronized Properties getRegistry() {
        if (registry == null) {
            registry = RegisterUtils.initRegistry();
        }
        return registry;
    }

    static String decrypt(String text, String password) throws Exception {
        byte[] key = Encrypter.encodeMD5(password.getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding()));
        byte[] cryptData = Base64.decode(text);
        byte[] outputData = Encrypter.decrypt(cryptData, key);
        String outputStr = new String(outputData, WorkbenchEncoding.getWorkbenchDefaultEncoding());
        return outputStr;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean registerCode(String tool, String version, String info, String code) {
        String[] v;
        block14: {
            String text = "";
            try {
                text = RegisterUtils.decrypt(info, code);
                v = text.split("#");
                if (987654321L == Long.parseLong(v[0], 16)) break block14;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (!tool.equals(v[1]) || !version.equals(v[2])) {
            return false;
        }
        Properties reg = RegisterUtils.getRegistry();
        reg.put(String.valueOf(tool) + "@@" + version, String.valueOf(System.currentTimeMillis()) + "@@" + code);
        File regFile = RegisterUtils.getRegistryFile();
        FileOutputStream out = null;
        out = new FileOutputStream(regFile);
        reg.save(out, "");
        out.close();
        if (out == null) return true;
        try {
            out.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException e) {
            try {
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                if (out == null) return false;
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    public static String getRegisterCode(ToolDescriptor tool) {
        return RegisterUtils.getRegisterCode(tool.getProperties());
    }

    public static String getRegisterCode(Map<String, String> properties) {
        String id = properties.get("build.id");
        String ver = properties.get("build.ver");
        Properties reg = RegisterUtils.getRegistry();
        Object time_code = reg.get(String.valueOf(id) + "@@" + ver);
        if (time_code == null) {
            return null;
        }
        String timeCode = (String)time_code;
        if (timeCode.indexOf("@@") > 0) {
            String key = timeCode.substring(timeCode.indexOf("@@") + 2);
            return key;
        }
        return null;
    }

    private static File getRegistryFile() {
        Activator activator = Activator.getDefault();
        Location localConfig = activator.getConfigurationLocation();
        if (localConfig == null) {
            return null;
        }
        File regFile = new File(localConfig.getURL().getFile(), "tools.reg");
        return regFile;
    }

    private static synchronized Properties initStat() {
        FileInputStream in = null;
        try {
            File regFile = RegisterUtils.getStatFile();
            if (regFile != null && !regFile.exists() && !regFile.createNewFile()) {
                return null;
            }
            Properties p = new Properties();
            in = new FileInputStream(regFile);
            p.load(in);
            in.close();
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static File getStatFile() {
        Activator activator = Activator.getDefault();
        Location localConfig = activator.getConfigurationLocation();
        if (localConfig == null) {
            return null;
        }
        File regFile = new File(localConfig.getURL().getFile(), "tools.stat");
        return regFile;
    }

    private static synchronized Properties initRegistry() {
        FileInputStream in = null;
        try {
            File regFile = RegisterUtils.getRegistryFile();
            if (regFile != null && !regFile.exists() && !regFile.createNewFile()) {
                return null;
            }
            Properties p = new Properties();
            in = new FileInputStream(regFile);
            p.load(in);
            in.close();
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean registerCode(Map<String, String> properties, String code) {
        if (TestBuildUtils.isTestBuild(properties)) {
            return true;
        }
        if (RegisterUtils.isUnlimited(properties)) {
            return true;
        }
        String id = properties.get("build.id");
        String ver = properties.get("build.ver");
        String info = properties.get("info");
        return RegisterUtils.registerCode(id, ver, info, code);
    }

    public static boolean isUnlimited(Map<String, String> properties) {
        String lic = properties.get("lic.type");
        String time = properties.get("build.time");
        if (lic == null) {
            return false;
        }
        try {
            RC4 r = new RC4("_lic_key" + time);
            byte[] content = r.rc4(Base64.decode(lic));
            String text = new String(content, WorkbenchEncoding.getWorkbenchDefaultEncoding());
            if ("unlimited".equalsIgnoreCase(text)) {
                return true;
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static String decodeLicType(Map<String, String> map) {
        String lic = map.get("lic.type");
        String time = map.get("build.time");
        if (lic == null) {
            return "";
        }
        try {
            RC4 r = new RC4("_lic_key" + time);
            byte[] content = r.rc4(Base64.decode(lic));
            String text = new String(content, WorkbenchEncoding.getWorkbenchDefaultEncoding());
            return text;
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static boolean isExpire(Map<String, String> properties) {
        if (TestBuildUtils.isTestBuild(properties)) {
            return false;
        }
        if (RegisterUtils.isUnlimited(properties)) {
            return false;
        }
        if (RegisterUtils.getRegisterDate(properties) != null) {
            String code = RegisterUtils.getRegisterCode(properties);
            return code == null || !RegisterUtils.isValidRegisterCode(properties, code);
        }
        float remaining = RegisterUtils.getRemainingTime(properties);
        return remaining <= 0.0f;
    }

    public static String getExpireWarning(Map<String, String> properties) {
        String expireWarning = null;
        if (TestBuildUtils.isTestBuild(properties)) {
            return expireWarning;
        }
        if (RegisterUtils.isUnlimited(properties)) {
            return expireWarning;
        }
        if (RegisterUtils.getRegisterDate(properties) != null) {
            String code = RegisterUtils.getRegisterCode(properties);
            if (code != null && !RegisterUtils.isValidRegisterCode(properties, code)) {
                expireWarning = Messages.ToolManagerDialog_58;
            }
            return expireWarning;
        }
        float remaining = RegisterUtils.getRemainingTime(properties);
        if (remaining <= 0.0f) {
            expireWarning = Messages.ToolManagerDialog_39;
        }
        return expireWarning;
    }

    private static float getRemainingTime(Map<String, String> properties) {
        String plugins = properties.get("tool.plugins");
        String licType = RegisterUtils.decodeLicType(properties);
        String[] v = licType.split(":");
        float remaining = 0.0f;
        if (v[0].equals("expire")) {
            remaining = Float.parseFloat(ellapseTimeFormat.format((double)(Long.parseLong(v[1]) - NTP.getCurrentInternetTime()) / 8.64E7));
        } else if (v[0].equals("counter")) {
            float seed = Long.parseLong(v[1]) - RegisterUtils.getLongStat(plugins, "counter");
            remaining = Math.round(seed);
        } else if (v[0].equals("ellapse")) {
            double hours;
            long seconds = 0L;
            long start = RegisterUtils.getLongStat(plugins, "start");
            if (start != 0L) {
                seconds = (NTP.getCurrentInternetTime() - start) / 1000L;
            }
            if ((hours = Double.parseDouble(v[1]) - (double)RegisterUtils.getLongStat(plugins, "ellapse") - (double)seconds) < 0.0) {
                hours = 0.0;
            }
            remaining = Float.parseFloat(ellapseTimeFormat.format(hours /= 3600.0));
        }
        return remaining;
    }

    static long getLongStat(String plugins, String field) {
        String[] ids;
        long max = 0L;
        Properties stat = RegisterUtils.initStat();
        String[] stringArray = ids = plugins.split(";");
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long v;
            String value;
            String p = stringArray[n2];
            String statKey = null;
            Bundle bundle = BundleUtils.getInstance().getBundle(p);
            if (bundle != null) {
                String id = bundle.getSymbolicName();
                String ver = bundle.getVersion().toString();
                statKey = String.valueOf(id) + "@@" + ver + "@@" + field;
            }
            if (stat != null && statKey != null && (value = stat.getProperty(statKey)) != null && (v = Long.parseLong(value)) > max) {
                max = v;
            }
            ++n2;
        }
        return max;
    }

    public static String getUsageLimit(Map<String, String> properties) {
        String type = RegisterUtils.decodeLicType(properties);
        String[] t = type.split(":");
        if (t[0].equals("counter")) {
            return String.valueOf(t[1]) + " times";
        }
        if (t[0].equals("expire")) {
            Date d = new Date(Long.parseLong(t[1]));
            return "until " + d.toLocaleString();
        }
        if (t[0].equals("ellapse")) {
            String hours = ellapseTimeFormat.format(Float.parseFloat(t[1]) / 3600.0f);
            return String.valueOf(hours) + " hours";
        }
        return "";
    }

    public static String getRemainingTrialPeriod(ToolDescriptor tool) {
        String desc = "";
        Map properties = tool.getProperties();
        if (properties != null) {
            String licType = RegisterUtils.decodeLicType(properties);
            float remain = RegisterUtils.getRemainingTime(properties);
            if (remain < 0.0f) {
                remain = 0.0f;
            }
            if (licType.startsWith("expire")) {
                long day = (long)remain;
                desc = String.valueOf(day) + Messages.RegisterUtils_0;
                int hour = (int)Math.round(((double)remain - (double)day) * 24.0);
                if (hour > 0) {
                    desc = String.valueOf(desc) + " " + hour + Messages.RegisterUtils_2;
                }
            } else if (licType.startsWith("counter")) {
                desc = String.valueOf(Math.round(remain)) + Messages.RegisterUtils_1;
            } else if (licType.startsWith("ellapse")) {
                desc = String.valueOf(remain) + Messages.RegisterUtils_2;
            }
        }
        return desc;
    }

    public static boolean isValidRegisterCode(ToolDescriptor tool, String code) {
        return RegisterUtils.isValidRegisterCode(tool.getProperties(), code);
    }

    public static boolean isValidRegisterCode(Map<String, String> properties, String code) {
        String[] v;
        String ver;
        String id;
        block3: {
            try {
                id = properties.get("build.id");
                ver = properties.get("build.ver");
                String info = properties.get("info");
                String text = RegisterUtils.decrypt(info, code);
                v = text.split("#");
                if (987654321L == Long.parseLong(v[0], 16)) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return id.equals(v[1]) && ver.equals(v[2]);
    }

    public static Date getRegisterDate(Map<String, String> properties) {
        String id = properties.get("build.id");
        String ver = properties.get("build.ver");
        Properties reg = RegisterUtils.getRegistry();
        String code = reg.getProperty(String.valueOf(id) + "@@" + ver);
        if (code != null) {
            String[] str = code.split("@@");
            try {
                return new Date(Long.parseLong(str[0]));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static void clearLicense(ToolDescriptor tool) {
        block14: {
            Map properties = tool.getProperties();
            String id = (String)properties.get("build.id");
            String ver = (String)properties.get("build.ver");
            Properties reg = RegisterUtils.getRegistry();
            reg.remove(String.valueOf(id) + "@@" + ver);
            File regFile = RegisterUtils.getRegistryFile();
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(regFile);
                    reg.save(out, "");
                    out.close();
                }
                catch (IOException e) {
                    PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

