/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.api.IDeviceChangedListener;
import com.vendor.platform.api.chips.Chip;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.ui.internal.BundleUtils;
import com.vendor.platform.ui.internal.PerspectiveUtil;
import com.vendor.platform.ui.internal.ToolEntryAction;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class ToolEntryBarManager
implements IDeviceChangedListener {
    public static final ToolEntryBarManager INSTANCE = new ToolEntryBarManager();

    private ToolEntryBarManager() {
    }

    public void init() {
        DeviceManager.getInstance().addDeviceChangedListener((IDeviceChangedListener)this);
    }

    public void deviceChanged(Chip chip) {
        IExtension[] extensions;
        IContributionItem[] items;
        IToolBarManager toolbar = null;
        WorkbenchWindow window = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IContributionItem[] iContributionItemArray = items = window.getCoolBarManager2().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ToolBarContributionItem tbci;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ToolBarContributionItem && (tbci = (ToolBarContributionItem)item).getId().equals("tool_entry")) {
                toolbar = tbci.getToolBarManager();
                break;
            }
            ++n2;
        }
        if (toolbar == null) {
            return;
        }
        toolbar.removeAll();
        ArrayList<String> perspectivesIds = new ArrayList<String>();
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint ep = extReg.getExtensionPoint("org.eclipse.ui.perspectives");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement[] configurationElements;
            IExtension extension = iExtensionArray[n4];
            IConfigurationElement[] iConfigurationElementArray = configurationElements = extension.getConfigurationElements();
            int n5 = configurationElements.length;
            int n6 = 0;
            while (n6 < n5) {
                IConfigurationElement element = iConfigurationElementArray[n6];
                String perspectiveID = element.getAttribute("id");
                if (perspectiveID.contains("com.vendor")) {
                    perspectivesIds.add(perspectiveID);
                }
                ++n6;
            }
            ++n4;
        }
        PerspectiveRegistry persReg = (PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry();
        PerspectiveDescriptor perspective = (PerspectiveDescriptor)persReg.findPerspectiveWithId("com.vendor.platform.ui.Perspective");
        ToolEntryAction action = new ToolEntryAction(perspective.getLabel(), perspective);
        if (!action.init()) {
            return;
        }
        ActionContributionItem tbci = new ActionContributionItem((IAction)action);
        tbci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolbar.add((IContributionItem)tbci);
        for (String perspectiveID : perspectivesIds) {
            perspective = (PerspectiveDescriptor)persReg.findPerspectiveWithId(perspectiveID);
            if (perspective == null) continue;
            if (!BundleUtils.isExistentTool(perspectiveID)) {
                if (window.getActivePage().getPerspective() == perspective) {
                    try {
                        PerspectiveUtil.openPerspective("com.vendor.platform.ui.Perspective");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                PerspectiveUtil.closePerpective(perspective.getId());
                continue;
            }
            String toolName = "";
            String[] toolsMap = BundleUtils.TOOLS_AND_CLASSES_ARR[0];
            String[] classMap = BundleUtils.TOOLS_AND_CLASSES_ARR[1];
            int i = 0;
            while (i < classMap.length) {
                String className = classMap[i];
                if (perspectiveID.equals(className)) {
                    toolName = toolsMap[i];
                }
                ++i;
            }
            action = new ToolEntryAction(toolName, perspective);
            if (!action.init()) continue;
            tbci = new ActionContributionItem((IAction)action);
            tbci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            toolbar.add((IContributionItem)tbci);
        }
        toolbar.update(true);
    }
}

