/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.api.IDeviceManager;
import com.vendor.platform.core.IToolManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.ui.internal.BundleUtils;
import com.vendor.platform.ui.internal.PerspectiveUtil;
import com.vendor.platform.ui.internal.RegisterUtils;
import com.vendor.platform.ui.internal.StringConstants;
import com.vendor.platform.ui.internal.ToolUpdateUtils;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.Preferences;

public class ToolStateControlUtils {
    private static String TRUE = StringConstants.decode("1953658213");
    private static String TOOL_STATE_NODE = StringConstants.decode("549850129448369708430437");
    private static final String TOOL_STATE_AUTO_MODIFY_FOR_CHIP_NODE = "tool.auto";
    private static final String TOOL_STATE_HAND_MODIFY_NODE = "tool.hand";

    public static void setToolPlatformRelativeState(String toolID, boolean state) {
        Preferences node = ToolStateControlUtils.getPlatformRelativeToolStatePreferences();
        try {
            if (node != null) {
                node.put(ToolStateControlUtils.computeToolKeyForPlatformStateChange(toolID), String.valueOf(state));
                node.flush();
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public static void setToolAuthorityState(String toolID, boolean state) {
        Preferences node = ToolStateControlUtils.getPlatformRelativeToolStatePreferences();
        try {
            if (node != null) {
                node.put(ToolStateControlUtils.computeToolKeyForAuthority(toolID), String.valueOf(state));
                node.flush();
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isToolAutoEnabledByPlatform(String toolID) {
        Preferences node = ToolStateControlUtils.getPlatformRelativeToolStatePreferences();
        try {
            if (node != null) {
                String state = node.get(ToolStateControlUtils.computeToolKeyForPlatformStateChange(toolID), TRUE);
                return Boolean.valueOf(state);
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static boolean isToolAutoEnabledByAhthority(String toolID) {
        Preferences node = ToolStateControlUtils.getPlatformRelativeToolStatePreferences();
        try {
            if (node != null) {
                String state = node.get(ToolStateControlUtils.computeToolKeyForAuthority(toolID), TRUE);
                return Boolean.valueOf(state);
            }
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private static Preferences getPlatformRelativeToolStatePreferences() {
        return PlatformCoreActivator.getDefault().getPreferenceNode("com.vendor.platform.core", TOOL_STATE_NODE);
    }

    public static void autoEnableToolsForPlatform() {
        List installIUs;
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = m.collectFeatureToolsAndPlatform(installIUs = m.getInstalledToolAndPlatformIUs());
        if (installTools != null && installTools.size() > 0) {
            IDeviceManager deviceManager = DeviceManager.getInstance();
            int i = 0;
            while (i < installTools.size()) {
                ToolDescriptor tool = (ToolDescriptor)installTools.get(i);
                if (!BundleUtils.isToolEnabled(tool) && !ToolStateControlUtils.isToolAutoEnabledByPlatform(tool.getId())) {
                    ToolStateControlUtils.setToolPlatformRelativeState(tool.getId(), true);
                    ToolStateControlUtils.autoEnableTools(deviceManager.getCurrentDevice(), tool);
                }
                ++i;
            }
        }
    }

    public static void autoEnableToolForAuthority(ToolDescriptor input) {
        List installIUs;
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = m.collectFeatureToolsAndPlatform(installIUs = m.getInstalledToolAndPlatformIUs());
        if (installTools != null && installTools.size() > 0) {
            IDeviceManager deviceManager = DeviceManager.getInstance();
            int i = 0;
            while (i < installTools.size()) {
                ToolDescriptor tool = (ToolDescriptor)installTools.get(i);
                String name = (String)tool.getProperties().get("tool.name");
                String inputName = (String)input.getProperties().get("tool.name");
                if (name != null && inputName != null && name.equals(inputName)) {
                    if (BundleUtils.isToolEnabled(tool) || ToolStateControlUtils.isToolAutoEnabledByAhthority(tool.getId())) break;
                    ToolStateControlUtils.setToolAuthorityState(tool.getId(), true);
                    ToolStateControlUtils.autoEnableTools(deviceManager.getCurrentDevice(), tool);
                    break;
                }
                ++i;
            }
        }
    }

    public static void autoPlatformDisabledTools() {
        List installIUs;
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = m.collectFeatureTools(installIUs = m.getInstalledToolIUs());
        if (installTools != null && installTools.size() > 0) {
            int i = 0;
            while (i < installTools.size()) {
                final ToolDescriptor tool = (ToolDescriptor)installTools.get(i);
                if (BundleUtils.isToolEnabled(tool)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BundleUtils.closeToolPerspective(tool);
                            PerspectiveUtil.removePerspectiveShortcut(tool);
                            ToolUpdateUtils.setToolEnableState(tool, false);
                            ToolStateControlUtils.setToolPlatformRelativeState(tool.getId(), false);
                        }
                    });
                }
                ++i;
            }
        }
    }

    public static void autoEnableTools(String device, ToolDescriptor tool) {
        if (device == null || tool == null) {
            return;
        }
        if (!ToolStateControlUtils.isToolAutoEnabledByPlatform(tool.getId())) {
            return;
        }
        if (!ToolStateControlUtils.isToolAutoEnabledByAhthority(tool.getId())) {
            return;
        }
        if (!BundleUtils.suitableForChip(tool, device)) {
            return;
        }
        ToolStateControlUtils.autoEnableToolsDetail(tool);
    }

    public static void updateToolStateForChipChange(String device, ToolDescriptor tool, boolean b) {
        if (device == null || tool == null) {
            return;
        }
        if (!ToolStateControlUtils.isToolAutoEnabledByPlatform(tool.getId())) {
            return;
        }
        if (!ToolStateControlUtils.isToolAutoEnabledByAhthority(tool.getId())) {
            return;
        }
        ToolStateControlUtils.updateToolStateForChipChangeDetail(tool, true);
    }

    public static void autoAuthorityDisabledTool(String toolName) {
        List installIUs;
        IToolManager m = PlatformCoreActivator.getDefault().getToolManager();
        List installTools = m.collectFeatureTools(installIUs = m.getInstalledToolIUs());
        if (installTools != null && installTools.size() > 0) {
            int i = 0;
            while (i < installTools.size()) {
                final ToolDescriptor tool = (ToolDescriptor)installTools.get(i);
                String name = (String)tool.getProperties().get("tool.name");
                if (name != null && name.equals(toolName)) {
                    if (!BundleUtils.isToolEnabled(tool)) break;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            BundleUtils.closeToolPerspective(tool);
                            PerspectiveUtil.removePerspectiveShortcut(tool);
                            ToolUpdateUtils.setToolEnableState(tool, false);
                            ToolStateControlUtils.setToolAuthorityState(tool.getId(), false);
                        }
                    });
                    break;
                }
                ++i;
            }
        }
    }

    public static void reDisableToolsForBundleStateRestore(ToolDescriptor tool) {
        boolean needDisableTool;
        if (tool == null) {
            return;
        }
        boolean originalEnabled = BundleUtils.isToolEnabled(tool);
        if (!originalEnabled) {
            return;
        }
        boolean toolHandState = true;
        String toolHandStatePreferences = ToolStateControlUtils.getToolHandStatePreferences(tool);
        if (toolHandStatePreferences.length() > 0) {
            toolHandState = Boolean.valueOf(toolHandStatePreferences);
        }
        boolean bl = needDisableTool = !toolHandState || !ToolStateControlUtils.isToolAutoEnabledByPlatform(tool.getId()) || !ToolStateControlUtils.isToolAutoEnabledByAhthority(tool.getId());
        if (needDisableTool) {
            List list = tool.getPlugins();
            if (list.size() == 0) {
                return;
            }
            for (Object o : list) {
                ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
                BundleUtils.setBundleEnabled(p.getPluginId(), false);
            }
        }
    }

    public static String computeToolKeyForPlatformStateChange(String toolID) {
        return String.valueOf(toolID) + "_platform_state";
    }

    public static String computeToolKeyForAuthority(String toolID) {
        return String.valueOf(toolID) + "_authority";
    }

    public static String getToolStatePreferences(ToolDescriptor tool) {
        Preferences node = PlatformCoreActivator.getDefault().getPreferenceNode("com.vendor.platform.core", TOOL_STATE_AUTO_MODIFY_FOR_CHIP_NODE);
        return node.get(tool.getId(), "");
    }

    public static void setAutoModifyToolState(ToolDescriptor tool, Boolean state) {
        Preferences node = PlatformCoreActivator.getDefault().getPreferenceNode("com.vendor.platform.core", TOOL_STATE_AUTO_MODIFY_FOR_CHIP_NODE);
        if (state == null) {
            node.remove(tool.getId());
        } else if (state.booleanValue()) {
            node.remove(tool.getId());
        } else {
            node.put(tool.getId(), String.valueOf(state));
        }
        try {
            node.flush();
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public static String getToolHandStatePreferences(ToolDescriptor tool) {
        Preferences node = PlatformCoreActivator.getDefault().getPreferenceNode("com.vendor.platform.core", TOOL_STATE_HAND_MODIFY_NODE);
        return node.get(tool.getId(), "");
    }

    public static void setHandModifyToolState(ToolDescriptor tool, Boolean state) {
        Preferences node = PlatformCoreActivator.getDefault().getPreferenceNode("com.vendor.platform.core", TOOL_STATE_HAND_MODIFY_NODE);
        if (state == null) {
            node.remove(tool.getId());
        } else if (state.booleanValue()) {
            node.remove(tool.getId());
        } else {
            node.put(tool.getId(), String.valueOf(state));
        }
        try {
            node.flush();
        }
        catch (Exception e) {
            PlatformCoreActivator.getLogger((Plugin)PlatformCoreActivator.getDefault()).logError(e.getMessage(), (Throwable)e);
        }
    }

    public static void updateToolStateForChipChangeDetail(ToolDescriptor tool, boolean enabled) {
        if (tool == null) {
            return;
        }
        List list = tool.getPlugins();
        if (list.size() == 0) {
            return;
        }
        boolean originalEnabled = BundleUtils.isToolEnabled(tool);
        if (enabled == originalEnabled) {
            if (!originalEnabled) {
                ToolStateControlUtils.setAutoModifyToolState(tool, enabled);
            }
            return;
        }
        if (!originalEnabled) {
            Boolean b;
            if (RegisterUtils.isExpire(tool.getProperties())) {
                return;
            }
            String toolHandStatePreferences = ToolStateControlUtils.getToolHandStatePreferences(tool);
            if (toolHandStatePreferences.length() > 0 && !(b = Boolean.valueOf(toolHandStatePreferences)).booleanValue()) {
                ToolStateControlUtils.setAutoModifyToolState(tool, enabled);
                return;
            }
        }
        if (enabled) {
            String toolStatePreferences = ToolStateControlUtils.getToolStatePreferences(tool);
            if (toolStatePreferences.length() == 0) {
                return;
            }
        } else {
            try {
                BundleUtils.closeToolPerspective(tool);
            }
            catch (Exception exception) {}
            try {
                PerspectiveUtil.removePerspectiveShortcut(tool);
            }
            catch (Exception exception) {}
        }
        ToolStateControlUtils.setAutoModifyToolState(tool, enabled);
        for (Object o : list) {
            ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
            BundleUtils.setBundleEnabled(p.getPluginId(), enabled);
        }
    }

    public static void autoEnableToolsDetail(ToolDescriptor tool) {
        if (tool == null) {
            return;
        }
        List list = tool.getPlugins();
        if (list.size() == 0) {
            return;
        }
        boolean originalEnabled = BundleUtils.isToolEnabled(tool);
        if (originalEnabled) {
            return;
        }
        if (!originalEnabled) {
            Boolean b;
            if (RegisterUtils.isExpire(tool.getProperties())) {
                return;
            }
            String toolHandStatePreferences = ToolStateControlUtils.getToolHandStatePreferences(tool);
            if (toolHandStatePreferences.length() > 0 && !(b = Boolean.valueOf(toolHandStatePreferences)).booleanValue()) {
                return;
            }
        }
        for (Object o : list) {
            ToolDescriptor.PluginDetail p = (ToolDescriptor.PluginDetail)o;
            BundleUtils.setBundleEnabled(p.getPluginId(), true);
        }
    }
}

