/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.internal;

import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.PlatformUIActivator;
import com.vendor.platform.ui.internal.ControlFactory;
import com.vendor.platform.ui.internal.MenuUtils;
import com.vendor.platform.ui.internal.RadioButtonsArea;
import java.io.File;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdateDeviceDialog
extends Dialog {
    private Text fileField;
    private RadioButtonsArea radios;

    public UpdateDeviceDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UpdateDeviceDialog_0);
        newShell.setSize(480, 200);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.radios = new RadioButtonsArea(comp, null, 2, new String[][]{{Messages.UpdateDeviceDialog_1, "replace"}, {Messages.UpdateDeviceDialog_3, "append"}});
        this.radios.setSelectedButton(0);
        Composite c = ControlFactory.createCompositeEx(comp, 3, 772, 1);
        this.fileField = ControlFactory.createFileField(c, Messages.UpdateDeviceDialog_5, Messages.UpdateDeviceDialog_6, null);
        return comp;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String file = this.fileField.getText();
            if (file.length() == 0) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.UpdateDeviceDialog_7, (String)Messages.UpdateDeviceDialog_8);
                return;
            }
            File chipList = new File(file);
            if (!chipList.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpdateDeviceDialog_9, (String)Messages.UpdateDeviceDialog_10);
                return;
            }
            String rs = "";
            if (rs.length() > 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpdateDeviceDialog_11, (String)rs);
            } else {
                String selectedValue = this.radios.getSelectedValue();
                try {
                    if (selectedValue.equals("replace")) {
                        PlatformUIActivator.getDefault().getDeviceManager().updateDevices(chipList, true);
                    } else if (selectedValue.equals("append")) {
                        PlatformUIActivator.getDefault().getDeviceManager().updateDevices(chipList, false);
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpdateDeviceDialog_9, (String)e.getMessage());
                    return;
                }
                MenuUtils.refreshDeviceMenu();
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(Messages.UPDATE_DEVICE_LOG);
                this.okPressed();
            }
            return;
        }
        if (1 == buttonId) {
            this.cancelPressed();
        }
    }
}

