/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.tool;

import com.vendor.platform.core.IPreferenceStorageManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.PlatformUIActivator;
import com.vendor.platform.ui.internal.ControlFactory;
import com.vendor.platform.ui.internal.RadioButtonsArea;
import java.io.File;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ConfigurationManagementDialog
extends Dialog {
    private Text filePath;
    private IPreferenceStore preferenceStore;
    private ToolDescriptor tool;
    private RadioButtonsArea radios;
    private static final int IMPORT_MODE = 0;
    private static final int EXPORT_MODE = 1;

    public ConfigurationManagementDialog(Shell parentShell, ToolDescriptor tool) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tool = tool;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ConfigurationManagementDialog_0);
        newShell.setSize(360, 200);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        parent.setLayoutData((Object)data);
        Button excute = this.createButton(parent, 0, Messages.ConfigurationManagementDialog_1, true);
        Button close = this.createButton(parent, 1, Messages.ConfigurationManagementDialog_2, false);
        GridData executeGD = (GridData)excute.getLayoutData();
        executeGD.horizontalAlignment = 0x1000000;
        executeGD.grabExcessHorizontalSpace = true;
        GridData closeGD = (GridData)close.getLayoutData();
        closeGD.horizontalAlignment = 0x1000000;
        closeGD.grabExcessHorizontalSpace = true;
    }

    protected void okPressed() {
        try {
            if (!this.process()) {
                return;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_3, (String)(String.valueOf(Messages.ConfigurationManagementDialog_4) + e.getMessage()));
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    private boolean process() {
        String path = this.filePath.getText();
        if (path == null || path.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_5, (String)Messages.ConfigurationManagementDialog_6);
            return false;
        }
        File file = new File(path);
        int mode = this.radios.getSeletedIndex();
        String[] plugins = this.tool.getPluginIds();
        IPreferenceStorageManager manager = PlatformCoreActivator.getDefault().getPreferenceStorageManager();
        if (mode == 0) {
            if (!file.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_7, (String)(String.valueOf(Messages.ConfigurationManagementDialog_8) + file.getName() + Messages.ConfigurationManagementDialog_9));
                return false;
            }
            if (manager.importPreferences(plugins, file)) {
                PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)this.tool.getProperties().get("tool.name")) + " : " + Messages.CONFIGURATION_IMPORT_LOG);
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_10, (String)Messages.ConfigurationManagementDialog_11);
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_12, (String)Messages.ConfigurationManagementDialog_13);
            }
        } else if (manager.exportPreferences(plugins, file)) {
            PlatformCoreActivator.getLogger((Plugin)PlatformUIActivator.getDefault()).logInfo(String.valueOf((String)this.tool.getProperties().get("tool.name")) + " : " + Messages.CONFIGURATION_EXPORT_LOG);
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_14, (String)Messages.ConfigurationManagementDialog_15);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ConfigurationManagementDialog_16, (String)Messages.ConfigurationManagementDialog_17);
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.radios = new RadioButtonsArea(comp, Messages.ConfigurationManagementDialog_18, 2, new String[][]{{Messages.ConfigurationManagementDialog_19, "import"}, {Messages.ConfigurationManagementDialog_21, "export"}});
        Composite c = ControlFactory.createCompositeEx(comp, 3, 772, 1);
        this.filePath = ControlFactory.createFileField(c, Messages.ConfigurationManagementDialog_23, Messages.ConfigurationManagementDialog_24, null);
        return comp;
    }

    public IPreferenceStore getPreferenceStore(String pluginId) {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), pluginId);
        }
        return this.preferenceStore;
    }
}

