/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.tool;

import com.vendor.platform.core.IToolManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.core.internal.DeviceManager;
import com.vendor.platform.ui.Messages;
import com.vendor.platform.ui.internal.BundleUtils;
import com.vendor.platform.ui.internal.ControlFactory;
import com.vendor.platform.ui.internal.EncryptZipUtil;
import com.vendor.platform.ui.internal.RegisterUtils;
import com.vendor.platform.ui.internal.TestBuildUtils;
import com.vendor.platform.ui.internal.ToolStateControlUtils;
import com.vendor.platform.ui.internal.ToolUpdateUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpgradeToolDialog
extends Dialog {
    private static final int LABEL_WIDTH = 100;
    private Text nameField;
    private Text versionField;
    private Text providerField;
    private Text releaseDateField;
    private Text stateField;
    private Text registerStateField;
    private Text upgradeNameField;
    private Text upgradeVersionField;
    private Text upgradeProviderField;
    private Text upgradeReleaseDateField;
    private Label statusLabel;
    private Text upgradeZipFile;
    private Button upgradeButton;
    private ToolDescriptor tool;
    private ToolDescriptor upgradeTool;
    private ToolDescriptor installedNewTool;
    private boolean upgrade = false;
    private IToolManager toolManager;
    private final boolean[] updating = new boolean[1];
    private String installZip;
    private List<ToolDescriptor> newInstalledTools;

    public UpgradeToolDialog(Shell parentShell, ToolDescriptor tool) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tool = tool;
        this.toolManager = PlatformCoreActivator.getDefault().getToolManager();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UpgradeToolDialog_0);
        newShell.setSize(600, 350);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(4, 0x1000000, true, false);
        parent.setLayoutData((Object)data);
        this.upgradeButton = this.createButton(parent, 0, Messages.UpgradeToolDialog_1, true);
        Button cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        GridData upgradeGD = (GridData)this.upgradeButton.getLayoutData();
        upgradeGD.horizontalAlignment = 0x1000000;
        upgradeGD.grabExcessHorizontalSpace = true;
        GridData cancelGD = (GridData)cancelButton.getLayoutData();
        cancelGD.horizontalAlignment = 0x1000000;
        cancelGD.grabExcessHorizontalSpace = true;
        this.upgradeButton.setEnabled(false);
    }

    protected void okPressed() {
        this.doUpgrade();
    }

    public ToolDescriptor getNewTool() {
        return this.installedNewTool;
    }

    private boolean doUpgrade() {
        if (!this.updating[0]) {
            this.updating[0] = true;
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
            try {
                pmd.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask(Messages.UpgradeToolDialog_2, -1);
                                ToolStateControlUtils.setAutoModifyToolState(UpgradeToolDialog.this.tool, null);
                                UpgradeToolDialog.this.toolManager.uninstallIU(((UpgradeToolDialog)UpgradeToolDialog.this).tool.iu, (IProgressMonitor)new NullProgressMonitor());
                                UpgradeToolDialog.this.toolManager.installIU(UpgradeToolDialog.this.installZip, ((UpgradeToolDialog)UpgradeToolDialog.this).upgradeTool.iu, (IProgressMonitor)new NullProgressMonitor());
                                IInstallableUnit iu = UpgradeToolDialog.this.toolManager.findInstallIU(((UpgradeToolDialog)UpgradeToolDialog.this).upgradeTool.iu.getId(), ((UpgradeToolDialog)UpgradeToolDialog.this).upgradeTool.iu.getVersion().toString());
                                if (iu != null) {
                                    UpgradeToolDialog.this.installedNewTool = new ToolDescriptor(iu);
                                    UpgradeToolDialog.this.newInstalledTools.add(UpgradeToolDialog.this.installedNewTool);
                                    DeviceManager deviceManager = (DeviceManager)DeviceManager.getInstance();
                                    deviceManager.combinedNewToolSuiltableChips((String)UpgradeToolDialog.this.installedNewTool.getProperties().get("build.id"), (String)UpgradeToolDialog.this.installedNewTool.getProperties().get("Chips"));
                                }
                                UpgradeToolDialog.this.clean();
                                UpgradeToolDialog.this.setReturnCode(0);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        UpgradeToolDialog.this.close();
                                        ToolUpdateUtils.requestRestart(3);
                                    }
                                });
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)UpgradeToolDialog.this.getShell(), (String)Messages.UpgradeToolDialog_7, (String)e.getMessage());
                                ((UpgradeToolDialog)UpgradeToolDialog.this).updating[0] = false;
                            }
                        }
                        finally {
                            ((UpgradeToolDialog)UpgradeToolDialog.this).updating[0] = false;
                        }
                    }
                });
            }
            catch (Exception exception) {
                this.updating[0] = false;
            }
        }
        return true;
    }

    protected void clean() {
        EncryptZipUtil.cleanFolder(PlatformCoreActivator.getDefault().getStateLocation().append("temp").toFile());
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.statusLabel = ControlFactory.createLabel(comp, Messages.UpgradeToolDialog_8, 1);
        this.statusLabel.setForeground(this.getShell().getDisplay().getSystemColor(6));
        this.createInstallInfoGroup(comp);
        this.createUpgradInfoGroup(comp);
        this.initData();
        return comp;
    }

    private void initData() {
        if (this.tool != null) {
            ToolDescriptor.ToolProperties props = this.tool.props;
            this.nameField.setText(this.trim(props.getName()));
            this.versionField.setText(this.trim(props.getVersion()));
            this.providerField.setText(this.trim(props.getProvider()));
            this.releaseDateField.setText(this.trim(props.getReleaseDate()));
            boolean enabled = BundleUtils.isToolEnabled(this.tool);
            this.stateField.setText(enabled ? Messages.UpgradeToolDialog_9 : Messages.UpgradeToolDialog_10);
            if (TestBuildUtils.isTestBuild(this.tool.getProperties())) {
                this.registerStateField.setText(Messages.UpgradeToolDialog_11);
            } else if (RegisterUtils.isUnlimited(this.tool.getProperties())) {
                this.registerStateField.setText(Messages.UpgradeToolDialog_11);
            } else {
                Date register = RegisterUtils.getRegisterDate(this.tool.getProperties());
                if (register != null) {
                    this.registerStateField.setText(Messages.UpgradeToolDialog_12);
                } else {
                    String desc = String.valueOf(Messages.UpgradeToolDialog_13) + RegisterUtils.getRemainingTrialPeriod(this.tool);
                    this.registerStateField.setText(desc);
                }
            }
            this.refreshUpgradeButton();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void refreshUpgradeInfo(String zipFile) {
        try {
            if (zipFile.length() == 0) {
                return;
            }
            this.installZip = zipFile;
            if (!EncryptZipUtil.isEncrypted(new File(zipFile))) ** GOTO lbl17
            path = PlatformCoreActivator.getDefault().getStateLocation().append("temp");
            pathFile = new File(path.toOSString());
            if (!pathFile.exists() && !pathFile.mkdirs()) {
                return;
            }
            this.installZip = path.append(new File(zipFile).getName()).toOSString();
            iZipFile = new File(this.installZip);
            if (iZipFile.exists() && !iZipFile.delete()) {
                return;
            }
            try {
                EncryptZipUtil.decryptZip(new File(zipFile), iZipFile);
lbl17:
                // 2 sources

                if ((unit = this.toolManager.findToolUnit(this.installZip, (IProgressMonitor)new NullProgressMonitor())) == null) {
                    this.installZip = null;
                    this.upgradeTool = null;
                    this.clearInputText();
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpgradeToolDialog_14, (String)Messages.UpgradeToolDialog_15);
                } else {
                    this.upgradeTool = new ToolDescriptor(unit);
                    props = this.upgradeTool.props;
                    this.upgradeNameField.setText(this.trim(props.getName()));
                    this.upgradeVersionField.setText(this.trim(props.getVersion()));
                    this.upgradeProviderField.setText(this.trim(props.getProvider()));
                    this.upgradeReleaseDateField.setText(this.trim(props.getReleaseDate()));
                }
                this.refreshUpgradeButton();
            }
            catch (Exception v0) {
                this.installZip = null;
                this.upgradeTool = null;
                this.clearInputText();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.UpgradeToolDialog_16, (String)Messages.UpgradeToolDialog_17);
            }
        }
        finally {
            this.refreshUpgradeButton();
        }
    }

    private void clearInputText() {
        try {
            this.upgradeNameField.setText("");
            this.upgradeVersionField.setText("");
            this.upgradeProviderField.setText("");
            this.upgradeReleaseDateField.setText("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshUpgradeButton() {
        boolean state = false;
        if (this.upgradeTool != null && this.upgradeButton != null) {
            if (this.upgradeTool.getVersion().compareTo(this.tool.getVersion()) == 0) {
                String upgradeQualifier = this.upgradeTool.props.getReleaseDate();
                String oldQualifier = this.tool.props.getProperty("version");
                if (upgradeQualifier == null && oldQualifier == null) {
                    state = this.noUpdating();
                } else if (upgradeQualifier == null && oldQualifier != null) {
                    state = this.uiDown();
                } else if (upgradeQualifier != null && oldQualifier == null) {
                    state = this.uiUpgrade();
                } else if (upgradeQualifier != null && oldQualifier != null) {
                    long upgradeTimeLong = 0L;
                    long oldTimeLong = 0L;
                    if (upgradeQualifier.indexOf("_") > 0) {
                        try {
                            upgradeTimeLong = Long.parseLong(upgradeQualifier.split("_")[0]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    if (oldQualifier.indexOf("_") > 0) {
                        try {
                            oldTimeLong = Long.parseLong(oldQualifier.split("_")[0]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    state = upgradeTimeLong > oldTimeLong ? this.uiUpgrade() : (upgradeTimeLong < oldTimeLong ? this.uiDown() : this.noUpdating());
                }
            } else {
                state = this.upgradeTool.getVersion().compareTo(this.tool.getVersion()) > 0 ? this.uiUpgrade() : this.uiDown();
            }
        }
        if (this.upgradeButton != null && !this.upgradeButton.isDisposed()) {
            this.upgradeButton.setEnabled(state);
        }
    }

    private boolean noUpdating() {
        this.statusLabel.setText(Messages.UpgradeToolDialog_18);
        boolean state = false;
        return state;
    }

    private boolean uiDown() {
        this.statusLabel.setText(Messages.UpgradeToolDialog_21);
        this.upgradeButton.setText(Messages.UpgradeToolDialog_22);
        return true;
    }

    private boolean uiUpgrade() {
        this.statusLabel.setText(Messages.UpgradeToolDialog_19);
        this.upgradeButton.setText(Messages.UpgradeToolDialog_20);
        this.upgrade = true;
        return true;
    }

    private void createUpgradInfoGroup(Composite comp) {
        Group group = ControlFactory.createGroup(comp, Messages.UpgradeToolDialog_23, 4);
        Composite c = ControlFactory.createComposite((Composite)group, 3, 0, 768, 4);
        GridLayout layout = (GridLayout)c.getLayout();
        layout.marginWidth = 0;
        this.upgradeZipFile = ControlFactory.createFileFieldWithWidth(c, Messages.UpgradeToolDialog_24, Messages.UpgradeToolDialog_25, 100, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UpgradeToolDialog.this.refreshUpgradeInfo(UpgradeToolDialog.this.upgradeZipFile.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.upgradeZipFile.setEditable(false);
        this.upgradeNameField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_26, 2048, 100, null);
        this.upgradeVersionField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_27, 2048, 100, null);
        this.upgradeProviderField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_28, 2048, 100, null);
        this.upgradeReleaseDateField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_29, 2048, 100, null);
        ControlFactory.setEditable(false, this.upgradeNameField, this.upgradeVersionField, this.upgradeProviderField, this.upgradeReleaseDateField);
    }

    private void createInstallInfoGroup(Composite comp) {
        Group group = ControlFactory.createGroup(comp, Messages.UpgradeToolDialog_30, 4);
        this.nameField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_31, 2048, 100, null);
        this.versionField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_32, 2048, 100, null);
        this.providerField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_33, 2048, 100, null);
        this.releaseDateField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_34, 2048, 100, null);
        this.stateField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_35, 2048, 100, null);
        this.registerStateField = ControlFactory.createLabeledTextWithWidth((Composite)group, Messages.UpgradeToolDialog_36, 2048, 100, null);
        ControlFactory.setEditable(false, this.nameField, this.versionField, this.providerField, this.releaseDateField, this.stateField, this.registerStateField);
    }

    public String trim(String str) {
        return str == null ? "N/A" : str.trim();
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setNewInstalledTools(List<ToolDescriptor> newInstalledTools) {
        this.newInstalledTools = newInstalledTools;
    }
}

