/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.platform.ui.update;

import com.vendor.platform.core.IToolManager;
import com.vendor.platform.core.PlatformCoreActivator;
import com.vendor.platform.core.ToolDescriptor;
import com.vendor.platform.ui.internal.EncryptZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class UpdateFileChecker
implements Runnable {
    private static final String DIR_UPDATES = "updates/";
    private static final String UPDATE_EXT = ".upd";
    private static final String UPDATE_ZIP = ".zip";
    public static final UpdateFileChecker INSTANCE = new UpdateFileChecker();
    HashMap<String, ToolDescriptor> updateFileList = new HashMap();
    protected boolean isOK = false;

    private UpdateFileChecker() {
    }

    public boolean isOK() {
        return this.isOK;
    }

    public HashMap<String, ToolDescriptor> getUpdateFileList() {
        return this.updateFileList;
    }

    @Override
    public void run() {
        File[] files;
        File dirUpdates = new File(String.valueOf(Platform.getInstallLocation().getURL().getFile()) + DIR_UPDATES);
        if (!dirUpdates.exists()) {
            this.isOK = true;
            return;
        }
        IToolManager toolManager = PlatformCoreActivator.getDefault().getToolManager();
        File[] fileArray = files = dirUpdates.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                File file = fileArray[n2];
                if (!file.isDirectory() && file.getAbsolutePath().endsWith(UPDATE_EXT)) {
                    File unzip = null;
                    try {
                        unzip = new File(String.valueOf(file.getCanonicalPath()) + UPDATE_ZIP);
                    }
                    catch (IOException exce) {
                        exce.printStackTrace();
                    }
                    if (unzip != null) {
                        EncryptZipUtil.decryptZip(file, unzip);
                        if (file.delete() && unzip.exists()) {
                            ToolDescriptor tool;
                            block11: {
                                tool = null;
                                try {
                                    IInstallableUnit unit = toolManager.findToolUnit(unzip.getCanonicalPath(), (IProgressMonitor)new NullProgressMonitor());
                                    if (unit == null) break block11;
                                    tool = new ToolDescriptor(unit);
                                }
                                catch (Exception exception) {
                                    break block12;
                                }
                            }
                            try {
                                this.updateFileList.put(unzip.getCanonicalPath(), tool);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        this.isOK = true;
    }
}

