/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.analysis;

import java.util.ArrayList;

public class TimeLogger {
    private ArrayList<String> partLogs = new ArrayList();
    private long logStartTime;
    private long logTotalTime;
    private long logSizePart;
    private long logSizeTotal;
    private String currentPartTitle;

    public void logStart(String partTitle, long size) {
        if (this.logStartTime != 0L) {
            return;
        }
        this.logStartTime = System.currentTimeMillis();
        this.currentPartTitle = partTitle;
        this.logSizePart = size;
        this.logSizeTotal += size;
    }

    public void logEnd() {
        if (this.logStartTime == 0L) {
            return;
        }
        long logTime = System.currentTimeMillis() - this.logStartTime;
        this.logTotalTime += logTime;
        this.logStartTime = 0L;
        this.partLogs.add(String.valueOf(this.currentPartTitle) + " (Size = " + this.logSizePart + ") : " + logTime + " ms");
    }

    public String exportLog(String title) {
        StringBuilder builder = new StringBuilder();
        builder.append("================================================================================\n");
        builder.append(title);
        builder.append(" ---- Total Size: ");
        builder.append(this.logSizeTotal);
        builder.append(" ---- Total Time: ");
        builder.append(this.logTotalTime);
        builder.append(" ms");
        builder.append("\n\n");
        for (String str : this.partLogs) {
            builder.append(str);
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("================================================================================\n");
        return builder.toString();
    }
}

