/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.FlashType;

public class EraseCommand
extends SerialCommand {
    private static final String KEY_ERASE = "erase";
    private static final String KEY_EMMC_ERASE = "mmc erase";

    public EraseCommand(String command) {
        this.setCommand(command);
    }

    public static EraseCommand erase(FlashType flashType, String address, String length) {
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.spi) {
            sb.append("sf");
        } else {
            sb.append(flashType.name());
        }
        sb.append(" ").append(KEY_ERASE).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        EraseCommand eraseCommand = new EraseCommand(sb.toString());
        eraseCommand.setTimeout(EraseCommand.calTimeout(length, flashType));
        return eraseCommand;
    }

    public static EraseCommand eraseEmmc(String startAddress, String length, String timeout) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_EMMC_ERASE);
        sb.append(" ").append(0);
        sb.append(" ").append(startAddress).append(" ");
        sb.append(length);
        EraseCommand eraseCommand = new EraseCommand(sb.toString());
        eraseCommand.setTimeout(EraseCommand.calTimeout(timeout, FlashType.emmc));
        return eraseCommand;
    }

    public static int calTimeout(String length, FlashType flashType) {
        int timeout = 30000;
        int unit = 3000;
        if (flashType == FlashType.spi) {
            unit = 30000;
        } else if (flashType == FlashType.nand) {
            unit = 15000;
        } else if (flashType == FlashType.emmc) {
            unit = 15000;
        }
        if (length == null || length.length() == 0) {
            return timeout;
        }
        long parseLong = EraseCommand.getLength(length);
        timeout = (int)((long)unit * (parseLong / 0x100000L + 1L));
        return timeout;
    }
}

