/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.Messages;
import com.vendor.burn.analysis.TimeLogger;
import com.vendor.burn.jna.I2cDllByJNA;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FT_STATUS;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.utilitily.I2cUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class I2cCommand {
    private static int baudRate;
    private static int deviceAddress;
    private static boolean connected;
    private static final int DEFAULT_CHANNEL_ID = 0;
    private static final int I2C_BUFFER_LEN = 7;
    private static final int MW_DB_CMD_TYPE_DB = 3;
    public static final int I2C_RUN_CMD_LEN = 127;
    public static final int I2C_RUN_BUFFER_LEN = 124;
    public static final int I2C_RUN_MAX_INDEX = 256;
    public static final int UPGRADE_FAIL = -1;
    public static final int UPGRADE_RUN = 0;
    public static final int UPGRADE_FINISH = 1;
    public static final int BOOTROM_ADDRESS = 52;
    private static final int BOOTROM_DELAY = 15;
    private static final int BOOTROM_DELAY_CJ303V300 = 3;
    private static final int I2C_SLOW = 0;
    private static final int I2C_QUICK = 1;
    public static final int GET_CUR_RECEIVED_LEN = 1024;
    public static final int WAIT_BOOT_RUN_RECE_LEN = 256;
    public static final String CJXX0VXX1_DEFAULT_BAUDRATE = "400k";

    static {
        connected = false;
    }

    public static boolean I2cOpenChannel() {
        System.setProperty("jna.encoding", "GBK");
        String baudRateStr = FastbootPreferences.getBaudRate();
        baudRate = I2cUtils.getbaudRateValue(baudRateStr);
        deviceAddress = FastbootPreferences.getDeviceAddress();
        int mode = 0;
        String chipName = ToolUtils.getChipName();
        if (chipName == null) {
            mode = 0;
        } else if (chipName.equalsIgnoreCase("CJXX0VXX3")) {
            baudRate = I2cUtils.getbaudRateValue(CJXX0VXX1_DEFAULT_BAUDRATE);
            mode = 0;
        } else {
            mode = 1;
        }
        try {
            int openResult = I2cDllByJNA.instance.I2C_OpenChannel(0, baudRate, mode);
            if (I2cUtils.checkI2cReturn(openResult)) {
                connected = true;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            connected = false;
            return false;
        }
        catch (Error error) {
            connected = false;
            return false;
        }
    }

    public static boolean I2cOpenChannelForBootrom(int address, IFastbootProgressMonitor fastbootMonitor) {
        String baudRateStr;
        System.setProperty("jna.encoding", "GBK");
        if (ToolUtils.isCmdLine()) {
            baudRateStr = PropertiesUtility.queryForString("baudRate");
            if (baudRateStr == null || baudRateStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)"baudRate"));
                return false;
            }
        } else {
            baudRateStr = FastbootPreferences.getBaudRate();
        }
        baudRate = I2cUtils.getbaudRateValue(baudRateStr);
        deviceAddress = address;
        int mode = 0;
        String chipName = ToolUtils.getChipName();
        if (chipName == null) {
            mode = 0;
        } else if (chipName.equalsIgnoreCase("CJXX0VXX3")) {
            baudRate = I2cUtils.getbaudRateValue(CJXX0VXX1_DEFAULT_BAUDRATE);
            mode = 0;
        } else {
            mode = 1;
        }
        try {
            int openResult = I2cDllByJNA.instance.I2C_OpenChannel(0, baudRate, mode);
            if (I2cUtils.checkI2cReturn(openResult, fastbootMonitor)) {
                connected = true;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            connected = false;
            return false;
        }
        catch (Error error) {
            connected = false;
            return false;
        }
    }

    public static boolean sendI2cCmd(int sizetowrite, byte[] inputbuffer, int sizetoread, byte[] outputbuffer) throws IOException {
        int setCmdResult = -1;
        int sendCount = 1;
        int i2cDelay = FastbootPreferences.getI2cDelay();
        int i2cRetryCount = FastbootPreferences.getI2cRetryCount();
        try {
            while (setCmdResult != 0) {
                try {
                    Thread.sleep(i2cDelay);
                }
                catch (InterruptedException interruptedException) {}
                setCmdResult = I2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, sizetowrite, inputbuffer, sizetoread, outputbuffer);
                System.out.println("setCmdResult: " + setCmdResult + "sendCount: " + sendCount);
                if (++sendCount <= i2cRetryCount) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.Message_FT_I2C);
                }
            });
            return false;
        }
        catch (Error error) {
            connected = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.Message_FT_I2C);
                }
            });
            return false;
        }
        return I2cUtils.checkI2cReturn(setCmdResult);
    }

    public static boolean sendI2cCmdForBootrom(int sizetowrite, byte[] inputbuffer, int sizetoread, byte[] outputbuffer, int i2cRetryCount, AbstractBurnerWorker worker) throws IOException {
        int setCmdResult = -1;
        int sendCount = 0;
        TimeLogger sendI2cTime = null;
        if (ToolUtils.isDebugOn()) {
            sendI2cTime = new TimeLogger();
            if (inputbuffer != null) {
                sendI2cTime.logStart("Send I2C input data", inputbuffer.length);
            } else if (outputbuffer != null) {
                sendI2cTime.logStart("Receive I2C output data", outputbuffer.length);
            }
        }
        int sleepTime = 15;
        if (FastbootView.isCJ303V3Series()) {
            sleepTime = 3;
        }
        try {
            while (setCmdResult != 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException interruptedException) {}
                setCmdResult = I2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, sizetowrite, inputbuffer, sizetoread, outputbuffer);
                if (++sendCount <= i2cRetryCount) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
        if (ToolUtils.isDebugOn() && sendI2cTime != null) {
            sendI2cTime.logEnd();
            worker.println("The retransmission times: " + sendCount);
            worker.println(sendI2cTime.exportLog("Single I2C time statistics"));
        }
        return setCmdResult == FT_STATUS.FT_OK.ordinal();
    }

    public static void I2cCloseChannel() {
        if (connected) {
            try {
                I2cDllByJNA.instance.I2C_CloseChannel(0);
                connected = false;
            }
            catch (Exception exception) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.Message_FT_I2C);
                    }
                });
            }
            catch (Error error) {
                connected = false;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.Message_FT_I2C);
                    }
                });
            }
        }
    }

    public static boolean sendUpgradeStart(int fileLen, boolean isCompress) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.MW_DB_SET_UPGRADE_START.ordinal();
        buffer[2] = (byte)(fileLen & 0xFF);
        buffer[3] = (byte)(fileLen >> 8 & 0xFF);
        buffer[4] = (byte)(fileLen >> 16 & 0xFF);
        buffer[5] = (byte)(fileLen >> 24 & 0xFF);
        buffer[6] = (byte)I2cCommand.booleanToInt(isCompress);
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean sendUpgradeRun(int index, byte[] runData) {
        byte[] buffer = new byte[127];
        buffer[1] = (byte)I2cCmd.MW_DB_SET_UPGRADE_RUN.ordinal();
        buffer[2] = (byte)index;
        int i = 3;
        while (i < 127) {
            buffer[i] = runData[i - 3];
            ++i;
        }
        int checksum = I2cCommand.checksumForRun(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean sendUpgradeFinish(int address, ChipID chipID) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.MW_DB_SET_UPGRADE_FINISH.ordinal();
        buffer[2] = (byte)(address & 0xFF);
        buffer[3] = (byte)(address >> 8 & 0xFF);
        buffer[4] = (byte)(address >> 16 & 0xFF);
        buffer[5] = (byte)(address >> 24 & 0xFF);
        buffer[6] = (byte)chipID.ordinal();
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        try {
            return I2cCommand.sendI2cCmd(buffer.length, buffer, 0, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    public static int sendGetUpgradeStatus(int i2cDelay, IFastbootProgressMonitor monitor) {
        byte[] buffer = new byte[7];
        buffer[1] = (byte)I2cCmd.MW_DB_SET_UPGRADE_STATUS.ordinal();
        buffer[2] = 0;
        buffer[3] = 0;
        buffer[4] = 0;
        buffer[5] = 0;
        buffer[6] = 0;
        int checksum = I2cCommand.checksum(buffer);
        int temp1 = 3;
        int temp2 = checksum << 4 & 0xF0;
        buffer[0] = (byte)(temp1 | temp2);
        I2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, buffer.length, buffer, 0, null);
        try {
            Thread.sleep(i2cDelay);
        }
        catch (InterruptedException interruptedException) {}
        if (ToolUtils.isDebugOn()) {
            monitor.println(I2cCommand.bytesToHexString(buffer));
        }
        byte[] readBuffer = new byte[1];
        I2cDllByJNA.instance.I2C_DeviceStream(0, deviceAddress, 0, null, 1, readBuffer);
        if (ToolUtils.isDebugOn()) {
            monitor.println(I2cCommand.bytesToHexString(readBuffer));
        }
        return readBuffer[0];
    }

    private static int checksum(byte[] i2cWriteCmd) {
        return i2cWriteCmd[1] + i2cWriteCmd[2] + i2cWriteCmd[3] + i2cWriteCmd[4] + i2cWriteCmd[5] + i2cWriteCmd[6] & 0xF;
    }

    private static int checksumForRun(byte[] i2cWriteCmd) {
        int total = 0;
        int i = 0;
        while (i < i2cWriteCmd.length) {
            if (i != 0) {
                total += i2cWriteCmd[i];
            }
            ++i;
        }
        return total & 0xF;
    }

    public static int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    public static int getBaudRate() {
        return baudRate;
    }

    public static int getDeviceAddress() {
        return deviceAddress;
    }

    public static enum I2cCmd {
        MW_DB_SET_UPGRADE_START,
        MW_DB_SET_UPGRADE_RUN,
        MW_DB_SET_UPGRADE_FINISH,
        MW_DB_SET_UPGRADE_STATUS;

    }
}

