/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.FlashType;
import java.util.Locale;

public class INFOCommand
extends SerialCommand {
    private static final String KEY_INFO = "info";
    private static final String KEY_GETINFO = "getinfo";
    private static final String KEY_BOOTMODE = "bootmode";
    private static final String KEY_VERSION = "version";
    private static final String KEY_DDRFREE = "ddrfree";
    private static final String KEY_GPT = "gpt";
    private static final String KEY_SERIAL = "setenv serial# ";
    private static final String KEY_FASTBOOT = "fastboot -l %s -s  %s usb 0";
    private static final String KEY_ENABLE_UDP_SERVICE = "fastboot -l %s -s  %s udp";

    private INFOCommand(String command) {
        this.setCommand(command);
    }

    public static INFOCommand getBootmode() {
        return new INFOCommand("getinfo bootmode");
    }

    public static INFOCommand getInfoGpt() {
        return new INFOCommand("getinfogpt");
    }

    public static INFOCommand getVersion() {
        return new INFOCommand("getinfo version");
    }

    public static INFOCommand getDDRFree() {
        return new INFOCommand("getinfo ddrfree");
    }

    public static INFOCommand info(FlashType flashType) {
        return new INFOCommand("getinfo " + flashType.name());
    }

    public static INFOCommand getUDPServiceCommand(String ddrFreeBaseAddr, String ddrfreeLength) {
        return new INFOCommand(String.format(Locale.ENGLISH, KEY_ENABLE_UDP_SERVICE, ddrFreeBaseAddr, ddrfreeLength));
    }

    public static INFOCommand getFastboot(String ddrStartAdd, String ddrfreeLength) {
        return new INFOCommand(String.format(Locale.ENGLISH, KEY_FASTBOOT, ddrStartAdd, ddrfreeLength));
    }

    public static INFOCommand getUsbSerial(String usbSerial) {
        return new INFOCommand(KEY_SERIAL + usbSerial);
    }
}

