/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.utilitily.ToolUtils;
import org.eclipse.jface.preference.IPreferenceStore;

public class MWCommand
extends SerialCommand {
    private static final String KEY_MW = "mw.b";
    public static final String HEX_0xFF = "0xFF";
    public static final String HEX_0x00 = "0x00";

    private MWCommand(String command, String length) {
        this.setCommand(command);
        this.init(length);
    }

    private void init(String length) {
        this.setTimeout(this.calculateTimeOut(length));
    }

    public static MWCommand mwAddress(String startAddress, String length) {
        String fillData = null;
        if (ToolUtils.isCmdLine()) {
            fillData = String.valueOf(PreferenceConfig.getImgFillData());
        } else {
            IPreferenceStore preferences = FastbootPreferences.getPreferenceStore();
            fillData = preferences.getString("vendor.burn.config.imageFill");
        }
        if (HEX_0xFF.equalsIgnoreCase(fillData)) {
            return MWCommand.mwAddress_0x00(startAddress, length);
        }
        return MWCommand.mwAddress_0xFF(startAddress, length);
    }

    private static MWCommand mwAddress_0xFF(String startAddress, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_MW).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startAddress).append(" ").append(HEX_0xFF).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new MWCommand(sb.toString(), length);
    }

    private static MWCommand mwAddress_0x00(String startAddress, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_MW).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startAddress).append(" ").append(HEX_0x00).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new MWCommand(sb.toString(), length);
    }

    @Override
    public int calculateTimeOut(String length) {
        int parseLong = Integer.parseInt(length, 16);
        return parseLong / 30;
    }
}

