/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.util.List;

public class MmcPartCommand
extends SerialCommand {
    public static final String MMC_PARTCONF = "mmc partconf";
    public static final String BOOT_ONE = " 0 0 1 1";
    public static final String BOOT_ONE_BOOT_ZERO = " 0 0 1 0";
    public static final String BOOT_TWO = " 0 0 2 2";
    public static final String BOOT_TWO_BOOT_ZERO = " 0 0 2 0";
    public static final String BOOT_ZERO = " 0 0 7 0";
    public static final String WRITEBEFORE = "writeBefore";
    public static final String BOOTONE = "boot1";
    public static final String BOOTTWO = "boot2";
    public static final String USERBOOT = "userBoot";

    private MmcPartCommand() {
    }

    public static void addMmcPartConfCommand(String writeBeforeOrAfter, List<SerialCommand> commands, FlashType flash, IBurner burner) {
        if (FastbootView.isCJ309V100_CA_N_Series() && flash == FlashType.emmc && !ToolUtils.isCmdLine()) {
            String emmcBootType = burner.getBurnContext().getEmmcBootType();
            if (emmcBootType.equalsIgnoreCase(BOOTONE)) {
                if (writeBeforeOrAfter.equalsIgnoreCase(WRITEBEFORE)) {
                    commands.add(new SerialCommand("mmc partconf 0 0 1 1"));
                } else {
                    commands.add(new SerialCommand("mmc partconf 0 0 1 0"));
                }
            } else if (emmcBootType.equalsIgnoreCase(BOOTTWO)) {
                if (writeBeforeOrAfter.equalsIgnoreCase(WRITEBEFORE)) {
                    commands.add(new SerialCommand("mmc partconf 0 0 2 2"));
                } else {
                    commands.add(new SerialCommand("mmc partconf 0 0 2 0"));
                }
            } else if (emmcBootType.equalsIgnoreCase(USERBOOT) && writeBeforeOrAfter.equalsIgnoreCase(WRITEBEFORE)) {
                commands.add(new SerialCommand("mmc partconf 0 0 7 0"));
            }
        }
    }
}

