/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.FlashType;

public class ReadCommand
extends SerialCommand {
    private static final String KEY_READ = "read";
    private static final String KEY_READ_YAFFS = "read.yaffs";

    private ReadCommand(String command, String length) {
        super(command);
        this.setTimeout(this.calculateTimeOut(length));
    }

    public static ReadCommand read(FlashType flashType, String destination, String original, String length) {
        return ReadCommand.read(flashType, KEY_READ, destination, original, length);
    }

    public static ReadCommand readYaffs(FlashType flashType, String destination, String original, String length) {
        return ReadCommand.read(flashType, KEY_READ_YAFFS, destination, original, length);
    }

    public static ReadCommand readMMC_0_Destination_(String destination, String original, String length, FlashType flashType) {
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.ufs) {
            sb.append("ufs").append(" ").append(KEY_READ).append(" ").append("0").append(" ");
        } else if (flashType == FlashType.ssd) {
            sb.append("nvme").append(" ").append(KEY_READ).append(" ");
        } else {
            sb.append("mmc").append(" ").append(KEY_READ).append(" ").append("0").append(" ");
        }
        if (!destination.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(destination).append(" ");
        if (!original.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(original).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        ReadCommand readCommand = new ReadCommand(sb.toString(), length);
        return readCommand;
    }

    private static ReadCommand read(FlashType flashType, String KEY, String destination, String original, String length) {
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.spi) {
            sb.append("sf");
        } else {
            sb.append(flashType.name());
        }
        sb.append(" ").append(KEY).append(" ");
        if (!destination.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(destination).append(" ");
        if (!original.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(original).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new ReadCommand(sb.toString(), length);
    }
}

