/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

public class SerialCommand {
    protected static final String BLANK = " ";
    protected static final String PREFIX_HEX = "0x";
    protected static final int TIMEOUT = 10000;
    private String command = null;
    private int timeout = 10000;

    public SerialCommand() {
    }

    public SerialCommand(String command) {
        this.init(command);
    }

    private void init(String command) {
        this.setCommand(command);
    }

    public String getCommand() {
        return this.command;
    }

    protected void setCommand(String command) {
        this.command = command;
    }

    public int getTimeout() {
        if (this.timeout < 10000) {
            this.timeout = 10000;
        }
        return this.timeout;
    }

    public int calculateTimeOut(String length) {
        return (int)(SerialCommand.getLength(length) / 8L);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected static Long getLength(String hexlength) {
        if (hexlength == null || hexlength.length() == 0) {
            return 0L;
        }
        int indexOf = hexlength.toLowerCase().indexOf("x");
        try {
            return Long.parseLong(hexlength.substring(indexOf + 1), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

