/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;

public class TFTPCommand
extends SerialCommand {
    private static final String KEY_TFTP = "tftp";

    private TFTPCommand(String command) {
        this.setCommand(command);
    }

    public static TFTPCommand download(File file, String address) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_TFTP).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ").append(file.getName());
        TFTPCommand tftpCommand = new TFTPCommand(sb.toString());
        tftpCommand.setTimeout(TFTPCommand.calculateTimeout(file.length()));
        return tftpCommand;
    }

    private static int calculateTimeout(long length) {
        int speed = 0;
        speed = ToolUtils.isCmdLine() ? PreferenceConfig.getTftpSpeed() : FastbootPreferences.getInt("vendor.burn.tftp.speed");
        if (speed == 0) {
            speed = 1024;
        }
        int tftpDownloadTimeout = 0;
        tftpDownloadTimeout = (int)((length / (long)speed + 2L) * 1000L);
        if (tftpDownloadTimeout < 1800000) {
            return tftpDownloadTimeout;
        }
        return (int)(length / (long)(speed * 500) + 1000L) * 1000;
    }

    public static TFTPCommand upload(File file, String address, String length) {
        StringBuilder sb = new StringBuilder();
        sb.append(KEY_TFTP).append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ").append(file.getName()).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        TFTPCommand tftpCommand = new TFTPCommand(sb.toString());
        tftpCommand.setTimeout(TFTPCommand.calculateTimeout(TFTPCommand.getLength(length)));
        return tftpCommand;
    }
}

