/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.commands;

import com.vendor.burn.commands.SerialCommand;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.utilitily.ToolUtils;

public class WriteCommand
extends SerialCommand {
    private static final String KEY_WRITE = "write";
    private static final String KEY_WRITE_YAFFS = "write.yaffs";
    private static final String KEY_WRITE_YAFFSUC = "write.yaffsuc";
    private static final String KEY_MMC = "mmc write";
    private static final String KEY_SSD = "nvme write";
    private static final String KEY_UFS = "ufs write";
    private static final String KEY_MMC_BOOTWRITE = "mmc bootwrite";
    private static final String KEY_MMC_SP = "mmc write.ext4sp";
    private static final String KEY_UFS_SP = "ufs write.ext4sp";
    private static final int HEX = 16;
    public static final int EMMC_ALIGN_LEN = 512;
    public static final int UFS_ALIGN_LEN = 4096;

    private WriteCommand(String command, String length) {
        super(command);
        this.setTimeout(this.calculateTimeOut(length));
    }

    private static WriteCommand write(FlashType flashType, String key, String destination, String orignal, String length) {
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.spi) {
            sb.append("sf");
        } else {
            sb.append(flashType.name());
        }
        sb.append(" ").append(key).append(" ");
        if (!destination.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(destination).append(" ");
        if (!orignal.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(orignal).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new WriteCommand(sb.toString(), length);
    }

    public static WriteCommand writeeMMC(FlashType flashType, String address, String startSector, String lengthSector) {
        if (flashType == FlashType.ufs) {
            return WriteCommand.getUfsCmd(KEY_UFS, address, startSector, lengthSector);
        }
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.ssd) {
            sb.append(KEY_SSD).append(" ");
        } else {
            sb.append(KEY_MMC);
            sb.append(" ").append("0x0").append(" ");
        }
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        if (!startSector.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startSector).append(" ");
        if (!lengthSector.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(lengthSector);
        return new WriteCommand(sb.toString(), lengthSector){

            @Override
            public int calculateTimeOut(String length) {
                int cmdEmmcWriteSpeed = 0;
                cmdEmmcWriteSpeed = ToolUtils.isCmdLine() ? PreferenceConfig.getCmdEmmcWriteSpeed() : FastbootPreferences.getInt("vendor.burn.commands.speed.emmc_write");
                long to = 0L;
                if (cmdEmmcWriteSpeed != 0) {
                    to = 1.getLength(length) * 512L * 1000L / (long)cmdEmmcWriteSpeed / 256L;
                }
                if (to < 100L) {
                    to = 100L;
                }
                return (int)to;
            }
        };
    }

    private static WriteCommand getUfsCmd(String firstKey, String address, String startSector, String lengthSector) {
        StringBuilder sb = new StringBuilder(firstKey);
        sb.append(" ").append("0x0").append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        try {
            if (startSector.startsWith("0x")) {
                startSector = startSector.substring("0x".length());
            }
            if (lengthSector.startsWith("0x")) {
                lengthSector = lengthSector.substring("0x".length());
            }
            long realStart = (Long.parseLong(startSector, 16) * 512L + 4096L - 1L) / 4096L;
            long realLength = (Long.parseLong(lengthSector, 16) * 512L + 4096L - 1L) / 4096L;
            String newStartSector = Long.toHexString(realStart);
            String newLengthSector = Long.toHexString(realLength);
            if (!newStartSector.startsWith("0x")) {
                sb.append("0x");
            }
            sb.append(newStartSector).append(" ");
            if (!newLengthSector.startsWith("0x")) {
                sb.append("0x");
            }
            sb.append(newLengthSector);
            return new WriteCommand(sb.toString(), newLengthSector){

                @Override
                public int calculateTimeOut(String length) {
                    int cmdEmmcWriteSpeed = 0;
                    cmdEmmcWriteSpeed = ToolUtils.isCmdLine() ? PreferenceConfig.getCmdEmmcWriteSpeed() : FastbootPreferences.getInt("vendor.burn.commands.speed.emmc_write");
                    long to = 0L;
                    if (cmdEmmcWriteSpeed != 0) {
                        to = 2.getLength(length) * 512L * 1000L / (long)cmdEmmcWriteSpeed / 256L;
                    }
                    if (to < 100L) {
                        to = 100L;
                    }
                    return (int)to;
                }
            };
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static WriteCommand writeeMMCSP(FlashType flashType, String address, String startSector, String lengthSector) {
        if (flashType == FlashType.ufs) {
            return WriteCommand.getUfsCmd(KEY_UFS_SP, address, startSector, lengthSector);
        }
        StringBuilder sb = new StringBuilder();
        if (flashType == FlashType.ssd) {
            sb.append(KEY_SSD).append(" ");
        } else {
            sb.append(KEY_MMC_SP);
            sb.append(" ").append("0x0").append(" ");
        }
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        if (!startSector.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(startSector).append(" ");
        if (!lengthSector.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(lengthSector);
        return new WriteCommand(sb.toString(), lengthSector){

            @Override
            public int calculateTimeOut(String length) {
                int cmdEmmcWriteSpeed = 0;
                cmdEmmcWriteSpeed = ToolUtils.isCmdLine() ? PreferenceConfig.getCmdEmmcWriteSpeed() : FastbootPreferences.getInt("vendor.burn.commands.speed.emmc_write");
                long to = 0L;
                if (cmdEmmcWriteSpeed != 0) {
                    to = 3.getLength(length) * 512L * 1000L / (long)cmdEmmcWriteSpeed / 128L;
                }
                if (to < 100L) {
                    to = 100L;
                }
                return (int)to;
            }
        };
    }

    public static WriteCommand bootWriteeMMC(String address, String sector, String length) {
        StringBuilder sb = new StringBuilder(KEY_MMC_BOOTWRITE);
        sb.append(" ").append("0x0").append(" ");
        if (!address.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(address).append(" ");
        if (!sector.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(sector).append(" ");
        if (!length.startsWith("0x")) {
            sb.append("0x");
        }
        sb.append(length);
        return new WriteCommand(sb.toString(), length){

            @Override
            public int calculateTimeOut(String length) {
                int cmdEmmcWriteSpeed = 0;
                cmdEmmcWriteSpeed = ToolUtils.isCmdLine() ? PreferenceConfig.getCmdEmmcWriteSpeed() : FastbootPreferences.getInt("vendor.burn.commands.speed.emmc_write");
                long to = 0L;
                if (cmdEmmcWriteSpeed != 0) {
                    to = 4.getLength(length) * 512L * 1000L / (long)cmdEmmcWriteSpeed / 256L;
                }
                if (to < 100L) {
                    to = 100L;
                }
                return (int)to;
            }
        };
    }

    public static WriteCommand writeYaffs(FlashType flashType, String destination, String original, String length) {
        return WriteCommand.write(flashType, KEY_WRITE_YAFFS, destination, original, length);
    }

    public static WriteCommand writeYaffsuc(FlashType flashType, String destination, String original, String length) {
        return WriteCommand.write(flashType, KEY_WRITE_YAFFSUC, destination, original, length);
    }

    public static WriteCommand write(FlashType flashType, String destination, String original, String length) {
        return WriteCommand.write(flashType, KEY_WRITE, destination, original, length);
    }

    /* synthetic */ WriteCommand(String string, String string2, WriteCommand writeCommand) {
        this(string, string2);
    }
}

