/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.communication;

import com.vendor.burn.communication.CRC16;
import com.vendor.burn.utilitily.DataUtils;

public class Bootrom {
    private static final byte XSTART = -2;
    private static final byte XHEAD = -2;
    private static final byte XDATA = -38;
    private static final byte XTAIL = -19;

    public static byte[] genStartFrame() {
        byte[] frame = new byte[14];
        frame[0] = -2;
        frame[1] = 0;
        frame[2] = -1;
        frame[3] = 1;
        int rand = DataUtils.getRandomValue();
        frame[4] = (byte)(rand >> 24 & 0xFF);
        frame[5] = (byte)(rand >> 16 & 0xFF);
        frame[6] = (byte)(rand >> 8 & 0xFF);
        frame[7] = (byte)(rand & 0xFF);
        frame[8] = (byte)(rand >> 24 & 0xFF);
        frame[9] = (byte)(rand >> 16 & 0xFF);
        frame[10] = (byte)(rand >> 8 & 0xFF);
        frame[11] = (byte)(rand & 0xFF);
        int crc = CRC16.genCRC16(frame, 0, 12, 1);
        frame[12] = (byte)(crc >> 8 & 0xFF);
        frame[13] = (byte)(crc & 0xFF);
        return frame;
    }

    public static byte[] genHeadFrame(int length, int address) {
        byte[] frame = new byte[14];
        frame[0] = -2;
        frame[1] = 0;
        frame[2] = -1;
        frame[3] = 1;
        frame[4] = (byte)(length >> 24 & 0xFF);
        frame[5] = (byte)(length >> 16 & 0xFF);
        frame[6] = (byte)(length >> 8 & 0xFF);
        frame[7] = (byte)(length & 0xFF);
        frame[8] = (byte)(address >> 24 & 0xFF);
        frame[9] = (byte)(address >> 16 & 0xFF);
        frame[10] = (byte)(address >> 8 & 0xFF);
        frame[11] = (byte)(address & 0xFF);
        int crc = CRC16.genCRC16(frame, 0, 12, 1);
        frame[12] = (byte)(crc >> 8 & 0xFF);
        frame[13] = (byte)(crc & 0xFF);
        return frame;
    }

    public static byte[] genDataFrame(byte[] buffer, int sequence) {
        byte[] frame = new byte[buffer.length + 5];
        frame[0] = -38;
        frame[1] = (byte)(sequence & 0xFF);
        frame[2] = (byte)(~sequence & 0xFF);
        int i = 0;
        while (i < buffer.length) {
            frame[3 + i] = buffer[i];
            ++i;
        }
        int crc = CRC16.genCRC16(frame, 0, buffer.length + 3, 1);
        frame[buffer.length + 3] = (byte)(crc >> 8 & 0xFF);
        frame[buffer.length + 4] = (byte)(crc & 0xFF);
        return frame;
    }

    public static byte[] genTailFrame(int fileCount) {
        byte[] frame = new byte[5];
        frame[0] = -19;
        frame[1] = (byte)(fileCount & 0xFF);
        frame[2] = (byte)(~fileCount & 0xFF);
        int crc = CRC16.genCRC16(frame, 0, 3, 1);
        frame[3] = (byte)(crc >> 8 & 0xFF);
        frame[4] = (byte)(crc & 0xFF);
        return frame;
    }
}

