/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model;

import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IDeviceSetting;
import com.vendor.burn.model.devices.IFileSystemSetting;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FileSystem {
    public static final FileSystem none = new FileSystem("none");
    public static final FileSystem yaffs = new FileSystem("yaffs");
    public static final FileSystem ext3 = new FileSystem("ext3/4");
    public static final FileSystem squashFs = new FileSystem("squashfs");
    public static final FileSystem ubiFs = new FileSystem("ubifs");
    public static final FileSystem f2fs = new FileSystem("f2fs");
    public static final FileSystem erofs = new FileSystem("erofs");
    private static FileSystem[] items = new FileSystem[]{none, yaffs, ext3, squashFs, ubiFs, f2fs, erofs};
    private static final String YAFFSHEAD = "YFSS!V10";
    private String fileName;

    private FileSystem(String fileName) {
        this.fileName = fileName;
    }

    public String name() {
        return this.fileName;
    }

    public static String[] getItems() {
        return new String[]{none.name(), yaffs.name(), ext3.name(), squashFs.name(), f2fs.name(), erofs.name()};
    }

    public static String[] getItems(IBurner burner) {
        if (burner instanceof CommonBurner) {
            return new String[]{none.name(), yaffs.name(), ubiFs.name(), ext3.name(), squashFs.name(), f2fs.name(), erofs.name()};
        }
        if (burner instanceof EmmcBurner) {
            return new String[]{none.name(), ext3.name(), squashFs.name(), f2fs.name(), erofs.name()};
        }
        if (burner instanceof PartitionBurner) {
            return new String[]{none.name(), yaffs.name(), ubiFs.name(), squashFs.name()};
        }
        return FileSystem.getItems();
    }

    public static boolean isYaffsFile(IBurner burner, File file) throws IOException {
        if (FileSystem.isYaffsFile(file)) {
            if (burner == null) {
                return false;
            }
            BurnContext burnContext = burner.getBurnContext();
            if (burnContext == null) {
                return false;
            }
            IDeviceSetting deviceSetting = burnContext.getDeviceSetting();
            if (deviceSetting == null) {
                return false;
            }
            IFileSystemSetting fileSystemSetting = deviceSetting.getFileSystemSetting();
            FileSystem[] fileSystems = fileSystemSetting.getFileSystems(burner);
            List<FileSystem> asList = Arrays.asList(fileSystems);
            if (asList.contains(yaffs)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isYaffsFile(File file) throws IOException {
        FileInputStream inputStream;
        byte[] szYaffsMark;
        block12: {
            szYaffsMark = new byte[8];
            inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                int read = inputStream.read(szYaffsMark);
                if (read == 8) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            return false;
        }
        String fileHead = new String(szYaffsMark, System.getProperty("file.encoding"));
        boolean bl = fileHead.startsWith(YAFFSHEAD);
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public static FileSystem[] getFileSystems(Object type) {
        Class<?> class1 = type.getClass();
        return FileSystem.getFileSystems(class1);
    }

    public static FileSystem[] getFileSystems(Class<?> type) {
        if (type == CommonBurner.class) {
            return new FileSystem[]{none, yaffs, ubiFs, ext3, squashFs, f2fs, erofs};
        }
        if (type == EmmcBurner.class) {
            return new FileSystem[]{none, ext3, squashFs, f2fs, erofs};
        }
        if (type == PartitionBurner.class) {
            return new FileSystem[]{none, yaffs, ubiFs, squashFs};
        }
        return (FileSystem[])items.clone();
    }

    public static FileSystem valueOf(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < items.length) {
            if (name.equalsIgnoreCase(items[i].name())) {
                return items[i];
            }
            ++i;
        }
        if (name.equalsIgnoreCase("ext3") || name.equalsIgnoreCase("ext4") || name.equalsIgnoreCase("ext3/4")) {
            return ext3;
        }
        return null;
    }

    public static FileSystem[] values() {
        return (FileSystem[])items.clone();
    }
}

