/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model;

import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IAddressBurner;
import com.vendor.burn.model.devices.IBootBurner;
import com.vendor.burn.model.devices.ICommonBurner;
import com.vendor.burn.model.devices.IMergeBurner;
import com.vendor.burn.model.devices.IPartitionBurner;
import com.vendor.burn.model.devices.burners.AddressBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.FastbootBurner;
import com.vendor.burn.model.devices.burners.MergeBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.util.ArrayList;
import java.util.List;

public enum FlashType {
    nand,
    spi,
    ddr,
    emmc,
    eeprom,
    ufs,
    emmc0,
    emmc1,
    emmc2,
    ssd;

    public static final String nandName = "spi nand/nand";
    public static final String spiName = "spi nor";

    public static String[] getItems() {
        return new String[]{nandName, spiName, ddr.name(), emmc.name(), eeprom.name(), ufs.name()};
    }

    public static String[] getItems(IBurner burner) {
        if (burner instanceof ICommonBurner) {
            boolean isSsd;
            ArrayList<String> items = new ArrayList<String>();
            boolean isUfs = FastbootView.isSupportUfsSeries();
            items.add(nandName);
            items.add(spiName);
            items.add(emmc.name());
            if (isUfs) {
                items.add(ufs.name());
                items.add(emmc0.name());
                items.add(emmc1.name());
                items.add(emmc2.name());
            }
            if (isSsd = FastbootView.isSupportSsdSeries()) {
                items.add(ssd.name());
            }
            String[] arrayList = new String[items.size()];
            items.toArray(arrayList);
            return arrayList;
        }
        if (burner instanceof EmmcBurner) {
            if (FastbootView.isSupportUfsSeries()) {
                return new String[]{emmc.name(), ufs.name()};
            }
            return new String[]{emmc.name()};
        }
        if (burner instanceof IMergeBurner) {
            if (FastbootView.isSupportUfsSeries()) {
                return new String[]{nandName, spiName, emmc.name(), ufs.name()};
            }
            return new String[]{nandName, spiName, emmc.name()};
        }
        if (burner instanceof IAddressBurner || burner instanceof IPartitionBurner) {
            return new String[]{nandName, spiName};
        }
        if (burner instanceof IBootBurner) {
            return new String[]{nandName, spiName, ddr.name()};
        }
        return FlashType.getItems();
    }

    public static FlashType[] getFlashTypes(Class<?> type) {
        if (ToolUtils.isCmdLine()) {
            return new FlashType[]{nand, spi, emmc, ddr, ufs, ssd};
        }
        if (type == CommonBurner.class) {
            if (FastbootView.isSupportUfsSeries()) {
                return new FlashType[]{nand, spi, emmc, ufs, ssd};
            }
            return new FlashType[]{nand, spi, emmc};
        }
        if (type == EmmcBurner.class) {
            if (FastbootView.isSupportUfsSeries()) {
                return new FlashType[]{emmc, ufs};
            }
            return new FlashType[]{emmc};
        }
        if (type == MergeBurner.class) {
            return new FlashType[]{nand, spi, emmc};
        }
        if (type == AddressBurner.class || type == PartitionBurner.class) {
            return new FlashType[]{nand, spi};
        }
        if (type == FastbootBurner.class) {
            return new FlashType[]{nand, spi, ddr};
        }
        return FlashType.values();
    }

    public static FlashType[] getFlashTypes(Object type) {
        return FlashType.getFlashTypes(type.getClass());
    }

    public static ArrayList<FlashType> getCurAllFlashTypes(List<PartitionItem> parts) {
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        for (PartitionItem partitionItem : parts) {
            FlashType flashType = partitionItem.getFlashType();
            if (hasFlashTypes.contains((Object)flashType)) continue;
            hasFlashTypes.add(flashType);
        }
        return hasFlashTypes;
    }

    public static ArrayList<FlashType> getCurFlashTypes(List<PartitionItem> parts) {
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        for (PartitionItem partitionItem : parts) {
            FlashType flashType;
            if (!partitionItem.isChecked() || hasFlashTypes.contains((Object)(flashType = partitionItem.getFlashType()))) continue;
            hasFlashTypes.add(flashType);
        }
        return hasFlashTypes;
    }

    public static boolean isOnlyEmmc(List<PartitionItem> parts, FlashType flashType) {
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked() || partitionItem.getFlashType() == flashType) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmmc(List<PartitionItem> parts, FlashType flashType) {
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked() || partitionItem.getFlashType() != flashType) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnlySelectCurFlashType(List<PartitionItem> parts, FlashType flashType) {
        for (PartitionItem partitionItem : parts) {
            if (partitionItem.getFlashType() == flashType) continue;
            return false;
        }
        return true;
    }
}

