/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model;

import com.vendor.burn.model.cmdline.CmdType;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.define.IConfig;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.SerialHelper;
import com.vendor.burn.utilitily.IPUtils;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.CmdMain;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class LocalConfig
implements IConfig {
    private String comPort = "COM1";
    private String serverIp = "192.168.23.23";

    public LocalConfig() {
        if (ToolUtils.isCmdLine()) {
            this.localCmdlineConfig();
        } else {
            this.localComposite();
        }
    }

    private void localComposite() {
        block11: {
            String serial = FastbootPreferences.CONFIG.getSerial();
            if (serial != null) {
                List<String> listSerialPorts = SerialHelper.getSerialPorts();
                if (listSerialPorts.contains(serial)) {
                    this.comPort = serial;
                } else if (!listSerialPorts.isEmpty()) {
                    this.comPort = listSerialPorts.get(0);
                }
            }
            String serverIP = FastbootPreferences.CONFIG.getServerIP();
            String[] serverIps = IPUtils.getServerIps();
            if (IPUtils.isValidIP(serverIP)) {
                if (Arrays.asList(serverIps).contains(serverIP)) {
                    this.serverIp = serverIP;
                } else if (serverIps.length > 0) {
                    this.serverIp = serverIps[0];
                }
            } else {
                try {
                    this.serverIp = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    if (serverIps.length <= 0) break block11;
                    this.serverIp = serverIps[0];
                }
            }
        }
    }

    private void localCmdlineConfig() {
        block13: {
            CmdType curCmdType;
            String serial = "";
            String serverIP = "";
            LocalConfig localConfig = BurnConfig.getLocalConfig();
            if (localConfig != null) {
                serial = localConfig.getComPort();
                serverIP = localConfig.getServerIp();
            }
            if ((curCmdType = CmdMain.getCurCmdType()) != null && curCmdType == CmdType.burn) {
                if (serial != null) {
                    List<String> listSerialPorts = SerialHelper.getSerialPorts();
                    if (listSerialPorts.contains(serial)) {
                        this.comPort = serial;
                    } else if (!listSerialPorts.isEmpty()) {
                        this.comPort = listSerialPorts.get(0);
                    }
                }
                String[] serverIps = IPUtils.getServerIps();
                if (IPUtils.isValidIP(serverIP)) {
                    if (Arrays.asList(serverIps).contains(serverIP)) {
                        this.serverIp = serverIP;
                    } else if (serverIps.length > 0) {
                        this.serverIp = serverIps[0];
                    }
                } else {
                    try {
                        this.serverIp = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (serverIps.length <= 0) break block13;
                        this.serverIp = serverIps[0];
                    }
                }
            }
        }
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public String getComPort() {
        return this.comPort;
    }

    public void setComPort(String comPort) {
        this.comPort = comPort;
    }
}

