/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.badcheck;

import com.vendor.burn.model.badcheck.BadBlockModel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BadBlockComposite
extends Composite {
    private BadBlockModel badBlock = new BadBlockModel();

    public BadBlockComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createContents(this);
    }

    private void createContents(Composite parent) {
        parent.setBackground(Display.getCurrent().getSystemColor(15));
        parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BadBlockComposite.this.handlePaint(e);
            }
        });
    }

    protected void handlePaint(PaintEvent e) {
        Composite control = (Composite)e.widget;
        GC gc = e.gc;
        int bottomY = control.getSize().y;
        int margin = 4;
        int clientAreaX = control.getSize().x - margin;
        gc.setBackground(Display.getDefault().getSystemColor(5));
        gc.fillRectangle(control.getClientArea());
        gc.setForeground(Display.getCurrent().getSystemColor(3));
        float[] indexes = new float[this.getBadBlock().getBadAddress().length];
        int[] xOffset = new int[this.getBadBlock().getBadAddress().length];
        int block = this.getBadBlock().getBlock();
        int i = 0;
        while (i < this.getBadBlock().getBadAddress().length) {
            long address = this.getBadBlock().getBadAddress()[i];
            indexes[i] = address % (long)block != 0L ? (float)address / (float)(block + 1) : (float)address / (float)block;
            double percent = (double)indexes[i] * 1.0 / (this.getBadBlock().getChip() / (double)block);
            xOffset[i] = (int)(percent * (double)clientAreaX);
            if (i + 1 < xOffset.length && xOffset[i] != xOffset[i + 1]) {
                gc.drawLine(xOffset[i], 0, xOffset[i], bottomY);
            }
            gc.drawLine(xOffset[i], 0, xOffset[i], bottomY);
            ++i;
        }
    }

    public BadBlockModel getBadBlock() {
        return this.badBlock;
    }
}

