/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.cmdline.adapter;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.EBurnBoot;
import com.vendor.burn.model.cmdline.adapter.CommonAdapter;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import java.io.File;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class BootBurn
extends CommonAdapter {
    private UnknownDevice device;
    private String chipName;
    private TransferWay mode;
    private String port;
    private FlashType flashType;
    private File bootFile;
    private File programmer;
    private List<String> serialPorts;

    public boolean parseAllParameter(String[] args, int paramSize) {
        if (!this.parseChipName(args, paramSize, EBurnBoot.chipName.ordinal())) {
            BootBurn.printBurnBootEg();
            return false;
        }
        if (!this.parseMode(args, paramSize, EBurnBoot.mode.ordinal())) {
            BootBurn.printBurnBootEg();
            return false;
        }
        TransferWay transferWayStr = this.getMode();
        if (transferWayStr != null) {
            BurnConfig.setTransferway(transferWayStr);
        }
        int flashNumber = EBurnBoot.flash.ordinal();
        int bootFileNumber = EBurnBoot.boot.ordinal();
        int programmerFileNumber = EBurnBoot.programmer.ordinal();
        if (this.mode != TransferWay.USBBootrom) {
            if (!this.parsePort(args, paramSize, EBurnBoot.port.ordinal())) {
                this.printBurnBoot();
                return false;
            }
        } else {
            --flashNumber;
            --bootFileNumber;
            --programmerFileNumber;
        }
        if (!this.parseFlash(args, paramSize, flashNumber)) {
            BootBurn.printBurnBootEg();
            return false;
        }
        String bootFilePath = this.parseFile(args, paramSize, EBurnBoot.boot.name(), bootFileNumber);
        if (bootFilePath == null) {
            BootBurn.printBurnBootEg();
            return false;
        }
        this.setBootFile(new File(bootFilePath));
        if (paramSize < programmerFileNumber) {
            return true;
        }
        String programmerFilePath = this.parseFile(args, paramSize, EBurnBoot.programmer.name(), programmerFileNumber);
        if (programmerFilePath != null) {
            this.setProgrammer(new File(programmerFilePath));
        }
        return true;
    }

    public boolean parseChipName(String[] args, int paramSize, int chipNameNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.chipName.name()));
            this.printChipNameOptions();
            return false;
        }
        if (paramSize >= chipNameNumber) {
            boolean result;
            String chipName = args[chipNameNumber];
            boolean bl = result = chipName == null || chipName.isEmpty();
            if (result) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.chipName.name()));
                this.printChipNameOptions();
                return false;
            }
            String upperCaseChipName = BootBurn.convertChipName(chipName);
            UnknownDevice device = new UnknownDevice(upperCaseChipName);
            if (!device.isValid()) {
                Log.errorln(Messages.FastbootView_Unsupported_Device);
                this.printChipNameOptions();
                return false;
            }
            this.setChipName(upperCaseChipName);
            this.setDevice(device);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.chipName.name()));
        this.printChipNameOptions();
        return false;
    }

    public boolean parseMode(String[] args, int paramSize, int modeNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
            this.printModeOptions();
            return false;
        }
        if (paramSize >= modeNumber) {
            String modeStr = args[modeNumber];
            if (modeStr == null || modeStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            if (modeStr.equalsIgnoreCase(EMode.serial.name())) {
                this.setMode(TransferWay.Serial);
            } else if (modeStr.equalsIgnoreCase(EMode.jtag.name())) {
                this.setMode(TransferWay.JTAG);
            } else if (modeStr.equalsIgnoreCase(EMode.jtagandserial.name())) {
                this.setMode(TransferWay.JTAGAndSerial);
            } else if (modeStr.equalsIgnoreCase(EMode.usb.name())) {
                this.setMode(TransferWay.USBBootrom);
            } else {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
        this.printModeOptions();
        return false;
    }

    public boolean parsePort(String[] args, int paramSize, int portNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.port.name()));
            return false;
        }
        if (paramSize >= portNumber) {
            String portStr = args[portNumber];
            if (portStr == null || portStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.mode.name()));
                return false;
            }
            this.setPort(portStr);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.port.name()));
        return false;
    }

    public boolean parseFlash(String[] args, int paramSize, int flashNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.flash.name()));
            this.printFlashOptions();
            return false;
        }
        if (paramSize >= flashNumber) {
            String flashStr = args[flashNumber];
            if (flashStr == null || flashStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.flash.name()));
                this.printFlashOptions();
                return false;
            }
            if (flashStr.equalsIgnoreCase(EFlashType.nand.name())) {
                this.setFlashType(FlashType.nand);
            } else if (flashStr.equalsIgnoreCase(EFlashType.spi.name())) {
                this.setFlashType(FlashType.spi);
            } else if (flashStr.equalsIgnoreCase(EFlashType.emmc.name())) {
                this.setFlashType(FlashType.emmc);
            } else if (flashStr.equalsIgnoreCase(EFlashType.ddr.name())) {
                this.setFlashType(FlashType.ddr);
            } else {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)EBurnBoot.flash.name()));
                this.printFlashOptions();
                return false;
            }
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.flash.name()));
        this.printFlashOptions();
        return false;
    }

    private void printModeOptions() {
        EMode[] eModes;
        Log.println("mode:");
        EMode[] eModeArray = eModes = EMode.values();
        int n = eModes.length;
        int n2 = 0;
        while (n2 < n) {
            EMode eMode = eModeArray[n2];
            Log.println(eMode.name());
            ++n2;
        }
    }

    private void printPortOption() {
        Log.println("Input Port:");
        if (this.serialPorts != null && this.serialPorts.size() > 0) {
            for (String serialPort : this.serialPorts) {
                Log.println(serialPort);
            }
        }
    }

    private void printFlashOptions() {
        EFlashType[] eFlashTypes;
        Log.println("Flash:");
        EFlashType[] eFlashTypeArray = eFlashTypes = EFlashType.values();
        int n = eFlashTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EFlashType eFlashType = eFlashTypeArray[n2];
            Log.println(eFlashType.name());
            ++n2;
        }
    }

    private void printBootOption() {
        Log.println("Input Boot file:");
    }

    private void printProgrammerOption() {
        Log.println("Input Programmer file:(Options)");
    }

    public static void printBurnBootEg() {
        Log.println("burntool.jar --burnboot  <chipName>   <mode>  <port>  <flash>       <boot>                 [programmer]         ");
        Log.println("burntool.jar --burnboot  CJXXXVXXX  serial   COM0     emmc    image/fastboot.bin   image/advca_programmer.sig ");
    }

    public void printBurnBoot() {
        BootBurn.printBurnBootEg();
        this.printChipNameOptions();
        this.printModeOptions();
        this.printPortOption();
        this.printFlashOptions();
        this.printBootOption();
        this.printProgrammerOption();
    }

    public UnknownDevice getDevice() {
        return this.device;
    }

    public void setDevice(UnknownDevice device) {
        this.device = device;
    }

    public String getChipName() {
        return this.chipName;
    }

    public void setChipName(String chipName) {
        this.chipName = chipName;
    }

    public TransferWay getMode() {
        return this.mode;
    }

    public void setMode(TransferWay mode) {
        this.mode = mode;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public File getBootFile() {
        return this.bootFile;
    }

    public void setBootFile(File bootFile) {
        this.bootFile = bootFile;
    }

    public File getProgrammer() {
        return this.programmer;
    }

    public void setProgrammer(File programmer) {
        this.programmer = programmer;
    }

    public List<String> getSerialPorts() {
        return this.serialPorts;
    }

    public void setSerialPorts(List<String> serialPorts) {
        this.serialPorts = serialPorts;
    }

    public static enum EFlashType {
        nand,
        spi,
        emmc,
        ddr;

    }

    public static enum EMode {
        serial,
        jtag,
        jtagandserial,
        usb;

    }
}

