/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.cmdline.adapter;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionInfo;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.CmdLineParam;
import com.vendor.burn.model.cmdline.EBurnBoot;
import com.vendor.burn.model.cmdline.adapter.BootBurn;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import java.io.File;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.osgi.util.NLS;

public class Erase
extends BootBurn {
    private UnknownDevice device;
    private String chipName;
    private TransferWay mode;
    private String port;
    private FlashType flashType;
    private File bootFile;
    private File programmer;
    private List<String> serialPorts;
    private List<PartitionItem> partitionList;
    private String xmlPath;

    public boolean parseAllEarseParameter(String[] args, int paramSize, CmdLineParam cmdLineParam) {
        int index = 0;
        while (index < paramSize) {
            String argsName = args[index];
            int parameterNumber = index + 1;
            if (argsName.equalsIgnoreCase("-n")) {
                if (!this.parseChipName(args, paramSize, parameterNumber)) {
                    Erase.printEarseBootEg();
                    return false;
                }
            } else if (argsName.equalsIgnoreCase("-m")) {
                if (!this.parseMode(args, paramSize, parameterNumber)) {
                    Erase.printEarseBootEg();
                    return false;
                }
                int portNumber = parameterNumber + 1;
                if (portNumber <= paramSize && args[parameterNumber].toLowerCase().contains("serial") && !args[portNumber].contains("-") && !this.parsePort(args, paramSize, portNumber)) {
                    this.printEarseBoot();
                    return false;
                }
            } else if (argsName.equalsIgnoreCase("-p")) {
                String programmerFilePath = this.parseFile(args, paramSize, EBurnBoot.programmer.name(), parameterNumber);
                if (programmerFilePath != null) {
                    this.setProgrammer(new File(programmerFilePath));
                }
            } else if (argsName.equalsIgnoreCase("-x")) {
                if (!this.parseXmlPath(args, paramSize, parameterNumber)) {
                    Erase.printEarseBootEg();
                    return false;
                }
            } else if (argsName.equalsIgnoreCase("-c") && !this.parseConfigPath(args, paramSize, parameterNumber, cmdLineParam)) {
                Erase.printEarseBootEg();
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean parseXmlPath(String[] args, int paramSize, int xmlPathNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.xmlPath.name()));
            return false;
        }
        if (paramSize >= xmlPathNumber) {
            block7: {
                String xmlPathStr = args[xmlPathNumber];
                if (xmlPathStr == null || xmlPathStr.isEmpty()) {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.xmlPath.name()));
                    return false;
                }
                File file = new File(xmlPathStr);
                if (!file.exists() || !file.isFile()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)EBurnBoot.xmlPath.name()));
                    return false;
                }
                this.setXmlPath(xmlPathStr);
                try {
                    PartitionInfo partitionInfo = PartitionItem.load(file, true);
                    List<PartitionItem> partitionLists = partitionInfo.getChildren();
                    if (partitionLists != null && partitionLists.size() > 0) {
                        this.setPartitionList(partitionLists);
                        break block7;
                    }
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)file.getAbsolutePath()));
                    return false;
                }
                catch (DocumentException documentException) {
                    Log.errorln(Messages.UanbleParseXml);
                    return false;
                }
            }
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.xmlPath.name()));
        return false;
    }

    @Override
    public boolean parseMode(String[] args, int paramSize, int modeNumber) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
            this.printModeOptions();
            return false;
        }
        if (paramSize >= modeNumber) {
            String modeStr = args[modeNumber];
            if (modeStr == null || modeStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            if (modeStr.equalsIgnoreCase(EMode.serial.name())) {
                this.setMode(TransferWay.Serial);
            } else if (modeStr.equalsIgnoreCase(EMode.USBBootrom.name())) {
                this.setMode(TransferWay.USBBootrom);
            } else {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            BurnConfig.setTransferway(this.getMode());
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
        this.printModeOptions();
        return false;
    }

    public boolean parseConfigPath(String[] args, int paramSize, int configPathNumber, CmdLineParam cmdLineParam) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.configPath.name()));
            return false;
        }
        if (paramSize >= configPathNumber) {
            String configPathStr = args[configPathNumber];
            if (configPathStr == null || configPathStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.configPath.name()));
                return false;
            }
            File file = new File(configPathStr);
            if (!file.exists() || !file.isFile()) {
                Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)configPathStr));
                return false;
            }
            cmdLineParam.setBurnConfigPath(configPathStr);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.configPath.name()));
        return false;
    }

    private void printModeOptions() {
        EMode[] eModes;
        Log.println("mode:");
        EMode[] eModeArray = eModes = EMode.values();
        int n = eModes.length;
        int n2 = 0;
        while (n2 < n) {
            EMode eMode = eModeArray[n2];
            Log.println(eMode.name());
            ++n2;
        }
    }

    private void printPortOption() {
        Log.println("input port:");
        if (this.serialPorts != null && this.serialPorts.size() > 0) {
            for (String serialPort : this.serialPorts) {
                Log.println(serialPort);
            }
        }
    }

    private void printProgrammerOption() {
        Log.println("input programmer file:(options)");
    }

    public static void printEarseBootEg() {
        Log.println("burntool.jar --erase -n <chipName>      <mode>    <port>    <xmlPath>    [programmer]    ");
        Log.println("burntool.jar --erase -n CJXXXVXXX  -m serial     COM0   -x  xmlPath  -p  programmerPath");
        Log.println("burntool.jar --erase -n CJXXXVXXX  -m USBBootrom        -x  xmlPath  -p  programmerPath");
    }

    public void printEarseBoot() {
        Erase.printEarseBootEg();
        this.printChipNameOptions();
        this.printModeOptions();
        this.printPortOption();
        this.printProgrammerOption();
    }

    @Override
    public UnknownDevice getDevice() {
        return this.device;
    }

    @Override
    public void setDevice(UnknownDevice device) {
        this.device = device;
    }

    @Override
    public String getChipName() {
        return this.chipName;
    }

    @Override
    public void setChipName(String chipName) {
        this.chipName = chipName;
    }

    @Override
    public TransferWay getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TransferWay mode) {
        this.mode = mode;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public FlashType getFlashType() {
        return this.flashType;
    }

    @Override
    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    @Override
    public File getBootFile() {
        return this.bootFile;
    }

    @Override
    public void setBootFile(File bootFile) {
        this.bootFile = bootFile;
    }

    @Override
    public File getProgrammer() {
        return this.programmer;
    }

    @Override
    public void setProgrammer(File programmer) {
        this.programmer = programmer;
    }

    @Override
    public List<String> getSerialPorts() {
        return this.serialPorts;
    }

    @Override
    public void setSerialPorts(List<String> serialPorts) {
        this.serialPorts = serialPorts;
    }

    public List<PartitionItem> getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(List<PartitionItem> partitionList) {
        this.partitionList = partitionList;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    public static enum EMode {
        serial,
        USBBootrom;

    }
}

