/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.cmdline.adapter;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.cmdline.ENandImg;
import com.vendor.burn.model.cmdline.adapter.CommonAdapter;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.packagers.nand.ip.NandIPV500;
import com.vendor.burn.packagers.nand.ip.NandIPV600;
import com.vendor.burn.packagers.nand.ip.NandIPV610;
import com.vendor.burn.packagers.nand.ip.NandIPV620;
import com.vendor.burn.utilitily.FileUtils;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class NandImg
extends CommonAdapter {
    private static final String[] BLOCK_SIZE_STRS = new String[]{"128K", "256K", "512K", "1M", "2M", "4M"};
    private static final int[] BLOCK_SIZE_NUMS = new int[]{131072, 262144, 524288, 0x100000, 0x200000, 0x400000};
    private static final int[] BLOCK_SIZE_SIZES_V620 = new int[]{131072, 262144, 524288, 0x100000, 0x200000, 0x400000};
    private static final String[] BLOCK_SIZE_STRS_V620 = new String[]{"128K", "256K", "512K", "1M", "2M", "4M"};
    private UnknownDevice device;
    private String chipName;
    private String flash;
    private String inputFile;
    private boolean fastboot;
    private FlashOption flashOption;
    private FileSystem fileSystem;
    private boolean randomizer;
    private int block;
    private NandIPCommon nandIp;
    private CommonBurner burnBurner;
    private ArrayList<String> flashList = new ArrayList();
    private ArrayList<String> optionList;
    private ArrayList<String> blockList;
    private final String[] args;
    private final int paramSize;

    public static String[] getBlockSizeStrs() {
        return (String[])BLOCK_SIZE_STRS.clone();
    }

    public static int[] getBlockSizeNums() {
        return (int[])BLOCK_SIZE_NUMS.clone();
    }

    public static int[] getBlockSizeSizesV620() {
        return (int[])BLOCK_SIZE_SIZES_V620.clone();
    }

    public static String[] getBlockSizeStrsV620() {
        return (String[])BLOCK_SIZE_STRS_V620.clone();
    }

    public NandImg(String[] args) {
        this.args = (String[])args.clone();
        this.paramSize = args.length - 1;
    }

    public boolean parseAllParameter() {
        if (!this.parseChipName()) {
            NandImg.printNandImgEg();
            Log.println(Messages.NAND_IMG_GET_PAGESIZE_AND_BLOCK);
            return false;
        }
        if (!this.parseFlash()) {
            NandImg.printNandImgEg();
            Log.println(Messages.NAND_IMG_GET_PAGESIZE_AND_BLOCK);
            return false;
        }
        if (!this.parseInputFile()) {
            this.printNandImg();
            return false;
        }
        if (!this.parseFastboot()) {
            this.printNandImg();
            return false;
        }
        if (!this.parsePageAndEcc()) {
            this.printNandImg();
            return false;
        }
        if (!this.parseOobSize()) {
            this.printNandImg();
            return false;
        }
        if (!this.parseFileSystem()) {
            this.printNandImg();
            return false;
        }
        if (!this.parseRandomizer()) {
            this.printNandImg();
            return false;
        }
        if (!this.parseBlock()) {
            this.printNandImg();
            return false;
        }
        return true;
    }

    public boolean parseChipName() {
        if (this.paramSize >= ENandImg.chipName.ordinal()) {
            boolean result;
            String chipName = this.args[ENandImg.chipName.ordinal()];
            boolean bl = result = chipName == null || chipName.isEmpty();
            if (result) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.chipName.name()));
                this.printChipNameOptions();
                return false;
            }
            String upperCaseChipName = NandImg.convertChipName(chipName);
            UnknownDevice device = new UnknownDevice(upperCaseChipName);
            if (!device.isValid()) {
                Log.errorln(Messages.FastbootView_Unsupported_Device);
                this.printChipNameOptions();
                return false;
            }
            if (this.checkNandSupport(device, device.getNandIPVer()) && this.checkNandSupport(device, device.getSpinandIPVer())) {
                Log.errorln(Messages.NandImage_DoNotSupport);
                return false;
            }
            if (device.getNandIPVer() != -1) {
                this.flashList.add(EFlash.nand.name());
            }
            if (device.getSpinandIPVer() != -1) {
                this.flashList.add(EFlash.spinand.name());
            }
            this.setChipName(upperCaseChipName);
            this.setDevice(device);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.chipName.name()));
        this.printChipNameOptions();
        return false;
    }

    public boolean checkNandSupport(UnknownDevice device, int nandIPVer) {
        boolean isSupportNand = nandIPVer != 500 && nandIPVer != 600 && nandIPVer != 610 && nandIPVer != 611 && nandIPVer != 620;
        return isSupportNand;
    }

    public boolean parseFlash() {
        if (this.paramSize >= ENandImg.flash.ordinal()) {
            boolean isAllSupport;
            String flashStr = this.args[ENandImg.flash.ordinal()];
            if (flashStr == null || !this.checkFlash(flashStr)) {
                return false;
            }
            NandIPCommon nandIp = null;
            int nandIPVer = this.device.getNandIPVer();
            int spinandIPVer = this.device.getSpinandIPVer();
            boolean bl = isAllSupport = nandIPVer != -1 && spinandIPVer != -1;
            if (isAllSupport) {
                if (flashStr.equalsIgnoreCase("Nand")) {
                    nandIp = this.chooseNandVersion("Nand", nandIPVer);
                } else if (flashStr.equalsIgnoreCase("SPINand")) {
                    nandIp = this.chooseNandVersion("SPINand", spinandIPVer);
                }
            } else {
                nandIp = nandIPVer != -1 ? this.chooseNandVersion("Nand", nandIPVer) : (spinandIPVer != -1 ? this.chooseNandVersion("SPINand", spinandIPVer) : this.chooseNandVersion("Nand", nandIPVer));
            }
            this.setFlash(flashStr);
            this.setNandIp(nandIp);
            BurnContext burnContext = this.device.getBurnContext();
            if (burnContext != null && nandIp != null) {
                this.burnBurner = new CommonBurner(burnContext);
                this.optionList = this.getPageSizeEccType(this.burnBurner, nandIp);
                this.blockList = this.getblockLists(nandIp);
                return true;
            }
            Log.errorln("BurnContext is null!");
            return false;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.flash.name()));
        this.printFlashOptions(this.flashList);
        return false;
    }

    public boolean parseInputFile() {
        String inputFile;
        if (this.paramSize >= ENandImg.inputFile.ordinal()) {
            inputFile = this.args[ENandImg.inputFile.ordinal()];
            if (inputFile == null || inputFile.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.inputFile.name()));
                return false;
            }
            if (!FileUtils.isExists(inputFile)) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_FilePath_IsNotExist, (Object)inputFile));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.inputFile.name()));
            return false;
        }
        this.setInputFile(inputFile);
        return true;
    }

    public boolean parseFastboot() {
        if (this.paramSize >= ENandImg.fastboot.ordinal()) {
            String fastbootStr = this.args[ENandImg.fastboot.ordinal()];
            if (fastbootStr == null || fastbootStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.fastboot.name()));
                this.printFastbootOptions();
                return false;
            }
            try {
                int fastboot = Integer.parseInt(fastbootStr);
                if (fastboot == EFastboot.un_fastboot.ordinal()) {
                    this.setFastboot(false);
                } else if (fastboot == EFastboot.fastboot.ordinal()) {
                    this.setFastboot(true);
                } else {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.fastboot.name()));
                    this.printFastbootOptions();
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.fastboot.name()));
                this.printFastbootOptions();
                return false;
            }
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.fastboot.name()));
        this.printFastbootOptions();
        return false;
    }

    public boolean parsePageAndEcc() {
        if (this.nandIp == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.flash.name()));
            return false;
        }
        if (this.paramSize >= ENandImg.pageSizeEccType.ordinal()) {
            String pageSizeEccTypeStr = this.args[ENandImg.pageSizeEccType.ordinal()];
            if (pageSizeEccTypeStr == null || pageSizeEccTypeStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.pageSizeEccType.name()));
                this.printPageEccOptions(this.optionList);
                return false;
            }
            int pageSizeEccType = 0;
            try {
                pageSizeEccType = Integer.parseInt(pageSizeEccTypeStr);
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.pageSizeEccType.name()));
                return false;
            }
            if (!this.checkPageSizeEccType(this.optionList, pageSizeEccType)) {
                this.printPageEccOptions(this.optionList);
                return false;
            }
            FlashOption[] options = this.nandIp.getAvailableOptions(this.burnBurner);
            if (options != null) {
                FlashOption flashOption = options[pageSizeEccType];
                this.setFlashOption(flashOption);
                this.setOptionList(this.optionList);
                return true;
            }
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IS_NULL, (Object)"FlashOption"));
            return false;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.pageSizeEccType.name()));
        this.printPageEccOptions(this.optionList);
        return false;
    }

    public boolean parseOobSize() {
        if (this.paramSize >= ENandImg.oobsize.ordinal()) {
            String oobsizeStr = this.args[ENandImg.oobsize.ordinal()];
            if (oobsizeStr == null || oobsizeStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.oobsize.name()));
                return false;
            }
            try {
                int oobSize = Integer.parseInt(oobsizeStr);
                FlashOption flashOption = this.getFlashOption();
                flashOption.setOOBSize(oobSize);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.oobsize.name()));
                return false;
            }
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.oobsize.name()));
        return false;
    }

    public boolean parseFileSystem() {
        if (this.paramSize >= ENandImg.fileSystem.ordinal()) {
            String fileSystemStr = this.args[ENandImg.fileSystem.ordinal()];
            if (fileSystemStr == null || fileSystemStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.fileSystem.name()));
                this.printFileSystemOptions();
                return false;
            }
            try {
                int fileSystem = Integer.parseInt(fileSystemStr);
                if (fileSystem == EFileSystem.none.ordinal()) {
                    this.setFileSystem(FileSystem.none);
                } else if (fileSystem == EFileSystem.yaffs.ordinal()) {
                    this.setFileSystem(FileSystem.yaffs);
                } else if (fileSystem == EFileSystem.ubiFs.ordinal()) {
                    this.setFileSystem(FileSystem.ubiFs);
                } else {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.fileSystem.name()));
                    this.printFileSystemOptions();
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.fileSystem.name()));
                this.printFileSystemOptions();
                return false;
            }
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.fileSystem.name()));
        this.printFileSystemOptions();
        return false;
    }

    public boolean parseRandomizer() {
        if (this.paramSize >= ENandImg.randomizer.ordinal()) {
            String randomizerStr = this.args[ENandImg.randomizer.ordinal()];
            if (randomizerStr == null || randomizerStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.randomizer.name()));
                this.printRandomizerOptions();
                return false;
            }
            try {
                int randomizer = Integer.parseInt(randomizerStr);
                if (randomizer == ERandomizer.randomizer_disabled.ordinal()) {
                    this.setRandomizer(false);
                } else if (randomizer == ERandomizer.randomizer_enabled.ordinal()) {
                    this.setRandomizer(true);
                } else {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.randomizer.name()));
                    this.printRandomizerOptions();
                    return false;
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.randomizer.name()));
                this.printRandomizerOptions();
                return false;
            }
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.randomizer.name()));
        this.printRandomizerOptions();
        return false;
    }

    public boolean parseBlock() {
        if (this.nandIp == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.flash.name()));
            return false;
        }
        if (this.paramSize >= ENandImg.block.ordinal()) {
            int block;
            block6: {
                String blockStr = this.args[ENandImg.block.ordinal()];
                if (blockStr == null || blockStr.isEmpty()) {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.block.name()));
                    this.printBlockOptions(this.blockList);
                    return false;
                }
                try {
                    block = Integer.parseInt(blockStr);
                    if (block <= this.blockList.size() - 1) break block6;
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.block.name()));
                    this.printBlockOptions(this.blockList);
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.block.name()));
                    this.printBlockOptions(this.blockList);
                    return false;
                }
            }
            this.setBlock(BLOCK_SIZE_NUMS[block]);
            this.setBlockList(this.blockList);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)ENandImg.block.name()));
        this.printBlockOptions(this.blockList);
        return false;
    }

    private NandIPCommon chooseNandVersion(String typeIp, int nandIPVer) {
        NandIPCommon nandSet = null;
        if (nandIPVer == 500) {
            nandSet = new NandIPV500();
        } else if (nandIPVer == 600) {
            nandSet = new NandIPV600();
        } else if (nandIPVer == 610) {
            nandSet = new NandIPV610();
        } else if (nandIPVer == 620) {
            nandSet = new NandIPV620();
        } else {
            Log.errorln(Messages.NandImage_DoNotSupport);
        }
        if (nandSet != null) {
            nandSet.setCurSelectedNandWay(typeIp);
        }
        return nandSet;
    }

    private ArrayList<String> getPageSizeEccType(CommonBurner burnBurner, NandIPCommon nandIp) {
        ArrayList<String> optionList = new ArrayList<String>();
        FlashOption[] options = nandIp.getAvailableOptions(burnBurner);
        if (options != null) {
            FlashOption[] flashOptionArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                FlashOption flashOption = flashOptionArray[n2];
                optionList.add(flashOption.toString());
                ++n2;
            }
        }
        return optionList;
    }

    private ArrayList<String> getblockLists(NandIPCommon nandIp) {
        ArrayList<String> blockList = new ArrayList<String>();
        if (nandIp == null) {
            return blockList;
        }
        int i = 0;
        while (i < BLOCK_SIZE_STRS.length) {
            blockList.add(BLOCK_SIZE_STRS[i]);
            ++i;
        }
        return blockList;
    }

    private boolean checkPageSizeEccType(ArrayList<String> optionLists, int pageSizeEccType) {
        if (optionLists == null) {
            return false;
        }
        if (pageSizeEccType > optionLists.size() - 1) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.pageSizeEccType.name()));
            return false;
        }
        return true;
    }

    private boolean checkFlash(String flashStr) {
        EFlash[] eFlashs;
        boolean result;
        boolean bl = result = flashStr == null || flashStr.isEmpty();
        if (result) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)ENandImg.flash.name()));
            this.printFlashOptions(this.flashList);
            return false;
        }
        EFlash[] eFlashArray = eFlashs = EFlash.values();
        int n = eFlashs.length;
        int n2 = 0;
        while (n2 < n) {
            EFlash eFlash = eFlashArray[n2];
            if (eFlash.name().equalsIgnoreCase(flashStr)) {
                return true;
            }
            ++n2;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)ENandImg.flash.name()));
        this.printFlashOptions(this.flashList);
        return false;
    }

    public void printNandImg() {
        NandImg.printNandImgEg();
        this.printChipNameOptions();
        this.printFlashOptions(this.flashList);
        this.printInputFileOption();
        this.printFastbootOptions();
        this.printPageEccOptions(this.optionList);
        this.printOobSizeOption();
        this.printFileSystemOptions();
        this.printRandomizerOptions();
        this.printBlockOptions(this.blockList);
    }

    public static void printNandImgEg() {
        Log.println("burntool.jar --nandimg  <chipName>  <flash> <inputFile>  <fastboot> <pagesize/ecctype> <oobsize> <fileSystem> <randomizer> <block>");
        Log.println("burntool.jar --nandimg  CJ109V101   nand  In_2k4b.yaffs     0              0             64          1            0         0   ");
    }

    private void printFlashOptions(ArrayList<String> flashList) {
        Log.println("Flash:");
        if (flashList != null && flashList.size() > 0) {
            for (String flash : flashList) {
                Log.println(flash);
            }
        } else {
            Log.println(EFlash.nand.name());
            Log.errorln(Messages.NAND_IMG_GET_FLASH);
        }
    }

    private void printInputFileOption() {
        Log.println("Input file:");
    }

    private void printPageEccOptions(ArrayList<String> optionList) {
        Log.println("PageSize/EccType:");
        if (optionList != null && optionList.size() > 0) {
            int i = 0;
            while (i < optionList.size()) {
                String option = optionList.get(i);
                if (option != null) {
                    Log.println(String.valueOf(i) + "    " + option);
                }
                ++i;
            }
        } else {
            Log.errorln(Messages.NAND_IMG_GET_PAGESIZE_AND_BLOCK);
        }
    }

    private void printOobSizeOption() {
        Log.println("Chip OOB size:");
    }

    private void printFileSystemOptions() {
        EFileSystem[] eFileSystems;
        Log.println("FileSystem:");
        EFileSystem[] eFileSystemArray = eFileSystems = EFileSystem.values();
        int n = eFileSystems.length;
        int n2 = 0;
        while (n2 < n) {
            EFileSystem eFileSystem = eFileSystemArray[n2];
            Log.println(String.valueOf(eFileSystem.ordinal()) + "    " + eFileSystem.name());
            ++n2;
        }
    }

    private void printRandomizerOptions() {
        ERandomizer[] eRandomizers;
        Log.println("Randomizer:");
        ERandomizer[] eRandomizerArray = eRandomizers = ERandomizer.values();
        int n = eRandomizers.length;
        int n2 = 0;
        while (n2 < n) {
            ERandomizer eRandomizer = eRandomizerArray[n2];
            Log.println(String.valueOf(eRandomizer.ordinal()) + "    " + eRandomizer.name());
            ++n2;
        }
    }

    private void printFastbootOptions() {
        EFastboot[] efastboots;
        Log.println("Fastboot:");
        EFastboot[] eFastbootArray = efastboots = EFastboot.values();
        int n = efastboots.length;
        int n2 = 0;
        while (n2 < n) {
            EFastboot eFastboot = eFastbootArray[n2];
            Log.println(String.valueOf(eFastboot.ordinal()) + "    " + eFastboot.name());
            ++n2;
        }
    }

    private void printBlockOptions(ArrayList<String> blockLists) {
        Log.println("block:");
        if (blockLists != null && blockLists.size() > 0) {
            int i = 0;
            while (i < blockLists.size()) {
                String block = blockLists.get(i);
                if (block != null) {
                    Log.println(String.valueOf(i) + "    " + block);
                }
                ++i;
            }
        } else {
            Log.errorln(Messages.NAND_IMG_GET_PAGESIZE_AND_BLOCK);
        }
    }

    public String getChipName() {
        return this.chipName;
    }

    public void setChipName(String chipName) {
        this.chipName = chipName;
    }

    public String getFlash() {
        return this.flash;
    }

    public void setFlash(String flash) {
        this.flash = flash;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public FlashOption getFlashOption() {
        return this.flashOption;
    }

    public void setFlashOption(FlashOption flashOption) {
        this.flashOption = flashOption;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public boolean isRandomizer() {
        return this.randomizer;
    }

    public void setRandomizer(boolean randomizer) {
        this.randomizer = randomizer;
    }

    public NandIPCommon getNandIp() {
        return this.nandIp;
    }

    public void setNandIp(NandIPCommon nandIp) {
        this.nandIp = nandIp;
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public ArrayList<String> getOptionList() {
        return this.optionList;
    }

    public void setOptionList(ArrayList<String> optionList) {
        this.optionList = optionList;
    }

    public ArrayList<String> getBlockList() {
        return this.blockList;
    }

    public void setBlockList(ArrayList<String> blockList) {
        this.blockList = blockList;
    }

    public UnknownDevice getDevice() {
        return this.device;
    }

    public void setDevice(UnknownDevice device) {
        this.device = device;
    }

    public ArrayList<String> getFlashList() {
        return this.flashList;
    }

    public void setFlashList(ArrayList<String> flashList) {
        this.flashList = flashList;
    }

    public boolean isFastboot() {
        return this.fastboot;
    }

    public void setFastboot(boolean fastboot) {
        this.fastboot = fastboot;
    }

    private static enum EFastboot {
        un_fastboot,
        fastboot;

    }

    private static enum EFileSystem {
        none,
        yaffs,
        ubiFs;

    }

    private static enum EFlash {
        nand,
        spinand;

    }

    private static enum ERandomizer {
        randomizer_disabled,
        randomizer_enabled;

    }
}

