/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.config;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.CmdLineParam;
import com.vendor.burn.model.cmdline.adapter.CommonAdapter;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.IPUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.vendor.tftp.tool.TFTPService;

public class BurnConfig
extends PropertiesUtility {
    public static final String KEY_CHIPNAME = "chipName";
    public static final String KEY_XMLPATH = "xmlPath";
    public static final String KEY_XMLPATHDEFAULT = "xmlPathDefault";
    public static final String KEY_PROGRAMMER = "programmer";
    public static final String KEY_SERIALPORT = "comport";
    public static final String KEY_SERVERIP = "serverip";
    public static final String KEY_IPADDR = "ipaddr";
    public static final String KEY_NETMASK = "netmask";
    public static final String KEY_GATEWAYIP = "gatewayip";
    public static final String KEY_UDPPORT = "udpport";
    public static final String KEY_ETHADDR = "ethaddr";
    public static final String PORT_CONFIGURABLE = "portConfigurable";
    public static final String PORT = "port";
    public static final String SERIAL_COMMAND_TIMEOUT = "serialCommandTimeout";
    public static final String TFTP_TIMEOUT = "tftpTimeout";
    public static final String FRAME_COMMUNICATION_TIMEOUT = "typeFrameFrequency";
    public static final String IS_SOCKET = "isSocket";
    public static final String SERIAL_SERVER_IP = "serialServerIp";
    public static final String SERIAL_SERVER_PORT = "serialServerPort";
    public static final String KEY_TRANSFER_MODE = "mode";
    public static final String KEY_TRANSFER_USBTOETHERNET = "usbToEthernet";
    public static final String KEY_TRANSFER_USBSERIALNUMBER = "usbSerialNumber";
    public static final String KEY_TRANSFER_USBDEVICENUMBER = "usbDeviceNumber";
    public static final String KEY_JTAG_CONFIG_FREQUENCY = "frequency";
    public static final String KEY_JTAG_SMALL_BOARD_MODEL = "smallboardmodel";
    public static final String BURN_CONFIG_FILE = "burn.config";
    public static final String BAUD_RATE = "baudRate";
    private static String chipName;
    private static String xmlPath;
    private static String programmer;
    private static LocalConfig localConfig;
    private static BoardConfig boardConfig;
    private static boolean portConfigurable;
    private static int port;
    private static boolean isSocket;
    private static String serialServerIp;
    private static int serialServerPort;
    private static TransferWay transferway;
    private static int dwTimeout;
    private static boolean isUSBToEthernet;
    private static String usbSerialNumber;
    private static int usbDeviceNumber;
    private static String baudRate;
    private boolean loadResult = false;

    static {
        portConfigurable = false;
        port = 69;
        isSocket = false;
        serialServerIp = "192.168.23.233";
        serialServerPort = 10029;
        dwTimeout = 13;
        isUSBToEthernet = false;
        usbSerialNumber = "0x000001";
        usbDeviceNumber = -1;
        baudRate = "300K";
    }

    public BurnConfig(CmdLineParam cmdLineParam) {
        if (cmdLineParam != null) {
            String burnXmlPath = cmdLineParam.getXmlPath();
            BurnConfig.setXmlPath(burnXmlPath);
            this.loadResult = this.loadBurnConfig(cmdLineParam);
        }
    }

    protected boolean getParamBoolValue(String keyName) {
        return super.getParamBoolValue(keyName, BURN_CONFIG_FILE);
    }

    protected int getParamIntValue(String keyName) {
        return super.getParamIntValue(keyName, BURN_CONFIG_FILE);
    }

    protected boolean loadBurnConfig(CmdLineParam cmdLineParam) {
        String cmdLineBurnConfigPath = null;
        if (cmdLineParam != null) {
            cmdLineBurnConfigPath = cmdLineParam.getBurnConfigPath();
        }
        String path = null;
        path = cmdLineBurnConfigPath != null && !cmdLineBurnConfigPath.isEmpty() && cmdLineBurnConfigPath != "" ? cmdLineBurnConfigPath : FileUtils.toAbsolutePath("config" + File.separator + BURN_CONFIG_FILE);
        if (!FileUtils.isExists(path)) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_FILE_PATH_DONT_EXIST, (Object)BURN_CONFIG_FILE));
            return false;
        }
        ArrayList<String> definitionLines = FileUtils.readAllLines(path);
        if (definitionLines == null) {
            Log.errorln(NLS.bind((String)"Failed to read the file, the file path is as follows: ", (Object)path));
            return false;
        }
        for (String s : definitionLines) {
            String[] ppt;
            String line = s.trim().replace("\t", "");
            if (line.startsWith("[") || !line.contains("=") || (ppt = line.split("=")).length <= 1) continue;
            this.set(ppt[0], ppt[1]);
        }
        localConfig = new LocalConfig();
        boardConfig = new BoardConfig();
        if (!this.loadCommonConfig(cmdLineParam)) {
            return false;
        }
        if (!this.loadConfigByTransferway(cmdLineParam)) {
            return false;
        }
        Log.println(NLS.bind((String)Messages.MESSAGE_LOAD_FILE_SUCCESS, (Object)BURN_CONFIG_FILE));
        return true;
    }

    private boolean loadConfigByTransferway(CmdLineParam cmdLineParam) {
        String udpPortStr;
        String transferwayMode = BurnConfig.getTransferway().name().toLowerCase();
        if ((transferwayMode.contains("net") || transferwayMode.contains("udp") || transferwayMode.contains("serial") || TransferWay.I2CBootrom == BurnConfig.getTransferway()) && !this.loadSerialConfig(cmdLineParam)) {
            return false;
        }
        if ((transferwayMode.contains("net") || transferwayMode.contains("udp")) && !this.loadTFTPConfig(cmdLineParam)) {
            return false;
        }
        if (transferwayMode.contains("udp") && (udpPortStr = BurnConfig.queryForString(KEY_UDPPORT)) != null && !udpPortStr.isEmpty()) {
            try {
                boardConfig.setUdpPort(Integer.parseInt(udpPortStr));
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_UDPPORT));
                return false;
            }
        }
        if (transferwayMode.contains("jtag") && !this.loadJtagConfig()) {
            return false;
        }
        return !transferwayMode.contains("usb") || TransferWay.UsbTransNet == BurnConfig.getTransferway() || this.loadUsbConfig();
    }

    private boolean loadTFTPConfig(CmdLineParam cmdLineParam) {
        if (!this.loadNetConfig(cmdLineParam)) {
            return false;
        }
        String portConfigurable = BurnConfig.queryForString(PORT_CONFIGURABLE);
        if (portConfigurable == null || portConfigurable.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT_CONFIGURABLE));
            return false;
        }
        try {
            BurnConfig.setPortConfigurable(Boolean.valueOf(portConfigurable));
        }
        catch (Exception exception) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT_CONFIGURABLE));
            return false;
        }
        String port = BurnConfig.queryCmdLineForString(PORT, cmdLineParam);
        if (port == null || port.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT));
            return false;
        }
        try {
            BurnConfig.setPort(Integer.parseInt(port.trim().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PORT));
            return false;
        }
        String tftpTimeout = BurnConfig.queryForString(TFTP_TIMEOUT);
        if (tftpTimeout == null || tftpTimeout.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)TFTP_TIMEOUT));
            return false;
        }
        try {
            TFTPService.setTftpTimeout((int)Integer.parseInt(tftpTimeout.trim().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)TFTP_TIMEOUT));
            return false;
        }
        String transferUSBToEtherNetStr = BurnConfig.queryForString(KEY_TRANSFER_USBTOETHERNET);
        if (transferUSBToEtherNetStr != null && !transferUSBToEtherNetStr.isEmpty()) {
            BurnConfig.setUSBToEthernet(TransferWay.converntUSBToEtherNet(transferUSBToEtherNetStr));
        }
        return true;
    }

    private boolean loadSerialConfig(CmdLineParam cmdLineParam) {
        String comPortStr = BurnConfig.queryCmdLineForString(KEY_SERIALPORT, cmdLineParam);
        if (comPortStr == null || comPortStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_SERIALPORT));
            return false;
        }
        localConfig.setComPort(comPortStr);
        return this.loadSocketConfig();
    }

    private boolean loadCommonConfig(CmdLineParam cmdLineParam) {
        String ethaddrStr;
        String programmerPath;
        String transferModeStr = BurnConfig.queryCmdLineForString(KEY_TRANSFER_MODE, cmdLineParam);
        if (transferModeStr != null && !transferModeStr.isEmpty()) {
            if (BurnConfig.getTransferway() == null) {
                BurnConfig.setTransferway(TransferWay.convernt(transferModeStr));
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_TRANSFER_MODE));
            return false;
        }
        String chipNameStr = BurnConfig.queryCmdLineForString(KEY_CHIPNAME, cmdLineParam);
        if (chipNameStr == null || chipNameStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_CHIPNAME));
            return false;
        }
        String upperCaseChipName = CommonAdapter.convertChipName(chipNameStr);
        BurnConfig.setChipName(upperCaseChipName);
        if (xmlPath == null) {
            String xmlPathStr = BurnConfig.queryForString(KEY_XMLPATH);
            if (xmlPathStr == null || xmlPathStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_XMLPATH));
                return false;
            }
            xmlPathStr = this.getGbkXmlPath(xmlPathStr);
            BurnConfig.setXmlPath(xmlPathStr);
        }
        if ((programmerPath = BurnConfig.queryForString(KEY_PROGRAMMER)) != null && !programmerPath.isEmpty()) {
            BurnConfig.setProgrammer(programmerPath);
        }
        if ((ethaddrStr = BurnConfig.queryForString(KEY_ETHADDR)) != null && !ethaddrStr.isEmpty()) {
            boardConfig.setMac(ethaddrStr);
            boardConfig.setGeneratorMAC(true);
        } else {
            String generatorMAC = IPUtils.generatorMAC();
            boardConfig.setMac(generatorMAC);
            boardConfig.setGeneratorMAC(false);
        }
        return true;
    }

    private boolean loadNetConfig(CmdLineParam cmdLineParam) {
        String serveripStr = BurnConfig.queryCmdLineForString(KEY_SERVERIP, cmdLineParam);
        if (serveripStr == null || serveripStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_SERVERIP));
            return false;
        }
        localConfig.setServerIp(serveripStr);
        String ipaddrStr = BurnConfig.queryCmdLineForString(KEY_IPADDR, cmdLineParam);
        if (ipaddrStr == null) {
            boardConfig.setIp(ipaddrStr);
        }
        if (ipaddrStr == null || ipaddrStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_IPADDR));
            return false;
        }
        boardConfig.setIp(ipaddrStr);
        String netmaskStr = BurnConfig.queryCmdLineForString(KEY_NETMASK, cmdLineParam);
        if (netmaskStr == null || netmaskStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_NETMASK));
            return false;
        }
        boardConfig.setSubnetMask(netmaskStr);
        String gatewayipStr = BurnConfig.queryCmdLineForString(KEY_GATEWAYIP, cmdLineParam);
        if (gatewayipStr == null || gatewayipStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_GATEWAYIP));
            return false;
        }
        boardConfig.setGateway(gatewayipStr);
        String transferModeStr = BurnConfig.queryCmdLineForString(KEY_TRANSFER_MODE, cmdLineParam);
        if (transferModeStr == null || transferModeStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_TRANSFER_MODE));
            return false;
        }
        BurnConfig.setTransferway(TransferWay.convernt(transferModeStr));
        return true;
    }

    private boolean loadJtagConfig() {
        String frequency = BurnConfig.queryForString(KEY_JTAG_CONFIG_FREQUENCY);
        if (frequency == null || frequency.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_CONFIG_FREQUENCY));
            return false;
        }
        String smallboradmodel = BurnConfig.queryForString(KEY_JTAG_SMALL_BOARD_MODEL);
        if (smallboradmodel != null && !smallboradmodel.isEmpty()) {
            try {
                boardConfig.setSmallboradmodel(Integer.parseInt(smallboradmodel.trim().toString()));
            }
            catch (NumberFormatException numberFormatException) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_SMALL_BOARD_MODEL));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_JTAG_SMALL_BOARD_MODEL));
            return false;
        }
        return true;
    }

    private boolean loadSocketConfig() {
        String isUseSocket = BurnConfig.queryForString(IS_SOCKET);
        if (isUseSocket != null && !isUseSocket.isEmpty()) {
            boardConfig.setSocket(Boolean.valueOf(isUseSocket));
            CommonBurner.isSocketTransfer = Boolean.valueOf(isUseSocket);
        }
        if (boardConfig.isSocket()) {
            String socketServerIp = BurnConfig.queryForString(SERIAL_SERVER_IP);
            if (socketServerIp == null || socketServerIp.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)SERIAL_SERVER_IP));
                return false;
            }
            boardConfig.setSerialServerIp(socketServerIp.trim());
            String socketServerPort = BurnConfig.queryForString(SERIAL_SERVER_PORT);
            if (socketServerPort == null || socketServerPort.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)SERIAL_SERVER_PORT));
                return false;
            }
            boardConfig.setSerialServerPort(Short.parseShort(socketServerPort.trim().toString()));
            String dwTimeoutStr = BurnConfig.queryForString(FRAME_COMMUNICATION_TIMEOUT);
            if (dwTimeoutStr != null && !dwTimeoutStr.isEmpty()) {
                BurnConfig.setDwTimeout(Integer.parseInt(dwTimeoutStr));
            }
        }
        return true;
    }

    private boolean loadUsbConfig() {
        String transferUsbSerialNumberStr = BurnConfig.queryForString(KEY_TRANSFER_USBSERIALNUMBER);
        if (transferUsbSerialNumberStr == null || transferUsbSerialNumberStr.isEmpty()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)KEY_TRANSFER_USBSERIALNUMBER));
            return false;
        }
        BurnConfig.setUsbSerialNumber(transferUsbSerialNumberStr);
        String usbDeviceNumberStr = BurnConfig.queryForString(KEY_TRANSFER_USBDEVICENUMBER);
        if (usbDeviceNumberStr != null && !usbDeviceNumberStr.isEmpty()) {
            BurnConfig.setUsbDeviceNumber(Integer.parseInt(usbDeviceNumberStr));
        }
        return true;
    }

    private String getGbkXmlPath(String xmlPathStr) {
        try {
            String defaultCode = System.getProperty("file.encoding");
            if (defaultCode.toLowerCase().equalsIgnoreCase("gbk")) {
                String xmlPathCodedStr = new String(xmlPathStr.getBytes("GBK"), "UTF-8");
                byte[] bytes = xmlPathCodedStr.getBytes("UTF-8");
                byte[] bytesGbk = new String(bytes, "UTF-8").getBytes("GBK");
                xmlPathStr = new String(bytesGbk, "GBK");
                return xmlPathStr;
            }
            return xmlPathStr;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return xmlPathStr;
        }
    }

    public static String getChipName() {
        return chipName;
    }

    public static void setChipName(String chipName) {
        BurnConfig.chipName = chipName;
    }

    public static String getXmlPath() {
        return xmlPath;
    }

    public static void setXmlPath(String xmlPath) {
        BurnConfig.xmlPath = xmlPath;
    }

    public static String getProgrammer() {
        return programmer;
    }

    public static void setProgrammer(String programmer) {
        BurnConfig.programmer = programmer;
    }

    public static LocalConfig getLocalConfig() {
        return localConfig;
    }

    public static void setLocalConfig(LocalConfig localConfig) {
        BurnConfig.localConfig = localConfig;
    }

    public static BoardConfig getBoardConfig() {
        return boardConfig;
    }

    public static void setBoardConfig(BoardConfig boardConfig) {
        BurnConfig.boardConfig = boardConfig;
    }

    public static boolean isPortConfigurable() {
        return portConfigurable;
    }

    public static void setPortConfigurable(boolean portConfigurable) {
        BurnConfig.portConfigurable = portConfigurable;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        BurnConfig.port = port;
    }

    public static boolean isSocket() {
        return isSocket;
    }

    public static void setSocket(boolean isSocket) {
        BurnConfig.isSocket = isSocket;
    }

    public static String getSerialServerIp() {
        return serialServerIp;
    }

    public static void setSerialServerIp(String serialServerIp) {
        BurnConfig.serialServerIp = serialServerIp;
    }

    public static int getSerialServerPort() {
        return serialServerPort;
    }

    public static void setSerialServerPort(int serialServerPort) {
        BurnConfig.serialServerPort = serialServerPort;
    }

    public static TransferWay getTransferway() {
        return transferway;
    }

    public static void setTransferway(TransferWay transferway) {
        BurnConfig.transferway = transferway;
    }

    public static int getDwTimeout() {
        return dwTimeout;
    }

    public static void setDwTimeout(int dwTimeout) {
        BurnConfig.dwTimeout = dwTimeout;
    }

    public static boolean isUSBToEthernet() {
        return isUSBToEthernet;
    }

    public static void setUSBToEthernet(boolean isUSBToEthernet) {
        BurnConfig.isUSBToEthernet = isUSBToEthernet;
    }

    public boolean isLoadResult() {
        return this.loadResult;
    }

    public void setLoadResult(boolean loadResult) {
        this.loadResult = loadResult;
    }

    public static String getUsbSerialNumber() {
        return usbSerialNumber;
    }

    public static void setUsbSerialNumber(String usbSerialNumber) {
        BurnConfig.usbSerialNumber = usbSerialNumber;
    }

    public static int getUsbDeviceNumber() {
        return usbDeviceNumber;
    }

    public static void setUsbDeviceNumber(int usbDeviceNumber) {
        BurnConfig.usbDeviceNumber = usbDeviceNumber;
    }

    public static String getBaudRate() {
        return baudRate;
    }

    public static void setBaudRate(String baudRate) {
        BurnConfig.baudRate = baudRate;
    }
}

