/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.config;

import com.vendor.burn.Messages;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.CmdLineParam;
import com.vendor.burn.model.config.BurnConfig;
import com.vendor.burn.utilitily.FileUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class PreferenceConfig
extends PropertiesUtility {
    public static final String PRE_OPEN_DEBUG = "open.debug";
    public static final String PRE_CHECK_SAMENETWORK = "check.network";
    public static final String PRE_TFTP_SPEED = "tftp.speed";
    public static final String PRE_TFTP_LOSING_PACKAGE_ENABLE = "tftp.losingpackage.enable";
    public static final String PRE_TFTP_LOSING_PACKAGE_COUNT = "tftp.losingpackage.count";
    public static final String PRE_TFTP_RETRY_COUNT = "tftp.retry.count";
    public static final String PRE_TFTP_NO_RESPONSE_TIMEOUT = "tftp.timeout.noresponse";
    public static final String PRE_TFTP_SPLIT_FILE_SIZE = "tftp.split.fileSize";
    public static final String PRE_TFTP_CRC_CHECK = "tftp.crc.check";
    public static final String PRE_TFTP_WINDOW_SIZE_OPEN = "tftp.windowSize.open";
    public static final String PRE_TFTP_WINDOW_SIZE_BLOCK_COUNT = "tftp.windowSize.blockCount";
    public static final String PRE_CMD_SPEED_EMMC_WRITE = "cmd.emmcWriteSpeed";
    public static final String PRE_CMD_EMMC_DISK_FORMAT_CONFIG = "cmd.emmcDiskFormat";
    public static final String PRE_CMD_EMMC_ERASE_BEFORE_BURN_CONFIG = "cmd.eraseBeforeBurn";
    public static final String PRE_CMD_NET_ETHACT_CONFIG = "cmd.ethact";
    public static final String PRE_CMD_I2C_BAUD_RATE = "cmd.i2c.baudrate";
    public static final String PRE_CMD_I2C_DEVICE_ADDRESS = "cmd.i2c.deviceAddress";
    public static final String PRE_CMD_I2C_DELAY = "cmd.i2c.delay";
    public static final String PRE_CMD_I2C_TIMEOUT = "cmd.i2c.timeout";
    public static final String PRE_CMD_I2C_RETRY_COUNT = "cmd.i2c.retry.count";
    public static final String PRE_IMG_FILL_CONFIG = "image.imageFill";
    public static final String PRE_IMG_FILL_NAND_PIN_SAVE_MODE = "image.openPinSaveMode";
    public static final String BURN_CONFIG_FILE = "burn.config";
    public static final String PREFERENCE_CONFIG_FILE = "preference.config";
    public static final boolean PRE_OPEN_DEBUG_INIT = false;
    public static final boolean PRE_CHECK_SAMENETWORK_INIT = true;
    public static final int PRE_TFTP_PORT_INIT = 69;
    public static final int PRE_TFTP_SPEED_INIT = 1024;
    public static final boolean PRE_TFTP_LOSING_PACKAGE_ENABLE_INIT = true;
    public static final int PRE_TFTP_LOSING_PACKAGE_COUNT_INIT = 15;
    public static final int PRE_TFTP_RETRY_COUNT_INIT = 5;
    public static final int PRE_TFTP_NO_RESPONSE_TIMEOUT_INIT = 10;
    public static final int PRE_TFTP_SPLIT_FILE_SIZE_INIT = 0x8000000;
    public static final boolean PRE_TFTP_CRC_CHECK_INIT = true;
    public static final boolean PRE_TFTP_WINDOW_SIZE_OPEN_INIT = true;
    public static final int PRE_TFTP_WINDOW_SIZE_BLOCK_COUNT_INIT = 3;
    public static final int PRE_CMD_SPEED_EMMC_WRITE_INIT = 3072;
    public static final boolean PRE_CMD_EMMC_DISK_FORMAT_CONFIG_INIT = false;
    public static final boolean PRE_CMD_EMMC_ERASE_BEFORE_BURN_CONFIG_INIT = false;
    public static final String PRE_CMD_NET_ETHACT_CONFIG_INIT = "Auto";
    public static final int PRE_CMD_I2C_BAUD_RATE_INIT = 409600;
    public static final int PRE_CMD_I2C_DEVICE_ADDRESS_INIT = 56;
    public static final int PRE_CMD_I2C_DELAY_INIT = 50;
    public static final int PRE_CMD_I2C_TIMEOUT_INIT = 60000;
    public static final int PRE_CMD_I2C_RETRY_COUNT_INIT = 30;
    public static final String PRE_IMG_FILL_CONFIG_INIT = "0x00";
    public static final boolean PRE_IMG_FILL_NAND_PIN_SAVE_MODE_INIT = true;
    private static boolean debugPrint = true;
    private static boolean checkNetWork = true;
    private static int tftpPort = 69;
    private static int tftpSpeed = 1024;
    private static boolean tftpLostEnable = true;
    private static int tftpLostCount = 15;
    private static int tftpRetryCount = 5;
    private static int tftpTimeoutNoresponse = 10;
    private static int tftpSplitFileSize = 0x8000000;
    private static boolean tftpCrcCheck = true;
    private static boolean tftpWinSizeOpen = true;
    private static int tftpWinSizeBlockCount = 3;
    private static int cmdEmmcWriteSpeed = 3072;
    private static boolean cmdEmmcDiskFormat = false;
    private static boolean cmdEraseBeforeBurn = false;
    private static String cmdEthact = "Auto";
    private static int cmdI2cBaudrate = 409600;
    private static int cmdI2cDeviceAddr = 56;
    private static int cmdI2cDelay = 50;
    private static int cmdI2cTimeout = 60000;
    private static int cmdI2cRetryCount = 30;
    private static String imgFillData = "0x00";
    private static boolean imgOpenPinSaveMode = true;
    private boolean loadResult = false;

    public PreferenceConfig(CmdLineParam cmdLineParam) {
        this.loadResult = this.loadPreferenceConfig(cmdLineParam);
    }

    protected boolean getParamBoolValue(String keyName) {
        return super.getParamBoolValue(keyName, PREFERENCE_CONFIG_FILE);
    }

    protected int getParamIntValue(String keyName) {
        return super.getParamIntValue(keyName, PREFERENCE_CONFIG_FILE);
    }

    protected String getParamStringValue(String keyName) {
        return super.getParamStringValue(keyName, PREFERENCE_CONFIG_FILE);
    }

    protected boolean loadPreferenceConfig(CmdLineParam cmdLineParam) {
        String transferWayName;
        String path = FileUtils.toAbsolutePath("config" + File.separator + PREFERENCE_CONFIG_FILE);
        if (!FileUtils.isExists(path)) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_FILE_PATH_DONT_EXIST, (Object)PREFERENCE_CONFIG_FILE));
            return false;
        }
        ArrayList<String> definitionLines = FileUtils.readAllLines(path);
        if (definitionLines == null) {
            Log.errorln(NLS.bind((String)"Failed to read the file, the file path is as follows: ", (Object)path));
            return false;
        }
        for (String s : definitionLines) {
            String[] ppt;
            String line = s.trim().replace("\t", "");
            if (line.startsWith("[") || !line.contains("=") || (ppt = line.split("=")).length <= 1) continue;
            this.set(ppt[0], ppt[1]);
        }
        boolean debugOpen = this.getParamBoolValue(PRE_OPEN_DEBUG);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_OPEN_DEBUG));
            return false;
        }
        PreferenceConfig.setDebugPrint(debugOpen);
        TransferWay transferWay = BurnConfig.getTransferway();
        if (transferWay != null && ((transferWayName = transferWay.name().toLowerCase()).contains("net") || transferWayName.contains("udp")) && !this.loadTftpConfig()) {
            return true;
        }
        if (!this.loadCmdConfig()) {
            return true;
        }
        if (!this.loadImgConfig()) {
            return true;
        }
        Log.println(NLS.bind((String)Messages.MESSAGE_LOAD_FILE_SUCCESS, (Object)PREFERENCE_CONFIG_FILE));
        return true;
    }

    private boolean loadImgConfig() {
        String imgFillData = this.getParamStringValue(PRE_IMG_FILL_CONFIG);
        if (imgFillData == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_IMG_FILL_CONFIG));
            return false;
        }
        PreferenceConfig.setImgFillData(imgFillData);
        boolean imgOpenPinSaveMode = this.getParamBoolValue(PRE_IMG_FILL_NAND_PIN_SAVE_MODE);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_IMG_FILL_NAND_PIN_SAVE_MODE));
            return false;
        }
        PreferenceConfig.setImgOpenPinSaveMode(imgOpenPinSaveMode);
        return true;
    }

    private boolean loadCmdConfig() {
        int cmdEmmcWriteSpeed = this.getParamIntValue(PRE_CMD_SPEED_EMMC_WRITE);
        if (cmdEmmcWriteSpeed == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_SPEED_EMMC_WRITE));
            return false;
        }
        PreferenceConfig.setCmdEmmcWriteSpeed(cmdEmmcWriteSpeed);
        boolean cmdDiskFormat = this.getParamBoolValue(PRE_CMD_EMMC_DISK_FORMAT_CONFIG);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_EMMC_DISK_FORMAT_CONFIG));
            return false;
        }
        PreferenceConfig.setCmdEmmcDiskFormat(cmdDiskFormat);
        boolean cmdEraseBeforeBurn = this.getParamBoolValue(PRE_CMD_EMMC_ERASE_BEFORE_BURN_CONFIG);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_EMMC_ERASE_BEFORE_BURN_CONFIG));
            return false;
        }
        PreferenceConfig.setCmdEraseBeforeBurn(cmdEraseBeforeBurn);
        String cmdEthact = this.getParamStringValue(PRE_CMD_NET_ETHACT_CONFIG);
        if (cmdEthact == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_NET_ETHACT_CONFIG));
            return false;
        }
        PreferenceConfig.setCmdEthact(cmdEthact);
        if (BurnConfig.getTransferway() == TransferWay.I2CBootrom) {
            int cmdI2cBaudrate = this.getParamIntValue(PRE_CMD_I2C_BAUD_RATE);
            if (cmdI2cBaudrate == -1) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_I2C_BAUD_RATE));
                return false;
            }
            PreferenceConfig.setCmdI2cBaudrate(cmdI2cBaudrate);
            int cmdI2cDeviceAddr = this.getParamIntValue(PRE_CMD_I2C_DEVICE_ADDRESS);
            if (cmdI2cDeviceAddr == -1) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_I2C_DEVICE_ADDRESS));
                return false;
            }
            PreferenceConfig.setCmdI2cDeviceAddr(cmdI2cDeviceAddr);
            int cmdI2cDelay = this.getParamIntValue(PRE_CMD_I2C_DELAY);
            if (cmdI2cDelay == -1) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_I2C_DELAY));
                return false;
            }
            PreferenceConfig.setCmdI2cDelay(cmdI2cDelay);
            int cmdI2cTimeout = this.getParamIntValue(PRE_CMD_I2C_TIMEOUT);
            if (cmdI2cTimeout == -1) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_I2C_TIMEOUT));
                return false;
            }
            PreferenceConfig.setCmdI2cTimeout(cmdI2cTimeout);
            int cmdI2cRetryCount = this.getParamIntValue(PRE_CMD_I2C_RETRY_COUNT);
            if (cmdI2cRetryCount != -1) {
                PreferenceConfig.setCmdI2cRetryCount(cmdI2cRetryCount);
            } else {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CMD_I2C_RETRY_COUNT));
                return false;
            }
        }
        return true;
    }

    private boolean loadTftpConfig() {
        boolean checkNetWork = this.getParamBoolValue(PRE_CHECK_SAMENETWORK);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_CHECK_SAMENETWORK));
            return false;
        }
        PreferenceConfig.setCheckNetWork(checkNetWork);
        int tftpSpeed = this.getParamIntValue(PRE_TFTP_SPEED);
        if (tftpSpeed == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_SPEED));
            return false;
        }
        PreferenceConfig.setTftpSpeed(tftpSpeed);
        boolean tftpLostEnable = this.getParamBoolValue(PRE_TFTP_LOSING_PACKAGE_ENABLE);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_LOSING_PACKAGE_ENABLE));
            return false;
        }
        PreferenceConfig.setTftpLostEnable(tftpLostEnable);
        int tftpLostCount = this.getParamIntValue(PRE_TFTP_LOSING_PACKAGE_COUNT);
        if (tftpLostCount == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_LOSING_PACKAGE_COUNT));
            return false;
        }
        PreferenceConfig.setTftpLostCount(tftpLostCount);
        int tftpRetryCount = this.getParamIntValue(PRE_TFTP_RETRY_COUNT);
        if (tftpRetryCount == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_RETRY_COUNT));
            return false;
        }
        PreferenceConfig.setTftpRetryCount(tftpRetryCount);
        int tftpNoResponseTimeout = this.getParamIntValue(PRE_TFTP_NO_RESPONSE_TIMEOUT);
        if (tftpNoResponseTimeout == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_NO_RESPONSE_TIMEOUT));
            return false;
        }
        PreferenceConfig.setTftpTimeoutNoresponse(tftpNoResponseTimeout);
        int tftpSplitFileSize = this.getParamIntValue(PRE_TFTP_SPLIT_FILE_SIZE);
        if (tftpSplitFileSize == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_SPLIT_FILE_SIZE));
            return false;
        }
        PreferenceConfig.setTftpSplitFileSize(tftpSplitFileSize);
        boolean tftpCrcCheck = this.getParamBoolValue(PRE_TFTP_CRC_CHECK);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_CRC_CHECK));
            return false;
        }
        PreferenceConfig.setTftpCrcCheck(tftpCrcCheck);
        boolean tftpWinSizeOpen = this.getParamBoolValue(PRE_TFTP_WINDOW_SIZE_OPEN);
        if (!this.convertSuccess) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_WINDOW_SIZE_OPEN));
            return false;
        }
        PreferenceConfig.setTftpWinSizeOpen(tftpWinSizeOpen);
        int tftpWinSizeBlockCount = this.getParamIntValue(PRE_TFTP_WINDOW_SIZE_BLOCK_COUNT);
        if (tftpWinSizeBlockCount == -1) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_DONT_FIND, (Object)PRE_TFTP_WINDOW_SIZE_BLOCK_COUNT));
            return false;
        }
        PreferenceConfig.setTftpWinSizeBlockCount(tftpWinSizeBlockCount);
        return true;
    }

    public static int getTftpPort() {
        return tftpPort;
    }

    public static void setTftp(int tftpPort) {
        PreferenceConfig.tftpPort = tftpPort;
    }

    public static int getTftpSpeed() {
        return tftpSpeed;
    }

    public static void setTftpSpeed(int tftpSpeed) {
        PreferenceConfig.tftpSpeed = tftpSpeed;
    }

    public static boolean isTftpLostEnable() {
        return tftpLostEnable;
    }

    public static void setTftpLostEnable(boolean tftpLostEnable) {
        PreferenceConfig.tftpLostEnable = tftpLostEnable;
    }

    public static int getTftpLostCount() {
        return tftpLostCount;
    }

    public static void setTftpLostCount(int tftpLostCount) {
        PreferenceConfig.tftpLostCount = tftpLostCount;
    }

    public static int getTftpRetryCount() {
        return tftpRetryCount;
    }

    public static void setTftpRetryCount(int tftpRetryCount) {
        PreferenceConfig.tftpRetryCount = tftpRetryCount;
    }

    public static int getTftpTimeoutNoresponse() {
        return tftpTimeoutNoresponse;
    }

    public static void setTftpTimeoutNoresponse(int tftpTimeoutNoresponse) {
        PreferenceConfig.tftpTimeoutNoresponse = tftpTimeoutNoresponse;
    }

    public static int getTftpSplitFileSize() {
        return tftpSplitFileSize;
    }

    public static void setTftpSplitFileSize(int tftpSplitFileSize) {
        PreferenceConfig.tftpSplitFileSize = tftpSplitFileSize;
    }

    public static boolean isTftpCrcCheck() {
        return tftpCrcCheck;
    }

    public static void setTftpCrcCheck(boolean tftpCrcCheck) {
        PreferenceConfig.tftpCrcCheck = tftpCrcCheck;
    }

    public static boolean isTftpWinSizeOpen() {
        return tftpWinSizeOpen;
    }

    public static void setTftpWinSizeOpen(boolean tftpWinSizeOpen) {
        PreferenceConfig.tftpWinSizeOpen = tftpWinSizeOpen;
    }

    public static int getTftpWinSizeBlockCount() {
        return tftpWinSizeBlockCount;
    }

    public static void setTftpWinSizeBlockCount(int tftpWinSizeBlockCount) {
        PreferenceConfig.tftpWinSizeBlockCount = tftpWinSizeBlockCount;
    }

    public static int getCmdEmmcWriteSpeed() {
        return cmdEmmcWriteSpeed;
    }

    public static void setCmdEmmcWriteSpeed(int cmdEmmcWriteSpeed) {
        PreferenceConfig.cmdEmmcWriteSpeed = cmdEmmcWriteSpeed;
    }

    public static boolean isCmdEraseBeforeBurn() {
        return cmdEraseBeforeBurn;
    }

    public static void setCmdEraseBeforeBurn(boolean cmdEraseBeforeBurn) {
        PreferenceConfig.cmdEraseBeforeBurn = cmdEraseBeforeBurn;
    }

    public static String getCmdEthact() {
        return cmdEthact;
    }

    public static void setCmdEthact(String cmdEthact) {
        PreferenceConfig.cmdEthact = cmdEthact;
    }

    public static int getCmdI2cBaudrate() {
        return cmdI2cBaudrate;
    }

    public static void setCmdI2cBaudrate(int cmdI2cBaudrate) {
        PreferenceConfig.cmdI2cBaudrate = cmdI2cBaudrate;
    }

    public static int getCmdI2cDeviceAddr() {
        return cmdI2cDeviceAddr;
    }

    public static void setCmdI2cDeviceAddr(int cmdI2cDeviceAddr) {
        PreferenceConfig.cmdI2cDeviceAddr = cmdI2cDeviceAddr;
    }

    public static int getCmdI2cDelay() {
        return cmdI2cDelay;
    }

    public static void setCmdI2cDelay(int cmdI2cDelay) {
        PreferenceConfig.cmdI2cDelay = cmdI2cDelay;
    }

    public static int getCmdI2cTimeout() {
        return cmdI2cTimeout;
    }

    public static void setCmdI2cTimeout(int cmdI2cTimeout) {
        PreferenceConfig.cmdI2cTimeout = cmdI2cTimeout;
    }

    public static int getCmdI2cRetryCount() {
        return cmdI2cRetryCount;
    }

    public static void setCmdI2cRetryCount(int cmdI2cRetryCount) {
        PreferenceConfig.cmdI2cRetryCount = cmdI2cRetryCount;
    }

    public static String getImgFillData() {
        return imgFillData;
    }

    public static void setImgFillData(String imgFillData) {
        PreferenceConfig.imgFillData = imgFillData;
    }

    public static boolean isImgOpenPinSaveMode() {
        return imgOpenPinSaveMode;
    }

    public static void setImgOpenPinSaveMode(boolean imgOpenPinSaveMode) {
        PreferenceConfig.imgOpenPinSaveMode = imgOpenPinSaveMode;
    }

    public static boolean isCheckNetWork() {
        return checkNetWork;
    }

    public static void setCheckNetWork(boolean checkNetWork) {
        PreferenceConfig.checkNetWork = checkNetWork;
    }

    public static boolean isDebugPrint() {
        return debugPrint;
    }

    public static void setDebugPrint(boolean debugPrint) {
        PreferenceConfig.debugPrint = debugPrint;
    }

    public static boolean isCmdEmmcDiskFormat() {
        return cmdEmmcDiskFormat;
    }

    public static void setCmdEmmcDiskFormat(boolean cmdEmmcDiskFormat) {
        PreferenceConfig.cmdEmmcDiskFormat = cmdEmmcDiskFormat;
    }

    public boolean isLoadResult() {
        return this.loadResult;
    }

    public void setLoadResult(boolean loadResult) {
        this.loadResult = loadResult;
    }
}

