/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.define;

import com.vendor.burn.Activator;
import com.vendor.burn.consoles.FastbootConsoleFactory;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.ILog;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.event.IFastbootEventListener;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public interface IFastbootProgressMonitor
extends ILog {
    public static final IFastbootProgressMonitor PROGRESSMONITORCOMPOSITE = new NullProgressMonitor();
    public static final IFastbootProgressMonitor PROGRESSMONITORCMDLINE = new NullProgressMonitor();

    public void addListener(IFastbootEventListener var1);

    public void removeListener(IFastbootEventListener var1);

    public FastbootEvent getEvent();

    public void begin();

    public void finish();

    public void highlight(PartitionItem var1);

    public void updateLength(long var1);

    public void log(String var1);

    public static class NullProgressMonitor
    implements IFastbootProgressMonitor {
        public SimpleDateFormat dateFormat = new SimpleDateFormat();
        private FastbootEvent event = new FastbootEvent();
        private FileOutputStream LOG = null;
        private List<IFastbootEventListener> listeners = new ArrayList<IFastbootEventListener>();

        @Override
        public FastbootEvent getEvent() {
            return this.event;
        }

        @Override
        public void addListener(IFastbootEventListener iFastbootEventListener) {
            if (iFastbootEventListener == null) {
                return;
            }
            if (!this.listeners.contains(iFastbootEventListener)) {
                this.listeners.add(iFastbootEventListener);
            }
        }

        @Override
        public void removeListener(IFastbootEventListener iFastbootEventListener) {
            if (iFastbootEventListener == null) {
                return;
            }
            if (this.listeners.contains(iFastbootEventListener)) {
                this.listeners.remove(iFastbootEventListener);
            }
        }

        @Override
        public void print(String str) {
            if (str == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.print(str);
            } else {
                FastbootConsoleFactory.getDebugConsole().getDefaultStream().print(str);
            }
        }

        @Override
        public void println(String str) {
            if (str == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.println(str);
            } else {
                FastbootConsoleFactory.getDebugConsole().getDefaultStream().println(str);
            }
        }

        @Override
        public void error(String err) {
            if (err == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.error(err);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getReceivedStream().print(err);
            }
        }

        @Override
        public void errorln(String err) {
            if (err == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.errorln(err);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getReceivedStream().println(err);
            }
        }

        @Override
        public void warn(String warning) {
            if (warning == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.warn(warning);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().print(warning);
            }
        }

        @Override
        public void warnln(String warning) {
            if (warning == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.warningln(warning);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getWarningStream().println(warning);
            }
        }

        @Override
        public void info(String info) {
            if (info == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.info(info);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getInfoStream().print(info);
            }
        }

        @Override
        public void infoln(String info) {
            if (info == null) {
                return;
            }
            if (ToolUtils.isCmdLine()) {
                Log.infoln(info);
            } else {
                FastbootConsoleFactory.getDefaultConsole().getInfoStream().println(info);
            }
        }

        @Override
        public void begin() {
            if (!ToolUtils.isCmdLine()) {
                if (this.event != null) {
                    Activator.getDefault().setEvent(this.event);
                }
                try {
                    this.LOG = Log.getLog();
                    this.LOG.write((String.valueOf(this.dateFormat.format(new Date())) + "\n\r\n").getBytes(System.getProperty("file.encoding")));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {}
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : listeners) {
                            l.started(this.getEvent());
                        }
                    }
                });
            } else {
                for (IFastbootEventListener l : this.listeners) {
                    l.started(this.getEvent());
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void finish() {
            block14: {
                block12: {
                    block13: {
                        if (ToolUtils.isCmdLine()) ** GOTO lbl17
                        default1 = Activator.getDefault();
                        if (default1 != null) break block12;
                        if (this.LOG == null) break block13;
                        try {
                            this.LOG.close();
                        }
                        catch (IOException v0) {}
                    }
                    return;
                }
                try {
                    default1.setEvent(null);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (IFastbootEventListener l : listeners) {
                                l.finished(this.getEvent());
                            }
                            this.getEvent().setType(null);
                        }
                    });
                    break block14;
lbl17:
                    // 2 sources

                    for (IFastbootEventListener l : this.listeners) {
                        l.finished(this.getEvent());
                    }
                    this.getEvent().setType(null);
                }
                catch (Throwable var3_4) {
                    if (this.LOG != null) {
                        try {
                            this.LOG.close();
                        }
                        catch (IOException v1) {}
                    }
                    throw var3_4;
                }
            }
            if (this.LOG != null) {
                try {
                    this.LOG.close();
                }
                catch (IOException v2) {}
            }
        }

        @Override
        public void highlight(PartitionItem part) {
            if (part == null) {
                return;
            }
            final ArrayList<PartitionItem> list = new ArrayList<PartitionItem>();
            list.add(part);
            if (ToolUtils.isCmdLine()) {
                for (IFastbootEventListener l : this.listeners) {
                    l.hightLight(list);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : listeners) {
                            l.hightLight(list);
                        }
                    }
                });
            }
        }

        @Override
        public void updateLength(final long length) {
            if (ToolUtils.isCmdLine()) {
                for (IFastbootEventListener l : this.listeners) {
                    l.updateLength(length);
                }
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IFastbootEventListener l : listeners) {
                            l.updateLength(length);
                        }
                    }
                });
            }
        }

        @Override
        public void log(String log) {
            try {
                if (this.LOG != null && log != null && log.length() > 0) {
                    this.LOG.write(log.getBytes(System.getProperty("file.encoding")));
                }
            }
            catch (IOException iOException) {}
        }
    }
}

