/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.log.Log;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.config.PreferenceConfig;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CallLibJTAGWorker;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.CommonBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.utilitily.IPUtils;
import com.vendor.burn.utilitily.PropertiesUtility;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.TooManyListenersException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.vendor.tftp.tool.TFTPService;

public abstract class AbstractBurner {
    protected String msg_serialPort_cannot_be_connected = "Can not connect to the Serial Port! It may be in use.";
    private BurnContext burnContext;
    private SerialPort serialPort;
    protected String programmerFile;

    public AbstractBurner(BurnContext burnContext) {
        this.burnContext = burnContext;
    }

    public String getProgrammerFile() {
        return this.programmerFile;
    }

    public void setProgrammerFile(String file) {
        this.programmerFile = file;
    }

    public BurnContext getBurnContext() {
        return this.burnContext;
    }

    protected void handleTftpStartFailed() {
        if (!ToolUtils.isCmdLine()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
        } else {
            Log.errorln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
        }
    }

    protected void getTftpPreferenceValue() {
        boolean isSupportTFTPWin = ((UnknownDevice)this.burnContext.getDeviceSetting()).isSupportTFTPWin();
        if (isSupportTFTPWin) {
            if (!ToolUtils.isCmdLine()) {
                TFTPService.setWinSizeOpen((boolean)FastbootPreferences.isOpenTftpWindowSize());
                TFTPService.setWinSizeBlockCount((int)FastbootPreferences.getInt("vendor.burn.tftp.windowSize.blockCount"));
                TFTPService.setSettingRetransmit((int)FastbootPreferences.getInt("vendor.burn.tftp.retry.count"));
                TFTPService.setSettingIgnoreBlockAck((boolean)FastbootPreferences.isTftpIgnoreBlockAck());
            } else {
                TFTPService.setWinSizeOpen((boolean)PreferenceConfig.isTftpWinSizeOpen());
                TFTPService.setWinSizeBlockCount((int)PreferenceConfig.getTftpWinSizeBlockCount());
                TFTPService.setSettingRetransmit((int)PreferenceConfig.getTftpRetryCount());
                TFTPService.setSettingIgnoreBlockAck((boolean)PreferenceConfig.isTftpLostEnable());
            }
        } else {
            TFTPService.setWinSizeBlockCount((int)1);
        }
    }

    public Socket createSocket(IFastbootProgressMonitor monitor, AbstractBurnerWorker worker) {
        String serialServerIp = PropertiesUtility.queryForString("serialServerIp");
        String serialPortName = PropertiesUtility.queryForString("serialServerPort");
        return worker.createSocketConnection(serialServerIp, serialPortName);
    }

    public SerialPort openSerailPort(IFastbootProgressMonitor monitor, AbstractBurnerWorker worker, String serialPortName) {
        this.serialPort = null;
        boolean success = false;
        try {
            try {
                this.serialPort = worker.createConnection(serialPortName);
                if (monitor != null) {
                    monitor.begin();
                }
                if (this.serialPort != null) {
                    success = true;
                }
            }
            catch (IOException e) {
                monitor.getEvent().setMessage(e.getMessage());
                if (!success && monitor != null) {
                    monitor.finish();
                }
            }
            catch (TooManyListenersException e) {
                monitor.getEvent().setMessage(e.getMessage());
                if (!success && monitor != null) {
                    monitor.finish();
                }
            }
        }
        finally {
            if (!success && monitor != null) {
                monitor.finish();
            }
        }
        return this.serialPort;
    }

    protected abstract AbstractBurnerWorker getBurnerWorker();

    protected IStatus validSerialPort() {
        boolean needCheckSerial;
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String comPort = localConfig.getComPort();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl = needCheckSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Net || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress || transferWay == TransferWay.UsbAndSerial;
        if (needCheckSerial && (comPort == null || comPort.isEmpty())) {
            return this.error(Messages.AbstractBurner_msg_serialPort_is_null);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validLocalConfig() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        return Status.OK_STATUS;
    }

    protected void handleSerialPortInUse(IFastbootProgressMonitor monitor) {
        if (monitor != null) {
            monitor.getEvent().setType(null);
            monitor.getEvent().setSuccess(false);
            monitor.warnln(this.msg_serialPort_cannot_be_connected);
        }
        if (!ToolUtils.isCmdLine()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)AbstractBurner.this.msg_serialPort_cannot_be_connected);
                }
            });
        } else {
            Log.errorln(this.msg_serialPort_cannot_be_connected);
        }
    }

    protected void showProgressDialog(Job job) {
        if (job == null) {
            return;
        }
        job.setUser(true);
    }

    protected IStatus validNetConfig() {
        IStatus local;
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        if (transferWay != TransferWay.JTAGAndNet && !this.isOK(local = this.validLocalConfig())) {
            return local;
        }
        if (transferWay != TransferWay.Net && transferWay != TransferWay.UsbTransNet && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.NetNonNude) {
            return null;
        }
        IStatus check = this.checkServieIP();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.validBoardConfig();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.validSameNet();
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    protected IStatus checkServieIP() {
        String[] serverIps = IPUtils.getServerIps();
        String currentServerIp = this.burnContext.getLocalConfig().getServerIp();
        boolean flag = false;
        int i = 0;
        while (i < serverIps.length) {
            if (serverIps[i].equalsIgnoreCase(currentServerIp)) {
                flag = true;
                break;
            }
            ++i;
        }
        if (!flag) {
            return this.error(Messages.PartitionBurner_msg_check_serviceIp);
        }
        return Status.OK_STATUS;
    }

    private IStatus validSameNet() {
        BoardConfig boardConfig = this.burnContext.getBoardConfig();
        String gateway = boardConfig.getGateway();
        String ip = boardConfig.getIp();
        String subnetMask = boardConfig.getSubnetMask();
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String serverIp = localConfig.getServerIp();
        if (gateway.equals(ip)) {
            return this.error(Messages.AbstractBurner_msg_gateway_and_ip_are_same);
        }
        if (ip.equals(serverIp)) {
            return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_same);
        }
        boolean needCheckSameNetWork = false;
        needCheckSameNetWork = !ToolUtils.isCmdLine() ? FastbootPreferences.isCheckSameNetWork() : PreferenceConfig.isCheckNetWork();
        if (needCheckSameNetWork) {
            if (!IPUtils.isOnTheSameNetIP(gateway, ip, subnetMask)) {
                return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_same);
            }
            if (!IPUtils.isOnTheSameNetIP(serverIp, ip, subnetMask)) {
                return this.error(Messages.AbstractBurner_msg_boardip_and_serverip_are_not_on_the_same_net);
            }
        }
        return null;
    }

    protected IStatus validBoardConfig() {
        LocalConfig localConfig = this.burnContext.getLocalConfig();
        String serverIp = localConfig.getServerIp();
        if (serverIp == null || serverIp.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_serverIP_is_null);
        }
        BoardConfig boardConfig = this.burnContext.getBoardConfig();
        String mac = boardConfig.getMac();
        if (mac == null || mac.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_macAddress_is_null);
        }
        if (!IPUtils.isValidMac(mac)) {
            return this.error(Messages.AbstractBurner_msg_macAddress_is_invalid);
        }
        int i = 0;
        while (i < mac.length()) {
            if ((i + 1) % 3 == 0 ? mac.charAt(i) != ':' : mac.charAt(i) == ':') {
                return this.error(Messages.AbstractBurner_msg_macAddress_is_invalid);
            }
            ++i;
        }
        String ip = boardConfig.getIp();
        if (ip == null || ip.isEmpty()) {
            return this.error(Messages.AbstractBurner_msg_serverIP_is_null);
        }
        String subnetMask = boardConfig.getSubnetMask();
        if (IPUtils.isBlank(subnetMask)) {
            return this.error(Messages.AbstractBurner_msg_subnetMask_is_null);
        }
        String gateway = boardConfig.getGateway();
        if (IPUtils.isBlank(gateway)) {
            return this.error(Messages.AbstractBurner_msg_gateway_is_null);
        }
        return Status.OK_STATUS;
    }

    public IStatus error(String msg) {
        if (ToolUtils.isCmdLine()) {
            Log.errorln(msg);
        }
        return new Status(4, "com.vendor.burn", msg);
    }

    protected boolean isOK(IStatus status) {
        return status == null || status.isOK();
    }

    public IStatus checkBeforeBurn() {
        return this.validNetConfig();
    }

    protected void shutDownTFTP(final IFastbootProgressMonitor fastbootMonitor) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog d = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                        try {
                            d.run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        monitor.setTaskName(Messages.AbstractBurner_shuting_down_TFTP_Server_Please_wait_for_a_moment);
                                        TFTPService.TFTPSERVICE.stop();
                                    }
                                    finally {
                                        fastbootMonitor.finish();
                                    }
                                }
                            });
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                });
            }
        }).start();
    }

    protected void closeByTrans() {
        boolean isJtag;
        AbstractBurnerWorker worker = this.getBurnerWorker();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        boolean bl = isJtag = transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial;
        if (isI2C) {
            I2cCommand.I2cCloseChannel();
            worker.infoln("\nI2C channels were closed successfully.");
        } else if (isUsb) {
            CallLibUSBWorker.closeUsb(transferWay);
            worker.infoln("\nUSB channels were closed successfully.");
        } else if (isJtag) {
            if (FastbootView.isCJXX0VXX5Series() && FastbootView.isFastbootStart()) {
                String resetCommand = "reset";
                try {
                    worker.sendCommandNoReturnValue(resetCommand);
                }
                catch (IOException iOException) {
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {}
            }
            CallLibJTAGWorker.releaseJtag();
            worker.infoln("\nJTAG channels were closed successfully.");
        } else if (transferWay == TransferWay.UDP) {
            if (CallLibBootromWorker.getUdpFd() != -1L) {
                CallLibBootromWorker.closeSocket();
            }
        } else if (transferWay == TransferWay.Serial && this.getBurnContext().getBoardConfig().isSocket() && CallLibBootromWorker.getSocketFd() != -1L) {
            CallLibBootromWorker.DestroySerialComm(CallLibBootromWorker.getSocketFd());
        }
    }

    public int erase(IFastbootProgressMonitor fastbootMonitor, CommonBurnerWorker worker) {
        return 0;
    }
}

