/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.PlatformType;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.UploadOption;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IAddressBurner;
import com.vendor.burn.model.devices.ITab;
import com.vendor.burn.model.devices.burners.FastbootBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.preferences.FastbootPreferences;
import com.vendor.burn.serial.workers.AddressBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.ui.UploadOptionDialog;
import com.vendor.burn.ui.burners.tabs.AddressTab;
import com.vendor.burn.utilitily.ToolUtils;
import com.vendor.burn.views.FastbootView;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.vendor.tftp.tool.TFTPService;

public class AddressBurner
extends FastbootBurner
implements IAddressBurner {
    private UploadOption uploadOption = null;
    private String address;
    private String length;
    private ChipID chipId;
    private FileSystem fileSystem = FileSystem.none;
    protected AddressBurnerWorker worker = null;

    public AddressBurner(BurnContext burnContext) {
        super(burnContext);
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        File file;
        AddressBurnerWorker worker;
        LocalConfig localConfig;
        block13: {
            if (fastbootMonitor == null) {
                return;
            }
            fastbootMonitor.getEvent().init(EventType.BURN);
            FlashType flashType = this.getFlashType();
            localConfig = this.getBurnContext().getLocalConfig();
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            worker.setFlashType(flashType);
            file = new File(this.getFile());
            TransferWay transferWay = this.getBurnContext().getTransferWay();
            if (worker.isNeedSetupNet(transferWay)) {
                File home = new File(file.getParent());
                boolean start = false;
                InetAddress address = null;
                try {
                    address = InetAddress.getByName("0.0.0.0");
                }
                catch (UnknownHostException unknownHostException) {}
                int port = FastbootPreferences.getInt("vendor.burn.tftp.port");
                try {
                    try {
                        start = TFTPService.TFTPSERVICE.start(home, address, ToolUtils.getPortCmd(), port);
                        this.getTftpPreferenceValue();
                    }
                    catch (Exception exception) {
                        this.handleTftpStartFailed();
                        if (!start) {
                            fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (!start) {
                        fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    throw throwable;
                }
                if (!start) {
                    fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Burn By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    TransferWay transferWay = AddressBurner.this.getBurnContext().getTransferWay();
                    boolean needOpenSerial = AddressBurner.this.isNeedOpenSerial(transferWay);
                    if (needOpenSerial) {
                        if (fastbootMonitor != null) {
                            monitor.beginTask("Open Serial Port", 10);
                            SerialPort serialPort = AddressBurner.this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort());
                            monitor.beginTask("Open Serial Port", 20);
                            if (serialPort == null) {
                                return null;
                            }
                        }
                    } else if (fastbootMonitor != null) {
                        fastbootMonitor.begin();
                    }
                    if (FastbootView.isCJ303V300()) {
                        worker.setProgressMonitor(monitor);
                        if (!worker.sendTranslateWayFrame(transferWay)) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (transferWay == TransferWay.I2CBootrom) {
                        if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                            worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
                        } else {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    try {
                        try {
                            boolean burn = worker.burn(monitor, file, AddressBurner.this.getFlashType(), AddressBurner.this.getFileSystem(), AddressBurner.this.getAddress(), AddressBurner.this.getCurrentChipId());
                            event.setSuccess(burn);
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                                fastbootMonitor.getEvent().setMessage(e.getMessage());
                            }
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AddressBurner.this.shutDownTFTP(fastbootMonitor);
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    @Override
    protected AddressBurnerWorker getBurnerWorker() {
        if (this.worker == null) {
            this.worker = new AddressBurnerWorker(this);
        }
        return this.worker;
    }

    @Override
    public IStatus checkBeforeBurn() {
        return this.check(EventType.BURN);
    }

    protected IStatus check(EventType type) {
        if (this.getFlashType() == null) {
            return this.error(Messages.AddressBurner_msg_please_select_the_flash_type);
        }
        String file = this.getFile();
        if (file == null || file.trim().length() == 0) {
            return this.error(Messages.AbstractBurner_msg_file_path_does_not_select);
        }
        if (type != null && type.name().equalsIgnoreCase("BURN")) {
            File theFile = new File(file);
            if (!theFile.exists()) {
                return this.error(Messages.AbstractBurner_msg_the_file_does_not_exist);
            }
            if (file.length() == 0) {
                return this.error(Messages.AbstractBurner_msg_the_file_size_must_be_nonzero);
            }
        }
        if (EventType.BURN == type) {
            this.checkBurn();
        } else {
            if (EventType.UPLOAD == type) {
                return this.checkUpload();
            }
            if (EventType.ERASE == type) {
                this.checkErase();
            }
        }
        return null;
    }

    private IStatus checkErase() {
        boolean lenVaild;
        boolean addrVaild;
        IStatus validLocalConfig = this.validSerialPort();
        if (!this.isOK(validLocalConfig)) {
            return validLocalConfig;
        }
        boolean bl = addrVaild = this.getAddress() == null || this.getAddress().length() == 0;
        if (addrVaild) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_input_address, (Object)Messages.BurnComposite_Erase_Text));
        }
        boolean bl2 = lenVaild = this.getLength() == null || this.getLength().length() == 0 || Long.parseLong(this.getLength(), 16) < 1L;
        if (lenVaild) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_input_length, (Object)Messages.BurnComposite_Erase_Text));
        }
        if ((this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA) {
            return this.error(Messages.AddressBurner_No_Programmer_File);
        }
        return null;
    }

    private boolean isNeedOpenSerial(TransferWay way) {
        return way != TransferWay.Usb2I2c && way != TransferWay.I2CBootrom && way != TransferWay.USBBootrom && way != TransferWay.USBNonNude && way != TransferWay.JTAG && way != TransferWay.JTAGAndNet && way != TransferWay.JTAGAndSerial && !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
    }

    private IStatus checkUpload() {
        boolean openConfirm;
        boolean isVaildProgrammerFile;
        boolean isVaildFile;
        boolean isVaildLen;
        boolean isVaildAddr;
        IStatus validNetConfig = this.validNetConfig();
        if (!this.isOK(validNetConfig)) {
            return validNetConfig;
        }
        boolean bl = isVaildAddr = this.getAddress() == null || this.getAddress().length() == 0;
        if (isVaildAddr) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_input_address, (Object)Messages.BurnComposite_Upload_Text));
        }
        boolean bl2 = isVaildLen = this.getLength() == null || this.getLength().length() == 0 || Long.parseLong(this.getLength(), 16) < 1L;
        if (isVaildLen) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_input_length, (Object)Messages.BurnComposite_Upload_Text));
        }
        long uploadLen = Long.parseLong(this.getLength(), 16);
        if (uploadLen % 1024L != 0L) {
            return this.error(Messages.AddressBurner_msg_input_length_align);
        }
        boolean bl3 = isVaildFile = this.getFile() == null || this.getFile().equals("");
        if (isVaildFile) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_select_the_file_to_, (Object)Messages.BurnComposite_Upload_Text));
        }
        boolean bl4 = isVaildProgrammerFile = (this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA;
        if (isVaildProgrammerFile) {
            return this.error(Messages.AddressBurner_No_Programmer_File);
        }
        File file = new File(this.getFile());
        if (file.exists() && !(openConfirm = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_CONFIRM_Title, (String)NLS.bind((String)Messages.PartitionComposite_msg_file_exists_already_whether_to_overwrite_it, (Object)file.getAbsolutePath())))) {
            return Status.CANCEL_STATUS;
        }
        try {
            boolean tftpFileNameVaild;
            boolean bl5 = tftpFileNameVaild = this.getBurnContext().getTransferWay() == TransferWay.Net && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
            if (tftpFileNameVaild) {
                return this.error(Messages.msg_File_name_is_too_long_please_use_a_short_name_instead);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return null;
    }

    private IStatus checkBurn() {
        boolean spiYaffs;
        boolean fileExists;
        boolean isVaildProgrammerFile;
        boolean isVaildFile;
        boolean isVaildAddr;
        IStatus validNetConfig = this.validNetConfig();
        if (!this.isOK(validNetConfig)) {
            return validNetConfig;
        }
        boolean bl = isVaildAddr = this.getAddress() == null || this.getAddress().length() == 0;
        if (isVaildAddr) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_input_address, (Object)Messages.BurnComposite_Burn_Text));
        }
        boolean bl2 = isVaildFile = this.getFile() == null || this.getFile().trim().equals("");
        if (isVaildFile) {
            return this.error(NLS.bind((String)Messages.AddressBurner_msg_please_select_the_file_to_, (Object)Messages.BurnComposite_Burn_Text));
        }
        boolean bl3 = isVaildProgrammerFile = (this.getProgrammerFile() == null || this.getProgrammerFile().trim().equals("")) && this.getBurnContext().getPlatformType() == PlatformType.CA;
        if (isVaildProgrammerFile) {
            return this.error(Messages.AddressBurner_No_Programmer_File);
        }
        File file = new File(this.getFile());
        boolean bl4 = fileExists = !file.exists() || file.isDirectory();
        if (fileExists) {
            return this.error(Messages.AddressBurner_msg_file_does_not_exist_or_is_a_directory);
        }
        boolean yaffsFile = true;
        try {
            yaffsFile = FileSystem.isYaffsFile(this, file);
        }
        catch (IOException iOException) {
            return this.error(Messages.AddressBurner_msg_exception_occurs_while_reading_the_file_please_try_again);
        }
        FileSystem curFileSystem = yaffsFile ? FileSystem.yaffs : FileSystem.none;
        this.setFileSystem(curFileSystem);
        boolean bl5 = spiYaffs = FlashType.spi == this.getFlashType() && yaffsFile;
        if (spiYaffs) {
            return this.error(Messages.AddressBurner_msg_invalid_file_for_the_flash_is_SPI_but_the_file_is_a_Yaffs_type_file);
        }
        try {
            boolean tftpFileNameVaild;
            boolean bl6 = tftpFileNameVaild = (this.getBurnContext().getTransferWay() == TransferWay.Net || this.getBurnContext().getTransferWay() == TransferWay.UsbTransNet || this.getBurnContext().getTransferWay() == TransferWay.JTAGAndNet) && file.getName().getBytes(System.getProperty("file.encoding")).length > 100;
            if (tftpFileNameVaild) {
                return this.error(Messages.msg_File_name_is_too_long_please_use_a_short_name_instead);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return null;
    }

    @Override
    public IStatus checkBeforeErase() {
        return this.check(EventType.ERASE);
    }

    @Override
    public IStatus checkBeforeUpload() {
        IStatus upload = this.check(EventType.UPLOAD);
        if (!this.isOK(upload)) {
            return upload;
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.getBurnContext().getTransferWay() == TransferWay.USBNonNude || this.getBurnContext().getTransferWay() == TransferWay.UsbAndSerial) {
            return this.error(NLS.bind((String)Messages.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"USB"));
        }
        if (this.getBurnContext().getTransferWay() == TransferWay.I2CBootrom || this.getBurnContext().getTransferWay() == TransferWay.Usb2I2c) {
            return this.error(NLS.bind((String)Messages.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"I2C"));
        }
        FlashType flashType = this.getFlashType();
        if (FlashType.nand == flashType) {
            UploadOptionDialog optionDialog = new UploadOptionDialog(Display.getDefault().getActiveShell());
            optionDialog.setUploadOption(UploadOption.DATA_NO_OOB);
            int open = optionDialog.open();
            if (open == 0) {
                this.uploadOption = optionDialog.getUploadOption();
            } else {
                return new Status(8, "com.vendor.burn", "Upload Cancelled!");
            }
        }
        return null;
    }

    @Override
    public void erase(final IFastbootProgressMonitor fastbootMonitor) {
        FastbootEvent event;
        final LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        final AddressBurnerWorker worker = this.getBurnerWorker();
        final BurnContext context = this.getBurnContext();
        worker.setProgressMonitor(fastbootMonitor);
        worker.setFlashType(this.getFlashType());
        if (fastbootMonitor != null && (event = fastbootMonitor.getEvent()) != null) {
            Job job = new Job("Erase By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.Usb2I2c && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.I2CBootrom && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.USBBootrom && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.USBNonNude && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.JTAGAndNet && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.JTAG && AddressBurner.this.getBurnContext().getTransferWay() != TransferWay.JTAGAndSerial && !((UnknownDevice)AddressBurner.this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
                        monitor.beginTask("Open Serial Port", 10);
                        SerialPort serialPort = AddressBurner.this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort());
                        monitor.beginTask("Open Serial Port", 20);
                        if (serialPort == null) {
                            return null;
                        }
                    } else if (fastbootMonitor != null) {
                        fastbootMonitor.begin();
                    }
                    if (FastbootView.isCJ303V300()) {
                        worker.setProgressMonitor(monitor);
                        if (!worker.sendTranslateWayFrame(context.getTransferWay())) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (context.getTransferWay() == TransferWay.I2CBootrom) {
                        if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                            worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
                        } else {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    try {
                        try {
                            boolean erase = worker.erase(monitor, AddressBurner.this.getAddress(), AddressBurner.this.getLength());
                            event.setSuccess(erase);
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            event.setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    @Override
    public String getLength() {
        return this.length;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(Messages.AddressBurner_Step_1);
        steps.add(Messages.AddressBurner_Step_2);
        steps.add(Messages.AddressBurner_Step_3);
        steps.add(Messages.AddressBurner_Step_4);
        steps.add(Messages.AddressBurner_Step_5);
        steps.add(Messages.AddressBurner_Step_6);
        return steps;
    }

    @Override
    public void setLength(String length) {
        this.length = length;
    }

    @Override
    public void upload(final IFastbootProgressMonitor fastbootMonitor) {
        TransferWay transferWay;
        AddressBurnerWorker worker;
        File file;
        block13: {
            String filePath = this.getFile();
            if (filePath == null) {
                return;
            }
            file = new File(filePath);
            worker = this.getBurnerWorker();
            worker.setProgressMonitor(fastbootMonitor);
            worker.setFlashType(this.getFlashType());
            transferWay = this.getBurnContext().getTransferWay();
            File home = new File(file.getParent());
            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                fastbootMonitor.getEvent().setBurner(this);
            }
            boolean start = false;
            InetAddress address = null;
            try {
                address = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {}
            int port = FastbootPreferences.getInt("vendor.burn.tftp.port");
            try {
                try {
                    start = TFTPService.TFTPSERVICE.start(home, address, ToolUtils.getPortCmd(), port);
                    this.getTftpPreferenceValue();
                    this.getBurnContext().setTftpOccupied(!start);
                }
                catch (Exception exception) {
                    this.getBurnContext().setTftpOccupied(true);
                    this.handleTftpStartFailed();
                    if (!start && fastbootMonitor != null) {
                        fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (!start && fastbootMonitor != null) {
                    fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
                }
                throw throwable;
            }
            if (!start && fastbootMonitor != null) {
                fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_failed_on_port_69);
            }
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Upload By Address"){

                protected IStatus run(IProgressMonitor monitor) {
                    boolean needOpenSerial;
                    boolean bl = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial && !((UnknownDevice)AddressBurner.this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
                    if (needOpenSerial) {
                        monitor.beginTask("Open Serial Port", 10);
                        SerialPort serialPort = AddressBurner.this.openSerailPort(fastbootMonitor, worker, AddressBurner.this.getBurnContext().getLocalConfig().getComPort());
                        monitor.beginTask("Open Serial Port", 20);
                        if (serialPort == null) {
                            return null;
                        }
                    } else if (fastbootMonitor != null) {
                        fastbootMonitor.begin();
                    }
                    if (FastbootView.isCJ303V300()) {
                        worker.setProgressMonitor(monitor);
                        if (!worker.sendTranslateWayFrame(transferWay)) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    try {
                        try {
                            FileSystem fileSystem = FileSystem.none;
                            if (AddressBurner.this.uploadOption == UploadOption.DATA_OOB) {
                                fileSystem = FileSystem.yaffs;
                            }
                            boolean upload = worker.upload(monitor, file, fileSystem, AddressBurner.this.getAddress(), AddressBurner.this.getLength(), true, AddressBurner.this.getCurrentChipId());
                            worker.sendResetCommand();
                            event.setSuccess(upload);
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                                fastbootMonitor.getEvent().setMessage(e.getMessage());
                            }
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    AddressBurner.this.shutDownTFTP(fastbootMonitor);
                    AddressBurner.this.closeByTrans();
                }
            });
            job.schedule();
        }
    }

    public ChipID getCurrentChipId() {
        ChipID id = null;
        id = FastbootView.isCJXX1Series() ? this.chipId : ChipID.chip0;
        return id;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public ChipID getChipID() {
        return this.chipId;
    }

    @Override
    public void setFlashId(ChipID chipId) {
        this.chipId = chipId;
    }

    @Override
    public ITab getTab() {
        return new AddressTab();
    }

    @Override
    public void eraseAll(IFastbootProgressMonitor monitor) {
    }
}

