/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.CrcCommand;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.model.BoardConfig;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.ProductLine;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.BurnStatus;
import com.vendor.burn.model.define.IErasable;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.define.IUploadable;
import com.vendor.burn.model.devices.ICommonBurner;
import com.vendor.burn.model.devices.IDeviceSetting;
import com.vendor.burn.model.devices.ITab;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.model.monitor.CmdMonitor;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.NandImageDialog;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.packagers.pro.EmmcProPackager;
import com.vendor.burn.packagers.pro.ProPackager;
import com.vendor.burn.serial.workers.CallLibBootromWorker;
import com.vendor.burn.serial.workers.CommonBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.ui.burners.tabs.CommonTab;
import com.vendor.burn.ui.dialog.SelectNandImageDialog;
import com.vendor.burn.utilitily.ToolUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.vendor.tftp.tool.TFTPService;

public class CommonBurner
extends EmmcBurner
implements ICommonBurner,
IErasable,
IUploadable {
    public static boolean isSocketTransfer;
    private long spiTotalLen = 0L;
    private long nandTotalLen = 0L;
    private long emmcTotalLen = 0L;
    private String saveNandImgPath;

    public CommonBurner(BurnContext burnContext) {
        super(burnContext);
        this.getChildren().clear();
        PartitionItem fastboot = new PartitionItem();
        fastboot.setName("fastboot");
        fastboot.setFileSystem(FileSystem.none);
        this.getChildren().add(fastboot);
    }

    /*
     * Loose catch block
     */
    public int commonBurn(IFastbootProgressMonitor fastbootMonitor, CommonBurnerWorker worker) {
        int[] errorCode;
        block27: {
            boolean result;
            block24: {
                FastbootEvent event;
                block26: {
                    block25: {
                        result = false;
                        errorCode = new int[1];
                        event = fastbootMonitor.getEvent();
                        if (!ToolUtils.isCmdLine()) {
                            Job fastbootJob = this.startBurnJob(fastbootMonitor, worker);
                            this.closeBurnJobThread(fastbootMonitor, fastbootJob);
                            break block24;
                        }
                        if (this.initFastbootMonitor(fastbootMonitor, EventType.BURN)) break block25;
                        int n = BurnStatus.NULL_POINTER_ERROR.getErrorCode();
                        if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                            errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                        }
                        worker.createFileForRecvSerial();
                        this.closeByTrans();
                        if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                            fastbootMonitor.finish();
                        }
                        return n;
                    }
                    boolean initResult = this.initTransferway(fastbootMonitor, this.getBurnContext(), worker);
                    if (initResult) break block26;
                    int n = BurnStatus.INIT_TRANSFER_WAY_FAILED.getErrorCode();
                    if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                        errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                    }
                    worker.createFileForRecvSerial();
                    this.closeByTrans();
                    if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                        fastbootMonitor.finish();
                    }
                    return n;
                }
                try {
                    CmdMonitor cmdMonitor = new CmdMonitor();
                    int selectedPartCount = worker.getSelectedPartCount(this.children);
                    result = worker.burnByTransferWay(cmdMonitor, this.children, selectedPartCount, errorCode);
                    event.setSuccess(result);
                }
                catch (IOException iOException) {
                    if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                        errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                    }
                    worker.createFileForRecvSerial();
                    this.closeByTrans();
                    if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                        fastbootMonitor.finish();
                    }
                    break block27;
                }
                catch (ReceiveTimeOutException receiveTimeOutException) {
                    break block27;
                }
                catch (Throwable e) {
                    fastbootMonitor.getEvent().setMessage(e.getMessage());
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                        errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                    }
                    worker.createFileForRecvSerial();
                    this.closeByTrans();
                    if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                        fastbootMonitor.finish();
                    }
                    break block27;
                }
                {
                    finally {
                        if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                            errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
                        }
                        worker.createFileForRecvSerial();
                        this.closeByTrans();
                        if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                            fastbootMonitor.finish();
                        }
                    }
                }
            }
            if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                errorCode[0] = BurnStatus.BURN_PARTITION_FAILED.getErrorCode();
            }
            worker.createFileForRecvSerial();
            this.closeByTrans();
            if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                fastbootMonitor.finish();
            }
        }
        return errorCode[0];
    }

    @Override
    public void burn(IFastbootProgressMonitor fastbootMonitor) {
        CommonBurnerWorker worker;
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.BURN)) {
            return;
        }
        BurnContext context = this.getBurnContext();
        boolean initResult = this.initTransferway(fastbootMonitor, context, worker = this.getBurnerWorker());
        if (!initResult) {
            return;
        }
        this.commonBurn(fastbootMonitor, worker);
    }

    /*
     * Loose catch block
     */
    @Override
    public int erase(IFastbootProgressMonitor fastbootMonitor, CommonBurnerWorker worker) {
        int[] errorCode;
        block26: {
            FastbootEvent event;
            boolean result;
            block24: {
                SerialPort serialPort;
                BurnContext context;
                block25: {
                    if (fastbootMonitor == null) {
                        return BurnStatus.NULL_POINTER_ERROR.getErrorCode();
                    }
                    result = false;
                    errorCode = new int[1];
                    event = fastbootMonitor.getEvent();
                    context = this.getBurnContext();
                    worker.setProgressMonitor(fastbootMonitor);
                    IDeviceSetting deviceSetting = this.getBurnContext().getDeviceSetting();
                    if (!(deviceSetting instanceof UnknownDevice)) break block24;
                    if (this.openSocket()) break block25;
                    int n = BurnStatus.OPEN_SOCKET_ERROR.getErrorCode();
                    if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                        errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
                    }
                    this.closeByTrans();
                    if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                        fastbootMonitor.finish();
                    }
                    return n;
                }
                if (!this.isOpenSerailPort(this.getBurnContext().getTransferWay()) || ((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom() || fastbootMonitor == null || (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) != null) break block24;
                int n = BurnStatus.INIT_TRANSFER_WAY_FAILED.getErrorCode();
                if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                    errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
                }
                this.closeByTrans();
                if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                    fastbootMonitor.finish();
                }
                return n;
            }
            try {
                CmdMonitor cmdMonitor = new CmdMonitor();
                result = worker.erase(cmdMonitor, this.children);
                event.setSuccess(result);
            }
            catch (IOException iOException) {
                if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                    errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
                }
                this.closeByTrans();
                if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                    fastbootMonitor.finish();
                }
                break block26;
            }
            catch (ReceiveTimeOutException receiveTimeOutException) {
                break block26;
            }
            catch (Throwable e) {
                fastbootMonitor.getEvent().setMessage(e.getMessage());
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                    errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
                }
                this.closeByTrans();
                if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                    fastbootMonitor.finish();
                }
                break block26;
            }
            {
                finally {
                    if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                        errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
                    }
                    this.closeByTrans();
                    if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                        fastbootMonitor.finish();
                    }
                }
            }
            if (!result && errorCode[0] == BurnStatus.SUCCESS.getErrorCode()) {
                errorCode[0] = BurnStatus.ERASE_PARTITION_FAILED.getErrorCode();
            }
            this.closeByTrans();
            if (ToolUtils.isCmdLine() && fastbootMonitor != null) {
                fastbootMonitor.finish();
            }
        }
        return errorCode[0];
    }

    @Override
    public void erase(IFastbootProgressMonitor fastbootMonitor) {
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.ERASE) || fastbootMonitor == null) {
            return;
        }
        fastbootMonitor.begin();
        CommonBurnerWorker worker = this.getBurnerWorker();
        Job fastbootJob = this.startEarseJob(fastbootMonitor, worker);
        this.closeEraseJob(fastbootMonitor, worker, fastbootJob);
    }

    @Override
    public void eraseAll(IFastbootProgressMonitor fastbootMonitor) {
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.ERASE) || fastbootMonitor == null) {
            return;
        }
        fastbootMonitor.begin();
        CommonBurnerWorker worker = this.getBurnerWorker();
        Job fastbootJob = this.startEraseAllJob(fastbootMonitor, worker);
        this.closeEraseAllJob(fastbootMonitor, worker, fastbootJob);
    }

    @Override
    public void upload(IFastbootProgressMonitor fastbootMonitor) {
        CommonBurnerWorker worker;
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.UPLOAD)) {
            return;
        }
        BurnContext context = this.getBurnContext();
        boolean initResult = this.initTransferway(fastbootMonitor, context, worker = this.getBurnerWorker());
        if (!initResult) {
            return;
        }
        Job job = this.startUploadJob(fastbootMonitor, worker);
        this.closeUploadThread(fastbootMonitor, job);
    }

    @Override
    public void createImage(IFastbootProgressMonitor fastbootMonitor) {
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.CREATE_IMAGE)) {
            return;
        }
        CommonBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        FastbootEvent event = fastbootMonitor.getEvent();
        List<PartitionItem> parts = this.getChildren();
        boolean onlySelectEmmc = FlashType.isOnlyEmmc(parts, FlashType.emmc);
        if (onlySelectEmmc) {
            this.makeEmmcBurnImage(fastbootMonitor, worker, event);
        } else {
            this.createNandImage(fastbootMonitor, parts);
        }
    }

    @Override
    public void createProImage(final IFastbootProgressMonitor fastbootMonitor, final String outputPath, final List<PartitionItem> parts) {
        if (!this.initFastbootMonitor(fastbootMonitor, EventType.CREATE_USB_PACKAGE)) {
            return;
        }
        final CommonBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        Job job = new Job("Create USB package"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Create USB package", 10);
                int result = 0;
                if (FlashType.isOnlySelectCurFlashType(parts, FlashType.emmc)) {
                    EmmcProPackager packager = new EmmcProPackager(worker.getBurner());
                    packager.setPartitionItems(parts);
                    result = packager.doPackage(SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)10), outputPath);
                } else {
                    ProPackager packager = new ProPackager(CommonBurner.this.getBurnerWorker().getBurner());
                    packager.setPartitionItems(parts);
                    result = packager.doPackage(SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)10), outputPath);
                }
                if (result == 0) {
                    fastbootMonitor.getEvent().setSuccess(true);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.OK_STATUS;
                }
                if (result == -1) {
                    fastbootMonitor.getEvent().setSuccess(false);
                    fastbootMonitor.getEvent().setMessage(Messages.BurnComposite_Usb_Pack_Canceled);
                    monitor.done();
                    fastbootMonitor.finish();
                    return Status.CANCEL_STATUS;
                }
                fastbootMonitor.getEvent().setSuccess(false);
                monitor.done();
                fastbootMonitor.finish();
                return Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    @Override
    public CommonBurnerWorker getBurnerWorker() {
        return new CommonBurnerWorker(this);
    }

    @Override
    public ITab getTab() {
        return new CommonTab();
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus result = this.checkTransferWay();
        if (!this.isOK(result)) {
            return result;
        }
        result = this.checkTable(EventType.BURN);
        if (!this.isOK(result)) {
            return result;
        }
        if (!ToolUtils.isCmdLine() && !this.isOK(this.checkHasSelectNullFile())) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean openSocket() {
        BoardConfig boardConfig = this.getBurnContext().getBoardConfig();
        if (boardConfig.isSocket() && ProductLine.PRODUCTLINE.CAM == ToolUtils.getProductLine()) {
            return CallLibBootromWorker.createSerialPortServer(boardConfig.getSerialServerIp(), boardConfig.getSerialServerPort());
        }
        return true;
    }

    @Override
    public IStatus checkBeforeErase() {
        IStatus check = super.checkBeforeBurn();
        if (!this.isOK(check)) {
            return check;
        }
        check = this.checkTable(EventType.ERASE);
        if (!this.isOK(check)) {
            return check;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus checkBeforeUpload() {
        boolean isUsb;
        IStatus validLocalConfig = this.validSerialPort();
        if (!this.isOK(validLocalConfig)) {
            return validLocalConfig;
        }
        IStatus check = this.validNetConfig();
        if (!this.isOK(check)) {
            return check;
        }
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean isI2C = transferWay == TransferWay.Usb2I2c || transferWay == TransferWay.I2CBootrom;
        boolean bl = isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude || transferWay == TransferWay.UsbAndSerial;
        if (isI2C) {
            return this.error(NLS.bind((String)Messages.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"I2C"));
        }
        if (isUsb) {
            return this.error(NLS.bind((String)Messages.AddressComposite_Current_Chip_NotSupport_Upload, (Object)"USB"));
        }
        check = this.checkTable(EventType.UPLOAD);
        if (!this.isOK(check)) {
            return check;
        }
        return null;
    }

    @Override
    public IStatus checkCreateImage() {
        List<PartitionItem> parts = this.getChildren();
        if (parts.isEmpty()) {
            return null;
        }
        IStatus result = this.checkTable(EventType.BURN);
        if (!this.isOK(result)) {
            return result;
        }
        int i = 0;
        while (i < parts.size()) {
            PartitionItem partition = (PartitionItem)this.children.get(i);
            if (partition.isChecked()) {
                FlashType flashType = partition.getFlashType();
                File file = partition.getFile();
                if (flashType == FlashType.spi) {
                    this.highLight(partition);
                    return this.error(NLS.bind((String)Messages.PartitionBurner_msg_invalid_flash_type, (Object)(i + 1)));
                }
                if (flashType == FlashType.nand) {
                    if (file == null) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)(i + 1)));
                    }
                    if (!file.exists()) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(i + 1)));
                    }
                    if (file.isDirectory()) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(i + 1)));
                    }
                }
            }
            ++i;
        }
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        for (PartitionItem partitionItem : parts) {
            FlashType flashType = partitionItem.getFlashType();
            if (hasFlashTypes.contains((Object)flashType)) continue;
            hasFlashTypes.add(flashType);
        }
        if (hasFlashTypes.contains((Object)FlashType.emmc) && hasFlashTypes.contains((Object)FlashType.nand)) {
            return this.error(Messages.CommonComposite_Check_Burn_Image_NotSupport_Mixed);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus checkCreateProImage() {
        List<PartitionItem> parts = this.getChildren();
        if (parts.isEmpty()) {
            return null;
        }
        IStatus result = this.checkTable(EventType.BURN);
        if (!this.isOK(result)) {
            return result;
        }
        int i = 0;
        while (i < parts.size()) {
            PartitionItem partition = (PartitionItem)this.children.get(i);
            if (partition.isChecked()) {
                FlashType flashType = partition.getFlashType();
                File file = partition.getFile();
                if (flashType == FlashType.nand) {
                    if (file == null) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_file_path_does_not_select_in_row_, (Object)(i + 1)));
                    }
                    if (!file.exists()) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_file_does_not_exist_in_row_, (Object)(i + 1)));
                    }
                    if (file.isDirectory()) {
                        this.highLight(partition);
                        return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)(i + 1)));
                    }
                }
            }
            ++i;
        }
        ArrayList<FlashType> hasFlashTypes = new ArrayList<FlashType>();
        for (PartitionItem partitionItem : parts) {
            FlashType flashType = partitionItem.getFlashType();
            if (hasFlashTypes.contains((Object)flashType)) continue;
            hasFlashTypes.add(flashType);
        }
        if (hasFlashTypes.contains((Object)FlashType.emmc) && (hasFlashTypes.contains((Object)FlashType.nand) || hasFlashTypes.contains((Object)FlashType.spi))) {
            return this.error(Messages.CommonComposite_Check_Burn_Image_NotSupport_Mixed);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus checkTable(EventType event) {
        List<PartitionItem> parts = this.getChildren();
        IStatus check = this.checkPartSelect(parts);
        if (!this.isOK(check)) {
            return check;
        }
        check = this.checkFastbootPart(parts.get(0), event);
        if (!this.isOK(check)) {
            if (!ToolUtils.isCmdLine()) {
                this.getBurnContext().getUIAdapter().highLight(parts.get(0));
            }
            return check;
        }
        check = this.checkOtherPart(parts, event);
        if (!this.isOK(check)) {
            return check;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus checkOtherPart(List<PartitionItem> parts, EventType event) {
        FlashType[] flashTypes = FlashType.getFlashTypes(this);
        FileSystem[] fileSystems = FileSystem.getFileSystems(this);
        long spiLastAddress = 0L;
        long nandLastAddress = 0L;
        long emmcLastAddress = 0L;
        IStatus result = Status.OK_STATUS;
        PartitionItem fastboot = parts.get(0);
        this.spiTotalLen = 0L;
        this.nandTotalLen = 0L;
        this.emmcTotalLen = 0L;
        long fastbootPartLen = fastboot.getLength();
        if (FlashType.spi == fastboot.getFlashType()) {
            this.spiTotalLen = fastbootPartLen;
        } else if (FlashType.nand == fastboot.getFlashType()) {
            this.nandTotalLen = fastbootPartLen;
        } else if (FlashType.emmc == fastboot.getFlashType()) {
            this.emmcTotalLen = fastbootPartLen;
        }
        int partIndex = 1;
        while (partIndex < parts.size()) {
            block26: {
                File file;
                PartitionItem part;
                block28: {
                    block29: {
                        block27: {
                            part = parts.get(partIndex);
                            if (!part.isChecked()) break block26;
                            result = this.checkFlashAndFileSystem(partIndex, flashTypes, fileSystems, part);
                            if (result != Status.OK_STATUS) {
                                return result;
                            }
                            result = this.checkStartAddressAndLen(part, parts.size(), partIndex);
                            if (result != Status.OK_STATUS) {
                                return result;
                            }
                            result = this.checkAddressOverlap(partIndex, part);
                            if (result != Status.OK_STATUS) {
                                return result;
                            }
                            long start = part.getStart();
                            if (0L == part.getLength() && part.getFlashType() != FlashType.ssd) {
                                this.highLight(part);
                                return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_partition_length_must_be_nonzero_in_row_, (Object)(partIndex + 1)));
                            }
                            if (FlashType.spi == part.getFlashType()) {
                                if (start < spiLastAddress) {
                                    this.highLight(part);
                                    return this.error(NLS.bind((String)Messages.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(partIndex + 1)));
                                }
                                spiLastAddress = start + (part.getLength() == -1L ? 0L : part.getLength());
                            } else if (FlashType.nand == part.getFlashType()) {
                                if (start < nandLastAddress) {
                                    this.highLight(part);
                                    return this.error(NLS.bind((String)Messages.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(partIndex + 1)));
                                }
                                nandLastAddress = start + (part.getLength() == -1L ? 0L : part.getLength());
                            } else if (FlashType.emmc == part.getFlashType()) {
                                if (start < emmcLastAddress) {
                                    this.highLight(part);
                                    return this.error(NLS.bind((String)Messages.AbstractBurner_messgae_the_partition_address_must_be_greater_than_the_used_size_in_row_, (Object)(partIndex + 1)));
                                }
                                emmcLastAddress = start + (part.getLength() == -1L ? 0L : part.getLength());
                            }
                            if (!part.isChecked()) break block26;
                            file = part.getFile();
                            if (EventType.BURN != event) break block27;
                            result = this.checkBurn(parts.size(), partIndex, part, file);
                            break block28;
                        }
                        if (EventType.UPLOAD != event) break block29;
                        result = this.checkUpload(parts.size(), partIndex, part, file);
                        if (result != Status.OK_STATUS) {
                            return result;
                        }
                        break block26;
                    }
                    if (EventType.ERASE == event) break block26;
                }
                if (result != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkStartAndLen(part, partIndex, parts.size());
                if (result != Status.OK_STATUS) {
                    return result;
                }
                result = this.checkNetFileNameLen(partIndex, file);
                if (result != Status.OK_STATUS) {
                    return result;
                }
            }
            ++partIndex;
        }
        return Status.OK_STATUS;
    }

    private boolean initFastbootMonitor(IFastbootProgressMonitor fastbootMonitor, EventType evenType) {
        if (fastbootMonitor == null) {
            return false;
        }
        fastbootMonitor.getEvent().init(evenType);
        this.worker.setProgressMonitor(fastbootMonitor);
        return true;
    }

    private Job startBurnJob(final IFastbootProgressMonitor fastbootMonitor, final CommonBurnerWorker worker) {
        final FastbootEvent event = fastbootMonitor.getEvent();
        Job fastbootJob = new Job("Burn By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean partBurn = worker.burn(monitor, CommonBurner.this.children);
                        event.setSuccess(partBurn);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        return fastbootJob;
    }

    private void closeBurnJobThread(final IFastbootProgressMonitor fastbootMonitor, Job fastbootJob) {
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        TFTPService.TFTPSERVICE.stop();
                    }
                }).start();
                CommonBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    private Job startEarseJob(final IFastbootProgressMonitor fastbootMonitor, final CommonBurnerWorker worker) {
        Job fastbootJob = new Job("Erase By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean erase = worker.erase(monitor, CommonBurner.this.getChildren());
                        fastbootMonitor.getEvent().setSuccess(erase);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        return fastbootJob;
    }

    private void closeEraseJob(final IFastbootProgressMonitor fastbootMonitor, CommonBurnerWorker worker, Job fastbootJob) {
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                CommonBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    private Job startUploadJob(final IFastbootProgressMonitor fastbootMonitor, final CommonBurnerWorker worker) {
        final FastbootEvent event = fastbootMonitor.getEvent();
        event.setBurner(this);
        Job job = new Job("Upload By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean upload = worker.upload(monitor, CommonBurner.this.getChildren());
                        event.setSuccess(upload);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private void closeUploadThread(final IFastbootProgressMonitor fastbootMonitor, Job job) {
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                CommonBurner.this.shutDownTFTP(fastbootMonitor);
                CommonBurner.this.closeByTrans();
            }
        });
        job.schedule();
    }

    private boolean initTransferway(IFastbootProgressMonitor fastbootMonitor, BurnContext context, CommonBurnerWorker worker) {
        if (!this.initUart(fastbootMonitor, context, worker)) {
            return false;
        }
        if (!this.initNetWork(fastbootMonitor, context, worker)) {
            return false;
        }
        return this.initI2CBootrom(fastbootMonitor, context, worker);
    }

    private boolean initI2CBootrom(IFastbootProgressMonitor fastbootMonitor, BurnContext context, CommonBurnerWorker worker) {
        if (context.getTransferWay() == TransferWay.I2CBootrom) {
            if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is " + 52);
            } else {
                worker.infoln("I2C channels open failed");
                return false;
            }
        }
        return true;
    }

    private boolean initUart(IFastbootProgressMonitor fastbootMonitor, BurnContext context, CommonBurnerWorker worker) {
        TransferWay transferWay = this.getCurTransferWay();
        boolean needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
        isSocketTransfer = context.getBoardConfig().isSocket();
        if (needOpenSerial) {
            SerialPort serialPort;
            if (!isSocketTransfer && (serialPort = this.openSerailPort(fastbootMonitor, worker, context.getLocalConfig().getComPort())) == null) {
                worker.infoln("Open serail port failed");
                return false;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        return true;
    }

    private boolean initNetWork(IFastbootProgressMonitor fastbootMonitor, BurnContext context, CommonBurnerWorker worker) {
        if (worker.isNeedSetupNet(this.getCurTransferWay())) {
            boolean start = false;
            InetAddress address = null;
            boolean portCheck = false;
            try {
                address = InetAddress.getByName("0.0.0.0");
            }
            catch (UnknownHostException unknownHostException) {}
            int port = CrcCommand.getTFTPPort();
            try {
                try {
                    portCheck = TFTPService.TFTPSERVICE.checkPort(ToolUtils.getPortCmd(), port);
                    if (portCheck) {
                        start = TFTPService.TFTPSERVICE.start(this.getParentFile(), address, port);
                    } else {
                        fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_on_port_69_is_used);
                    }
                    this.getTftpPreferenceValue();
                    context.setTftpOccupied(!start);
                }
                catch (SocketException socketException) {
                    context.setTftpOccupied(true);
                    this.handleTftpStartFailed();
                    if (!start && portCheck) {
                        fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_start);
                        return false;
                    }
                }
            }
            finally {
                if (!start && portCheck) {
                    fastbootMonitor.warnln(Messages.PartitionBurner_msg_start_Tftp_server_start);
                    return false;
                }
            }
        }
        return true;
    }

    private File getParentFile() {
        if (this.children == null || this.children.isEmpty()) {
            return null;
        }
        for (PartitionItem partition : this.children) {
            if (!partition.isChecked() || partition.getFile() == null) continue;
            return partition.getFile().getParentFile();
        }
        return null;
    }

    private IStatus checkPartSelect(List<PartitionItem> parts) {
        int selection = 0;
        for (PartitionItem partitionItem : parts) {
            if (!partitionItem.isChecked()) continue;
            ++selection;
            break;
        }
        if (selection == 0) {
            return this.error(Messages.AbstractBurner_msg_emmc_no_createTable_and_non_partition);
        }
        return Status.OK_STATUS;
    }

    private IStatus checkTransferWay() {
        boolean supportI2C;
        boolean supportUart2Compress;
        IStatus check;
        boolean needCheckTftp;
        IStatus check2;
        boolean needCheckSerial;
        TransferWay transferWay = this.getCurTransferWay();
        boolean bl = needCheckSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndSerial;
        if (needCheckSerial && !this.isOK(check2 = this.validSerialPort())) {
            return check2;
        }
        boolean bl2 = needCheckTftp = transferWay == TransferWay.Net || transferWay == TransferWay.UsbTransNet || transferWay == TransferWay.JTAGAndNet;
        if (needCheckTftp && !this.isOK(check = this.validNetConfig())) {
            return check;
        }
        List<PartitionItem> parts = this.getChildren();
        boolean hasEmmcFlash = false;
        ArrayList<FlashType> hasFlashTypes = FlashType.getCurFlashTypes(parts);
        for (FlashType flashType : hasFlashTypes) {
            if (flashType != FlashType.emmc) continue;
            hasEmmcFlash = true;
            break;
        }
        boolean bl3 = supportUart2Compress = !hasEmmcFlash && transferWay == TransferWay.Uart2Compress;
        if (supportUart2Compress) {
            return this.error(NLS.bind((String)Messages.CommonComposite_Check_EmmcFlash_NotSupport_Current_Transmission, (Object)FlashType.emmc.name(), (Object)Messages.FastbootView_TransferWay_Uart2Compress));
        }
        boolean bl4 = supportI2C = hasEmmcFlash && (transferWay == TransferWay.I2CBootrom || transferWay == TransferWay.Usb2I2c);
        if (supportI2C) {
            return this.error(NLS.bind((String)Messages.CommonComposite_Check_EmmcFlash_NotSupport_Current_Transmission, (Object)FlashType.emmc.name(), (Object)Messages.FastbootView_TransferWay_I2cBootrom));
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFlashAndFileSystem(int partIndex, FlashType[] flashTypes, FileSystem[] fileSystems, PartitionItem part) {
        boolean invaildFlashForExt3;
        boolean invaildFlashForUbifs;
        boolean invaildFlashForYaffs;
        Object flashType;
        boolean valid = false;
        Object[] objectArray = fileSystems;
        int n = fileSystems.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fileSystem = objectArray[n2];
            if (fileSystem == part.getFileSystem()) {
                valid = true;
                break;
            }
            ++n2;
        }
        if (!valid) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_invalid_file_system_in_row_, (Object)(partIndex + 1)));
        }
        valid = false;
        objectArray = flashTypes;
        n = flashTypes.length;
        n2 = 0;
        while (n2 < n) {
            flashType = objectArray[n2];
            if (flashType == part.getFlashType()) {
                valid = true;
                break;
            }
            ++n2;
        }
        if (!valid) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_invalid_flash_type_in_row_, (Object)(partIndex + 1)));
        }
        flashType = part.getFlashType();
        FileSystem fileSystem = part.getFileSystem();
        boolean bl = invaildFlashForYaffs = fileSystem == FileSystem.yaffs && flashType != FlashType.nand;
        if (invaildFlashForYaffs) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.PartitionBurner_msg_flash_SPI_and_file_system_Yaffs_can_not_be_selected_at_the_same_time_in_row_, (Object)(partIndex + 1)));
        }
        boolean bl2 = invaildFlashForUbifs = fileSystem == FileSystem.ubiFs && flashType != FlashType.nand;
        if (invaildFlashForUbifs) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.PartitionBurner_UBI_only_support_Nand_flash, (Object)(partIndex + 1)));
        }
        boolean bl3 = invaildFlashForExt3 = (fileSystem == FileSystem.ext3 || fileSystem == FileSystem.f2fs || fileSystem == FileSystem.erofs) && flashType != FlashType.emmc && flashType != FlashType.ufs && flashType != FlashType.ssd;
        if (invaildFlashForExt3) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.PartitionBurner_EXT3_only_support_Emmc_flash, (Object)(partIndex + 1)));
        }
        IStatus result = this.checkYaffsFile(partIndex, part, fileSystem);
        if (result != Status.OK_STATUS) {
            return result;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkAddressOverlap(int index, PartitionItem part) {
        long start = part.getStart();
        long length = part.getLength();
        FlashType flashType = part.getFlashType();
        IStatus result = Status.OK_STATUS;
        if (FlashType.spi == flashType) {
            result = this.checkFlashTotalLen(index, part, this.spiTotalLen, start);
            this.spiTotalLen = start + length;
        } else if (FlashType.nand == flashType) {
            result = this.checkFlashTotalLen(index, part, this.nandTotalLen, start);
            this.nandTotalLen = start + length;
        } else if (FlashType.emmc == flashType) {
            result = this.checkFlashTotalLen(index, part, this.emmcTotalLen, start);
            this.emmcTotalLen = start + length;
        }
        if (!this.isOK(result)) {
            return result;
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFlashTotalLen(int index, PartitionItem part, long totalLength, long start) {
        if (0L == start && 0L != totalLength) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_partition_address_must_be_nonzero_in_row_, (Object)(index + 1)));
        }
        if (0L != totalLength && start < totalLength) {
            this.highLight(part);
            return this.error(NLS.bind((String)Messages.PartitionBurner_msg_address_overlap_in_row_, (Object)(index + 1)));
        }
        return Status.OK_STATUS;
    }

    private void closeEraseAllJob(final IFastbootProgressMonitor fastbootMonitor, CommonBurnerWorker worker, Job fastbootJob) {
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                CommonBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    private Job startEraseAllJob(final IFastbootProgressMonitor fastbootMonitor, final CommonBurnerWorker worker) {
        Job fastbootJob = new Job("Erase By Partition"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean erase = worker.eraseAll(monitor, CommonBurner.this.children);
                        fastbootMonitor.getEvent().setSuccess(erase);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        return fastbootJob;
    }

    private TransferWay getCurTransferWay() {
        return this.getBurnContext().getTransferWay();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NandIPCommon chooseNandSet(UnknownDevice device, int nandIPVer, int spinandIPVer) {
        NandIPCommon nandSet = null;
        if (nandIPVer != -1 && spinandIPVer != -1) {
            SelectNandImageDialog selectNandImageDialog = new SelectNandImageDialog(Display.getCurrent().getActiveShell());
            int open = selectNandImageDialog.open();
            if (open != 0) return null;
            String selectedNandWay = selectNandImageDialog.getSelectNandImageWay();
            if (selectedNandWay.equals("Nand")) {
                nandSet = NandIPCommon.chooseNandVersion(device);
            } else if (selectedNandWay.equals("SPINand")) {
                nandSet = NandIPCommon.chooseSPINandVersion(device);
            }
            if (nandSet == null) return nandSet;
            nandSet.setCurSelectedNandWay(selectedNandWay);
            return nandSet;
        } else if (spinandIPVer != -1) {
            nandSet = NandIPCommon.chooseSPINandVersion(device);
            if (nandSet == null) return nandSet;
            nandSet.setCurSelectedNandWay("SPINand");
            return nandSet;
        } else {
            nandSet = NandIPCommon.chooseNandVersion(device);
            if (nandSet == null) return nandSet;
            nandSet.setCurSelectedNandWay("Nand");
        }
        return nandSet;
    }

    private boolean checkCurChipSupport(int nandIPVer, int spinandIPVer) {
        boolean supportSpi;
        boolean supportNand = nandIPVer != 500 && nandIPVer != 600 && nandIPVer != 610 && nandIPVer != 611 && nandIPVer != 620;
        boolean bl = supportSpi = spinandIPVer != 500 && spinandIPVer != 600 && spinandIPVer != 610 && spinandIPVer != 611 && spinandIPVer != 620;
        if (supportNand && supportSpi) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"BurnTool", (String)Messages.NandImage_DoNotSupport);
            return false;
        }
        return true;
    }

    private void createNandImage(final IFastbootProgressMonitor fastbootMonitor, final List<PartitionItem> parts) {
        String path;
        int spinandIPVer;
        IDeviceSetting deviceSetting = this.getBurnContext().getDeviceSetting();
        if (deviceSetting == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"BurnTool", (String)Messages.PartitionComposite_MakeNandImage_DoNotSupport);
            fastbootMonitor.finish();
            return;
        }
        UnknownDevice device = (UnknownDevice)deviceSetting;
        int nandIPVer = device.getNandIPVer();
        if (!this.checkCurChipSupport(nandIPVer, spinandIPVer = device.getSpinandIPVer())) {
            fastbootMonitor.finish();
            return;
        }
        NandIPCommon nandSet = this.chooseNandSet(device, nandIPVer, spinandIPVer);
        if (nandSet == null) {
            fastbootMonitor.finish();
            return;
        }
        NandImageDialog dialog = new NandImageDialog(Display.getCurrent().getActiveShell(), 67680, nandSet, this);
        dialog.open();
        final FlashOption option = dialog.getSelectedFlashOption();
        final NandIPCommon nandSetting = nandSet;
        final int blockSize = dialog.getBlockSize();
        if (option == null) {
            fastbootMonitor.finish();
            return;
        }
        final boolean isSelectRandom = dialog.isSelectRandom();
        DirectoryDialog outputSelectDialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        outputSelectDialog.setText(Messages.NandImageDialog_DstFolder);
        outputSelectDialog.setMessage(Messages.NandImageDialog_DstFolderSelect);
        if (this.saveNandImgPath != null) {
            outputSelectDialog.setFilterPath(this.saveNandImgPath);
        }
        if ((path = outputSelectDialog.open()) == null) {
            fastbootMonitor.finish();
            return;
        }
        this.saveNandImgPath = path;
        Job job = new Job("Create Nand Burner Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                nandSetting.make(path, option, parts, blockSize, isSelectRandom, fastbootMonitor, monitor);
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation(null, (String)"BurnTool", (String)Messages.PartitionComposite_MakeNandImage_Finish);
                    }
                });
            }
        });
        job.schedule();
    }

    private void makeEmmcBurnImage(final IFastbootProgressMonitor fastbootMonitor, final CommonBurnerWorker worker, final FastbootEvent event) {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        String open = dialog.open();
        if (open == null) {
            fastbootMonitor.finish();
            return;
        }
        final File file = new File(open);
        if (file.isDirectory()) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)"Can not be a Directory!");
            fastbootMonitor.finish();
        }
        Job job = new Job("Making Image..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean createImage = worker.createImage(monitor, file, CommonBurner.this.getChildren(), false);
                        event.setSuccess(createImage);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
            }
        });
        job.schedule();
    }
}

