/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IDdrBurner;
import com.vendor.burn.model.devices.ITab;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.model.event.EventType;
import com.vendor.burn.model.event.FastbootEvent;
import com.vendor.burn.serial.workers.CallLibUSBWorker;
import com.vendor.burn.serial.workers.DdrBurnerWorker;
import com.vendor.burn.ui.burners.tabs.DdrTab;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class DdrBurner
extends PartitionBurner
implements IDdrBurner {
    public DdrBurner(BurnContext burnContext) {
        super(burnContext);
        this.getChildren().clear();
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor, final String directory) {
        final DdrBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        final FastbootEvent event = fastbootMonitor.getEvent();
        final BurnContext context = this.getBurnContext();
        Job job = new Job("Ddr Burn..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        if (fastbootMonitor != null) {
                            fastbootMonitor.begin();
                        }
                        boolean result = worker.burn(monitor, directory);
                        event.setSuccess(result);
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        fastbootMonitor.getEvent().setMessage(e.getMessage());
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                boolean isUsb;
                fastbootMonitor.finish();
                TransferWay transferWay = context.getTransferWay();
                boolean bl = isUsb = transferWay == TransferWay.USBBootrom || transferWay == TransferWay.USBNonNude;
                if (isUsb) {
                    CallLibUSBWorker.closeUsb(transferWay);
                    worker.infoln("\nUSB channels were closed successfully.");
                }
            }
        });
        job.schedule();
    }

    @Override
    public DdrBurnerWorker getBurnerWorker() {
        return new DdrBurnerWorker(this);
    }

    @Override
    public ITab getTab() {
        return new DdrTab();
    }

    @Override
    protected IStatus checkTable(EventType event) {
        return null;
    }
}

