/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IBootBurner;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.ITab;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.DdrCheckBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.ui.burners.tabs.DdrCheckTab;
import com.vendor.burn.views.FastbootView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class DdrCheckBurner
extends AbstractBurner
implements IBootBurner {
    private FlashType flashType;
    private String file;

    public DdrCheckBurner(BurnContext burnContext) {
        super(burnContext);
    }

    protected IFrameSetting getFrameSetting() {
        return this.getBurnContext().getDeviceSetting().getFrameSetting();
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(Messages.FastbootBurner_Step_1);
        steps.add(Messages.FastbootBurner_Step_2);
        steps.add(Messages.FastbootBurner_Step_3);
        steps.add(Messages.FastbootBurner_Step_4);
        return steps;
    }

    @Override
    public ITab getTab() {
        return new DdrCheckTab();
    }

    public IStatus OpenPort(IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor, DdrCheckBurnerWorker worker) {
        boolean needOpenSerial;
        LocalConfig config = this.getBurnContext().getLocalConfig();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean isSupportBurnByLibBootrom = false;
        if (!(this.getBurnContext().getDeviceSetting() instanceof UnknownDevice)) {
            return Status.CANCEL_STATUS;
        }
        isSupportBurnByLibBootrom = !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
        boolean bl = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && isSupportBurnByLibBootrom;
        if (needOpenSerial) {
            SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, config.getComPort());
            if (serialPort == null) {
                return Status.CANCEL_STATUS;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        DdrCheckBurnerWorker worker;
        DdrCheckBurnerWorker ddrWorker = null;
        if (this.getBurnerWorker() instanceof DdrCheckBurnerWorker) {
            ddrWorker = (DdrCheckBurnerWorker)this.getBurnerWorker();
        }
        if ((worker = ddrWorker) != null) {
            worker.setProgressMonitor(fastbootMonitor);
            Job fastbootJob = new Job("Burn Fastboot"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (DdrCheckBurner.this.OpenPort(fastbootMonitor, monitor, worker) == Status.CANCEL_STATUS) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        try {
                            worker.burn(monitor, DdrCheckBurner.this.getFlashType(), DdrCheckBurner.this.getFile());
                        }
                        catch (IOException e) {
                            monitor.setCanceled(true);
                            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                                fastbootMonitor.getEvent().setMessage(e.getMessage());
                            }
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                        catch (ReceiveTimeOutException e) {
                            monitor.setCanceled(true);
                            if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                                fastbootMonitor.getEvent().setMessage(e.getMessage());
                            }
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(fastbootJob);
            fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                    DdrCheckBurner.this.closeByTrans();
                }
            });
            fastbootJob.schedule();
        }
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        if (this.flashType == null) {
            return this.error(Messages.AbstractBurner_msg_falshType_is_null);
        }
        if (this.file == null || this.file.trim().length() == 0) {
            return this.error(Messages.AbstractBurner_msg_file_path_does_not_select);
        }
        File theFile = new File(this.file);
        if (!theFile.exists()) {
            return this.error(Messages.AbstractBurner_msg_the_file_does_not_exist);
        }
        if (theFile.isDirectory()) {
            return this.error(Messages.AbstractBurner_msg_the_file_can_not_be_a_directory);
        }
        if (this.file.length() == 0) {
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_file_size_must_be_nonzero, (Object)1));
        }
        if (!(FastbootView.isCJXX0Series() || FastbootView.isCJ303V3Series() || FastbootView.isCJXX1Series() || theFile.length() <= 0x100000L)) {
            return this.error(Messages.AbstractBurner_msg_the_bootFile_size_must_be_less_than_1m);
        }
        return validSerialPort;
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }

    @Override
    public FlashType getFlashType() {
        return this.flashType;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFlashType(FlashType ddr) {
        this.flashType = ddr;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public ChipID getChipID() {
        return null;
    }

    @Override
    public void setFlashId(ChipID chipId) {
    }

    @Override
    protected AbstractBurnerWorker getBurnerWorker() {
        return new DdrCheckBurnerWorker(this.getFrameSetting(), this);
    }
}

