/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.I2cCommand;
import com.vendor.burn.model.BurnContext;
import com.vendor.burn.model.ChipID;
import com.vendor.burn.model.FlashType;
import com.vendor.burn.model.LocalConfig;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.cmdline.BurnStatus;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.IBootBurner;
import com.vendor.burn.model.devices.IFrameSetting;
import com.vendor.burn.model.devices.ITab;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.model.monitor.CmdMonitor;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AbstractBurnerWorker;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.serial.workers.SerialPort;
import com.vendor.burn.ui.burners.tabs.BootTab;
import com.vendor.burn.views.FastbootView;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class FastbootBurner
extends AbstractBurner
implements IBootBurner {
    private FlashType flashType;
    private String file;

    public FastbootBurner(BurnContext burnContext) {
        super(burnContext);
    }

    protected IFrameSetting getFrameSetting() {
        return this.getBurnContext().getDeviceSetting().getFrameSetting();
    }

    private boolean initTransferWay(IFastbootProgressMonitor fastbootMonitor, FastbootBurnerWorker worker) {
        BurnContext context;
        boolean needOpenSerial;
        LocalConfig config = this.getBurnContext().getLocalConfig();
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && transferWay != TransferWay.JTAG && transferWay != TransferWay.JTAGAndNet && transferWay != TransferWay.JTAGAndSerial && !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
        if (needOpenSerial) {
            SerialPort serialPort = this.openSerailPort(fastbootMonitor, worker, config.getComPort());
            if (serialPort == null) {
                worker.infoln("Open serail port failed");
                return false;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if ((context = this.getBurnContext()).getTransferWay() == TransferWay.I2CBootrom) {
            if (I2cCommand.I2cOpenChannelForBootrom(52, fastbootMonitor)) {
                worker.infoln("\nI2C channels open success, the bit rate is " + I2cCommand.getBaudRate() + ", device address is 0x" + Integer.toHexString(52));
            } else {
                worker.infoln("I2C channels open failed");
                return false;
            }
        }
        return !FastbootView.isCJ303V300() || worker.sendTranslateWayFrame(transferWay);
    }

    public int burnCmdLine(IFastbootProgressMonitor fastbootMonitor) {
        FastbootBurnerWorker worker = (FastbootBurnerWorker)this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        if (!this.initTransferWay(fastbootMonitor, worker)) {
            return BurnStatus.INIT_TRANSFER_WAY_FAILED.getErrorCode();
        }
        boolean result = false;
        int errorCode = BurnStatus.SUCCESS.getErrorCode();
        CmdMonitor monitor = new CmdMonitor();
        try {
            result = worker.burn(monitor, this.getFlashType(), this.getFile());
            if (!result) {
                this.closeByTrans();
                int n = BurnStatus.BURN_BOOT_FAILED.getErrorCode();
                return n;
            }
        }
        catch (IOException iOException) {
        }
        catch (ReceiveTimeOutException receiveTimeOutException) {
        }
        finally {
            if (!result && errorCode == BurnStatus.SUCCESS.getErrorCode()) {
                errorCode = BurnStatus.BURN_BOOT_FAILED.getErrorCode();
            }
            if (fastbootMonitor != null) {
                fastbootMonitor.finish();
                this.closeByTrans();
            }
        }
        return errorCode;
    }

    @Override
    public void burn(final IFastbootProgressMonitor fastbootMonitor) {
        final FastbootBurnerWorker worker = (FastbootBurnerWorker)this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        if (!this.initTransferWay(fastbootMonitor, worker)) {
            return;
        }
        Job fastbootJob = new Job("Burn Fastboot"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        worker.burn(monitor, FastbootBurner.this.getFlashType(), FastbootBurner.this.getFile());
                    }
                    catch (Throwable e) {
                        monitor.setCanceled(true);
                        if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                        }
                        IStatus iStatus = Status.CANCEL_STATUS;
                        worker.close();
                        return iStatus;
                    }
                }
                finally {
                    worker.close();
                }
                return Status.OK_STATUS;
            }
        };
        this.showProgressDialog(fastbootJob);
        fastbootJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                fastbootMonitor.finish();
                FastbootBurner.this.closeByTrans();
            }
        });
        fastbootJob.schedule();
    }

    @Override
    public IStatus checkBeforeBurn() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        if (this.flashType == null) {
            return this.error(Messages.AbstractBurner_msg_falshType_is_null);
        }
        if (this.file == null || this.file.trim().length() == 0) {
            return this.error(Messages.AbstractBurner_msg_file_path_does_not_select);
        }
        File theFile = new File(this.file);
        if (!theFile.exists()) {
            return this.error(Messages.AbstractBurner_msg_the_file_does_not_exist);
        }
        if (theFile.isDirectory()) {
            return this.error(Messages.AbstractBurner_msg_the_file_can_not_be_a_directory);
        }
        if (this.file.length() == 0) {
            return this.error(NLS.bind((String)Messages.AbstractBurner_msg_the_file_size_must_be_nonzero, (Object)1));
        }
        if (!(FastbootView.isCJXX0Series() || FastbootView.isCJ303V3Series() || FastbootView.isCJXX1Series() || theFile.length() <= 0x100000L)) {
            return this.error(Messages.AbstractBurner_msg_the_bootFile_size_must_be_less_than_1m);
        }
        return null;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public FlashType getFlashType() {
        return this.flashType;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(Messages.FastbootBurner_Step_1);
        steps.add(Messages.FastbootBurner_Step_2);
        steps.add(Messages.FastbootBurner_Step_3);
        steps.add(Messages.FastbootBurner_Step_4);
        return steps;
    }

    @Override
    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    @Override
    public ITab getTab() {
        return new BootTab();
    }

    @Override
    protected AbstractBurnerWorker getBurnerWorker() {
        return new FastbootBurnerWorker(this.getFrameSetting(), this);
    }

    @Override
    public ChipID getChipID() {
        return null;
    }

    @Override
    public void setFlashId(ChipID chipId) {
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

