/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.burners.cam;

import com.vendor.burn.Messages;
import com.vendor.burn.commands.NetCommand;
import com.vendor.burn.model.FileInfo;
import com.vendor.burn.model.TransferWay;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.receive.ReceiveTimeOutException;
import com.vendor.burn.serial.workers.AddressBurnerWorker;
import java.io.IOException;

public class CAMAddressBurnerWorker
extends AddressBurnerWorker {
    public CAMAddressBurnerWorker(IBurner burner) {
        super(burner);
    }

    @Override
    public boolean sendStartFrame(FileInfo fileInfo, String sendInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        String temp = null;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.frameSetting.getSendStartFrameTimeout()) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            try {
                this.receiveBytes(serialReceived, 4096);
            }
            catch (IOException iOException) {}
            temp = serialReceived.toString();
            int indexOf = temp.indexOf(sendInfo);
            if (indexOf == -1) continue;
            try {
                this.sendBytes(new byte[]{-86});
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean setupNetwork(TransferWay transferWay) throws ReceiveTimeOutException {
        this.infoln("waiting phy ready, it will take 8s.");
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            String usbTransNetCmd;
            if (transferWay == TransferWay.UsbTransNet && !this.sendCommand(usbTransNetCmd = "usb start")) {
                CAMAddressBurnerWorker.returnError(Messages.Fastboot_NotSupportUsbTransNetWay);
                return false;
            }
            NetCommand[] commands = this.buildNetCommands(transferWay);
            if (commands == null) {
                return false;
            }
            NetCommand[] netCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                NetCommand command = netCommandArray[n2];
                if (!this.sendCommand(command)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {}
        return true;
    }
}

