/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.unknown;

import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.devices.IBurnerContext;
import com.vendor.burn.model.devices.IDeviceSetting;
import com.vendor.burn.model.devices.burners.AbstractBurner;
import com.vendor.burn.model.devices.burners.AddressBurner;
import com.vendor.burn.model.devices.burners.BadCheckBurner;
import com.vendor.burn.model.devices.burners.BoardCheckBurner;
import com.vendor.burn.model.devices.burners.CheckSumBurner;
import com.vendor.burn.model.devices.burners.CommonBurner;
import com.vendor.burn.model.devices.burners.DdrBurner;
import com.vendor.burn.model.devices.burners.DdrCheckBurner;
import com.vendor.burn.model.devices.burners.EmmcBurner;
import com.vendor.burn.model.devices.burners.FastbootBurner;
import com.vendor.burn.model.devices.burners.MergeBurner;
import com.vendor.burn.model.devices.burners.PartitionBurner;
import com.vendor.burn.model.devices.burners.cam.CAMAddressBurnerWorker;
import com.vendor.burn.model.devices.burners.cam.CAMEmmcBurnerWorker;
import com.vendor.burn.model.devices.burners.cam.CAMFastbootBurnerWorker;
import com.vendor.burn.model.devices.burners.cam.CAMPartitionBurnerWorker;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.serial.workers.EmmcPartitionBurnerWorker;
import com.vendor.burn.serial.workers.FastbootBurnerWorker;
import com.vendor.burn.serial.workers.PartitionBurnerWorker;
import java.util.ArrayList;

public class UDBurnerContext
implements IBurnerContext {
    IDeviceSetting deviceSetting;
    IBurner[] burners;

    private UDBurnerContext() {
    }

    public static UDBurnerContext build(UDProperties properties, IDeviceSetting deviceSetting) {
        UDBurnerContext burnerContext = new UDBurnerContext();
        if (burnerContext.init(properties, deviceSetting)) {
            return burnerContext;
        }
        return null;
    }

    private boolean init(UDProperties properties, IDeviceSetting deviceSetting) {
        Integer boardCheckInt;
        Integer ddrBurn;
        Integer checkSumInt;
        Integer notSpiInt;
        Integer badCheckInt;
        this.deviceSetting = deviceSetting;
        if (properties == null) {
            return false;
        }
        ArrayList<AbstractBurner> burnerList = new ArrayList<AbstractBurner>();
        Integer commonPartition = properties.queryForInteger("CommonPartition");
        burnerList.add(new PartitionBurner(deviceSetting.getBurnContext()));
        if (commonPartition != null && commonPartition == 1) {
            burnerList.add(new CommonBurner(deviceSetting.getBurnContext()));
            burnerList.add(new AddressBurner(deviceSetting.getBurnContext()));
            burnerList.add(new FastbootBurner(deviceSetting.getBurnContext()));
            Integer emmcInt = properties.queryForInteger("EMMC");
            if (emmcInt != null && emmcInt > 0) {
                ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
            }
        } else {
            Integer emmcInt;
            String boardType = properties.queryForString("TYPE");
            if (boardType == null || !boardType.equalsIgnoreCase("CAM")) {
                burnerList.add(new PartitionBurner(deviceSetting.getBurnContext()));
                burnerList.add(new AddressBurner(deviceSetting.getBurnContext()));
                burnerList.add(new FastbootBurner(deviceSetting.getBurnContext()));
                emmcInt = properties.queryForInteger("EMMC");
                if (emmcInt != null && emmcInt > 0) {
                    burnerList.add(new EmmcBurner(deviceSetting.getBurnContext()));
                    ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
                }
            } else {
                burnerList.add(new PartitionBurner(deviceSetting.getBurnContext()){

                    @Override
                    protected PartitionBurnerWorker getBurnerWorker() {
                        return new CAMPartitionBurnerWorker(this);
                    }
                });
                burnerList.add(new AddressBurner(deviceSetting.getBurnContext()){

                    @Override
                    protected CAMAddressBurnerWorker getBurnerWorker() {
                        if (!(this.worker instanceof CAMAddressBurnerWorker)) {
                            this.worker = new CAMAddressBurnerWorker(this);
                        }
                        return (CAMAddressBurnerWorker)this.worker;
                    }
                });
                burnerList.add(new FastbootBurner(deviceSetting.getBurnContext()){

                    @Override
                    protected FastbootBurnerWorker getBurnerWorker() {
                        return new CAMFastbootBurnerWorker(this.getFrameSetting(), this);
                    }
                });
                emmcInt = properties.queryForInteger("EMMC");
                if (emmcInt != null && emmcInt > 0) {
                    burnerList.add(new EmmcBurner(deviceSetting.getBurnContext()){

                        @Override
                        public EmmcPartitionBurnerWorker getBurnerWorker() {
                            return new CAMEmmcBurnerWorker(this);
                        }
                    });
                    ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
                }
            }
        }
        if ((badCheckInt = properties.queryForInteger("BADCHECK")) != null && badCheckInt == 1) {
            burnerList.add(new BadCheckBurner(deviceSetting.getBurnContext()));
        }
        if ((notSpiInt = properties.queryForInteger("NOTSPI")) == null) {
            burnerList.add(new MergeBurner(deviceSetting.getBurnContext()));
        }
        if ((checkSumInt = properties.queryForInteger("CHECKSUM")) != null && checkSumInt == 1) {
            burnerList.add(new CheckSumBurner(deviceSetting.getBurnContext()));
        }
        if ((ddrBurn = properties.queryForInteger("DDRBURN")) != null && ddrBurn == 1) {
            burnerList.add(new DdrBurner(deviceSetting.getBurnContext()));
        }
        if ((boardCheckInt = properties.queryForInteger("LIGHTDEBUG")) != null && boardCheckInt == 1) {
            burnerList.add(new BoardCheckBurner(deviceSetting.getBurnContext()));
        }
        burnerList.add(new DdrCheckBurner(deviceSetting.getBurnContext()));
        this.burners = new IBurner[burnerList.size()];
        burnerList.toArray(this.burners);
        return true;
    }

    @Override
    public IBurner[] getBurners() {
        return (IBurner[])this.burners.clone();
    }

    @Override
    public IDeviceSetting getDeviceSetting() {
        return this.deviceSetting;
    }
}

