/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.model.devices.unknown;

import java.util.ArrayList;

public class UDProperties {
    public static final String PROPERTY_PRESTEP0 = "PRESTEP0";
    public static final String PROPERTY_PRESTEP1 = "PRESTEP1";
    public static final String PROPERTY_DDRSTEP0 = "DDRSTEP0";
    public static final String PROPERTY_ADDRESS0 = "ADDRESS0";
    public static final String PROPERTY_ADDRESS1 = "ADDRESS1";
    public static final String PROPERTY_ADDRESS1_NOTNUDE = "ADDRESS1_NOTNUDE";
    public static final String PROPERTY_ADDRESS2 = "ADDRESS2";
    public static final String PROPERTY_FILELEN0 = "FILELEN0";
    public static final String PROPERTY_FILELEN1 = "FILELEN1";
    public static final String PROPERTY_STEPLEN0 = "STEPLEN0";
    public static final String PROPERTY_STEPLEN1 = "STEPLEN1";
    public static final String PROPERTY_STARTFRAMETIMEOUT = "STARTFRAMETIMEOUT";
    public static final String PROPERTY_FLASH_EMMC = "EMMC";
    public static final String PROPERTY_BADCHECK = "BADCHECK";
    public static final String PROPERTY_TYPE = "TYPE";
    public static final String PROPERTY_CA = "CA";
    public static final String PROPERTY_FS_EXT = "EXT";
    public static final String PROPERTY_FS_YAFFS = "YAFFS";
    public static final String PROPERTY_FS_SQUASHFS = "SQUASHFS";
    public static final String PROPERTY_FS_UBI = "UBIFS";
    public static final String PROPERTY_FEATURE_NANDBURN = "NANDBURN";
    public static final String PROPERTY_FEATURE_SPINANDBURN = "SPINANDBURN";
    public static final String PROPERTY_FEATURE_EMMCBURN = "EMMCBURN";
    public static final String PROPERTY_ONLYSERIAL = "ONLYSERIAL";
    public static final String PROPERTY_FLASH_NOT_NAND = "NOTNAND";
    public static final String PROPERTY_FLASH_NOT_SPI = "NOTSPI";
    public static final String PROPERTY_CHECKSUM = "CHECKSUM";
    public static final String PROPERTY_DDRBURN = "DDRBURN";
    public static final String PROPERTY_FLASH_EEPROM = "EEPROM";
    public static final String PROPERTY_LIGHT_DEBUG = "LIGHTDEBUG";
    public static final String PROPERTY_JTAGANDUSB2ETH = "JTAGANDUSB2ETH";
    public static final String PROPERTY_USB2ETH = "USB2ETH";
    public static final String PROPERTY_TFTPWIN = "TFTPWIN";
    public static final String PROPERTY_NOTSUPPORTNET = "NOTSUPPORTNET";
    public static final String PROPERTY_UART2COMPRESS = "UART2COMPRESS";
    public static final String PROPERTY_USB2I2C = "USB2I2C";
    public static final String PROPERTY_BURN_BY_LIB_BOOTROM = "BurnByLibBootrom";
    public static final String PROPERTY_DEBUG_DDRTRAINING = "DebugDDrTraining";
    public static final String PROPERTY_NAND_PINSAVEMODE = "NandPinSaveMode";
    public static final String PROPERTY_SPI_NAND_PINSAVEMODE = "SPINandPinSaveMode";
    public static final String PROPERTY_NAND_ALIGNMENT_TYPE = "NANDAlignmentType";
    public static final String PROPERTY_NAND_EMPTY = "NandEmpty";
    public static final String PROPERTY_SPI_NAND_EMPTY = "SPINandEmpty";
    public static final String PROPERTY_I2C_BOOTROM = "I2CBootrom";
    public static final String PROPERTY_DDR_TRAINING_DEBUG = "DDrTrainingDelay";
    public static final String PROPERTY_USB_BOOTROM = "USBBootrom";
    public static final String PROPERTY_USB_NON_NUDE = "USBNonNude";
    public static final String PROPERTY_NET_NON_NUDE = "NETNonNude";
    public static final String PROPERTY_JTAG_AND_NET = "JTAGAndNet";
    public static final String PROPERTY_JTAG_AND_SERIAL = "JTAGAndSerial";
    public static final String PROPERTY_JTAG = "JTAG";
    public static final String PROPERTY_USB_AND_SERIAL = "UsbAndSerial";
    public static final String PROPERTY_SSD = "SSD";
    public static final String PROPERTY_GPT = "GPT";
    public static final String PROPERTY_COMMON_PARTITION = "CommonPartition";
    public static final String PROPERTY_UFS = "UFS";
    private ArrayList<UDProperty> properties = new ArrayList();

    protected UDProperty get(String key) {
        for (UDProperty prop : this.properties) {
            if (!key.equals(prop.getKey())) continue;
            return prop;
        }
        return null;
    }

    public boolean loadFromFile(String chipName) {
        return false;
    }

    public void set(String key, String value) {
        UDProperty prop = this.get(key);
        if (prop != null) {
            prop.setValue(value);
        } else {
            this.properties.add(new UDProperty(key, value));
        }
    }

    public String queryForString(String key) {
        UDProperty prop = this.get(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public Integer queryForInteger(String key) {
        UDProperty prop = this.get(key);
        if (prop != null) {
            int rtValue;
            try {
                if (prop.getValue().toLowerCase().startsWith("0x")) {
                    Long tmpNum = Long.parseLong(prop.getValue().substring(2), 16);
                    rtValue = tmpNum.intValue();
                } else {
                    rtValue = Integer.parseInt(prop.getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return rtValue;
        }
        return null;
    }

    static class UDProperty {
        private String key;
        private String value;

        UDProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + this.getValue();
        }
    }
}

