/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.nand.ecc;

import com.vendor.burn.utilitily.BytesUtils;
import java.io.UnsupportedEncodingException;

public class ECCBase {
    private static final int MAX_LFSR_BITS = 2048;
    private static final String POLY_8BIT = "b1111111001111011100101111111111001010011100001000011110001110110010110011110001001110011110011010101110000101101";
    private static final String POLY_16BIT = "b11001100001001000000110001110000010010101010001101001001000101001100001010100010100100010010000001011001010011110111111111010111111000111100001111010101100110000100010011101001111011011000100110101010100000110111011011001111";
    private static final String POLY_24BIT = "b100011101001010011100000001001001000110110010000100111010010101101000101001001010111001011010001111011011101100111010000100110001111111001110011000011101000111010001101001001101100001011010010001010001001001110100011101000000100100001011011110100001010101101101110000010110100100110010010100110100011010101101011110101000011000011101111";
    private static final String POLY_40BIT = "b11000000011111111000100110110001101000001101110001011101100101100110000110011111001100101101000001001001011001110101010011110110110111101001110101001111100100111111010100100111111011110001010011101111101100001111110101010011100110010001010110101000001011001100110110010010010101010010100010000000001100000100011101111101111011100011111100110011100010100101100111101100010111111010001000010000101011111110001011101111110111111010111011010010010001001101111100110001010011011010010100000111011000101011011100100100101000000000001010011100111011110010110111000001";
    private static final String POLY_64BIT = "b11110111101100010100111001110011001101100000001111000111100111101110101100101110110101100000111111010111101000101000000101101100011001001001110111010011000111100000011110001110010011001001101100011111000100010001010111000101010100011111000100011101000100110100010100000110000101101000101111010000111111010100100001011101011010111010101011010001000101101101011011001110111111100001010111101110010100000010000111111011001110001011001011100000001100010000000000011101000010011001111110001000001010010001010101001011010011010111001100010001101001011011001100111111111100011100001110100001001000110011011110101100001010101011000101010010101001111000011010000100011010101010000101011101001010011101100011010101100001011011101100001111001101100110111011110011100001010100001110111101111101100010010001010110110101100010001110000000101110100100010111000111111101001110000100000001011110100001000001010101";
    int lfsr_len;
    byte[] lfsr_poly = new byte[2048];
    byte[] lfsr_value = new byte[2048];

    void make_ecc_1bit(int addr, byte data_in, byte[] enc_data, byte[] enc_data_last) {
        int i = 0;
        byte[] ecc_l1 = new byte[8];
        byte[] ecc_h1 = new byte[8];
        byte[] nxt_ecc_reg = new byte[24];
        byte[] ecc_data_in = new byte[16];
        byte[] addr_in = new byte[9];
        i = 0;
        while (i < 8) {
            ecc_data_in[i] = (byte)(data_in >> i & 1);
            ++i;
        }
        i = 0;
        while (i < 9) {
            addr_in[i] = (byte)(addr >> i & 1);
            ++i;
        }
        ecc_l1[0] = (byte)(ecc_data_in[0] ^ ecc_data_in[1]);
        ecc_l1[1] = (byte)(ecc_data_in[0] ^ ecc_data_in[2]);
        ecc_l1[2] = (byte)(ecc_data_in[1] ^ ecc_data_in[3]);
        ecc_l1[3] = (byte)(ecc_data_in[2] ^ ecc_data_in[3]);
        ecc_l1[4] = (byte)(ecc_data_in[4] ^ ecc_data_in[5]);
        ecc_l1[5] = (byte)(ecc_data_in[4] ^ ecc_data_in[6]);
        ecc_l1[6] = (byte)(ecc_data_in[5] ^ ecc_data_in[7]);
        ecc_l1[7] = (byte)(ecc_data_in[6] ^ ecc_data_in[7]);
        ecc_h1[0] = (byte)(ecc_data_in[8] ^ ecc_data_in[9]);
        ecc_h1[1] = (byte)(ecc_data_in[8] ^ ecc_data_in[10]);
        ecc_h1[2] = (byte)(ecc_data_in[9] ^ ecc_data_in[11]);
        ecc_h1[3] = (byte)(ecc_data_in[10] ^ ecc_data_in[11]);
        ecc_h1[4] = (byte)(ecc_data_in[12] ^ ecc_data_in[13]);
        ecc_h1[5] = (byte)(ecc_data_in[12] ^ ecc_data_in[14]);
        ecc_h1[6] = (byte)(ecc_data_in[13] ^ ecc_data_in[15]);
        ecc_h1[7] = (byte)(ecc_data_in[14] ^ ecc_data_in[15]);
        byte ecc_p4ol = (byte)(ecc_l1[1] ^ ecc_l1[2]);
        byte ecc_p2ol = (byte)(ecc_l1[0] ^ ecc_l1[4]);
        byte ecc_p1ol = (byte)(ecc_l1[1] ^ ecc_l1[5]);
        byte ecc_p1el = (byte)(ecc_l1[2] ^ ecc_l1[6]);
        byte ecc_p2el = (byte)(ecc_l1[3] ^ ecc_l1[7]);
        byte ecc_p4el = (byte)(ecc_l1[5] ^ ecc_l1[6]);
        byte ecc_p4oh = (byte)(ecc_h1[1] ^ ecc_h1[2]);
        byte ecc_p2oh = (byte)(ecc_h1[0] ^ ecc_h1[4]);
        byte ecc_p1oh = (byte)(ecc_h1[1] ^ ecc_h1[5]);
        byte ecc_p1eh = (byte)(ecc_h1[2] ^ ecc_h1[6]);
        byte ecc_p2eh = (byte)(ecc_h1[3] ^ ecc_h1[7]);
        byte ecc_p4eh = (byte)(ecc_h1[5] ^ ecc_h1[6]);
        byte ecc_p1o = (byte)(ecc_p1ol ^ ecc_p1oh);
        byte ecc_p1e = (byte)(ecc_p1el ^ ecc_p1eh);
        byte ecc_p2o = (byte)(ecc_p2ol ^ ecc_p2oh);
        byte ecc_p2e = (byte)(ecc_p2el ^ ecc_p2eh);
        byte ecc_p4o = (byte)(ecc_p4ol ^ ecc_p4oh);
        byte ecc_p4e = (byte)(ecc_p4el ^ ecc_p4eh);
        byte ecc_p8o = (byte)(ecc_p2ol ^ ecc_p2el);
        byte ecc_p8e = (byte)(ecc_p2oh ^ ecc_p2eh);
        byte ecc_pr = (byte)(ecc_p8o ^ ecc_p8e);
        nxt_ecc_reg[0] = ecc_p1o;
        nxt_ecc_reg[1] = ecc_p1e;
        nxt_ecc_reg[2] = ecc_p2o;
        nxt_ecc_reg[3] = ecc_p2e;
        nxt_ecc_reg[4] = ecc_p4o;
        nxt_ecc_reg[5] = ecc_p4e;
        nxt_ecc_reg[6] = (byte)(~addr_in[0] & ecc_pr);
        nxt_ecc_reg[7] = (byte)(addr_in[0] & ecc_pr);
        nxt_ecc_reg[8] = (byte)(~addr_in[1] & ecc_pr);
        nxt_ecc_reg[9] = (byte)(addr_in[1] & ecc_pr);
        nxt_ecc_reg[10] = (byte)(~addr_in[2] & ecc_pr);
        nxt_ecc_reg[11] = (byte)(addr_in[2] & ecc_pr);
        nxt_ecc_reg[12] = (byte)(~addr_in[3] & ecc_pr);
        nxt_ecc_reg[13] = (byte)(addr_in[3] & ecc_pr);
        nxt_ecc_reg[14] = (byte)(~addr_in[4] & ecc_pr);
        nxt_ecc_reg[15] = (byte)(addr_in[4] & ecc_pr);
        nxt_ecc_reg[16] = (byte)(~addr_in[5] & ecc_pr);
        nxt_ecc_reg[17] = (byte)(addr_in[5] & ecc_pr);
        nxt_ecc_reg[18] = (byte)(~addr_in[6] & ecc_pr);
        nxt_ecc_reg[19] = (byte)(addr_in[6] & ecc_pr);
        nxt_ecc_reg[20] = (byte)(~addr_in[7] & ecc_pr);
        nxt_ecc_reg[21] = (byte)(addr_in[7] & ecc_pr);
        nxt_ecc_reg[22] = (byte)(~addr_in[8] & ecc_pr);
        nxt_ecc_reg[23] = (byte)(addr_in[8] & ecc_pr);
        i = 0;
        while (i < 24) {
            enc_data[i] = (byte)(enc_data_last[i] ^ nxt_ecc_reg[i]);
            ++i;
        }
    }

    public void ecc_1bit_gen(byte[] data, int len, byte[] ecc_code) {
        byte[] enc_data_last = new byte[24];
        byte[] enc_data = new byte[24];
        int i = 0;
        while (i < 24) {
            enc_data_last[i] = 1;
            ++i;
        }
        i = 0;
        while (i < len) {
            this.make_ecc_1bit(i, data[i], enc_data, enc_data_last);
            BytesUtils.copyBytes(enc_data_last, enc_data, 0, 0, 24);
            ++i;
        }
        if (len == 16) {
            enc_data[14] = 1;
            enc_data[15] = 1;
        }
        if (len >= 256) {
            i = 0;
            while (i < 3) {
                ecc_code[2 - i] = (byte)(enc_data[i * 8] + (enc_data[i * 8 + 1] << 1) + (enc_data[i * 8 + 2] << 2) + (enc_data[i * 8 + 3] << 3) + (enc_data[i * 8 + 4] << 4) + (enc_data[i * 8 + 5] << 5) + (enc_data[i * 8 + 6] << 6) + (enc_data[i * 8 + 7] << 7));
                ++i;
            }
        } else {
            i = 0;
            while (i < 2) {
                ecc_code[1 - i] = (byte)(enc_data[i * 8] + (enc_data[i * 8 + 1] << 1) + (enc_data[i * 8 + 2] << 2) + (enc_data[i * 8 + 3] << 3) + (enc_data[i * 8 + 4] << 4) + (enc_data[i * 8 + 5] << 5) + (enc_data[i * 8 + 6] << 6) + (enc_data[i * 8 + 7] << 7));
                ++i;
            }
        }
    }

    public int ecc_4bit_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 8, ecc_code);
        int i = 0;
        while (i < 14) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    public int ecc_16bit1k_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 16, ecc_code);
        int i = 0;
        while (i < 28) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    public int ecc_24bit1k_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 24, ecc_code);
        int i = 0;
        while (i < 42) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    public int ecc_40bit1k_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 40, ecc_code);
        int i = 0;
        while (i < 70) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    public int ecc_60bit1k_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 60, ecc_code);
        int i = 0;
        while (i < 108) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    public int ecc_64bit1k_gen(byte[] data, int len, byte[] ecc_code) {
        this.ecc_data_gen(data, len);
        int ret = this.ecc_parity_gen(data, len * 8, 64, ecc_code);
        int i = 0;
        while (i < 112) {
            ecc_code[i] = ~ecc_code[i];
            ++i;
        }
        return ret;
    }

    void inttolfsr(byte[] lfsr, int value) {
        int i = 0;
        while (i <= this.lfsr_len) {
            lfsr[i] = (value & 1 << i) > 0 ? (byte)1 : 0;
            ++i;
        }
    }

    void strtolfsr(byte[] lfsr, byte[] value) {
        int len = value.length;
        int i = 0;
        while (i < len) {
            byte c = value[len - 1 - i];
            lfsr[i] = c == 49 ? (byte)1 : 0;
            ++i;
        }
    }

    void lfsr_init(int len, byte[] poly, int value) {
        this.lfsr_len = len;
        int i = 0;
        while (i < 2048) {
            this.lfsr_poly[i] = 0;
            this.lfsr_value[i] = 0;
            ++i;
        }
        this.strtolfsr(this.lfsr_poly, poly);
        this.inttolfsr(this.lfsr_value, value);
    }

    void parity_lfsr_shift(int din) {
        byte feedback = (byte)(this.lfsr_value[this.lfsr_len - 1] ^ din);
        int i = this.lfsr_len - 1;
        while (i > 0) {
            this.lfsr_value[i] = (byte)(feedback & this.lfsr_poly[i] ^ this.lfsr_value[i - 1]);
            --i;
        }
        this.lfsr_value[0] = (byte)(feedback & this.lfsr_poly[0]);
    }

    void get_parity(byte[] parity) {
        int index = 0;
        int shift = 0;
        int value = 0;
        int i = this.lfsr_len - 1;
        while (i >= 0) {
            value |= this.lfsr_value[i] << shift;
            if (++shift == 8) {
                parity[index] = (byte)value;
                ++index;
                shift = 0;
                value = 0;
            }
            --i;
        }
    }

    int ecc_parity_gen(byte[] data, int bits, int ecc_level, byte[] ecc_code) {
        try {
            switch (ecc_level) {
                case 8: {
                    this.lfsr_init(112, POLY_8BIT.getBytes(System.getProperty("file.encoding")), 0);
                    break;
                }
                case 16: {
                    this.lfsr_init(224, POLY_16BIT.getBytes(System.getProperty("file.encoding")), 0);
                    break;
                }
                case 24: {
                    this.lfsr_init(336, POLY_24BIT.getBytes(System.getProperty("file.encoding")), 0);
                    break;
                }
                case 40: {
                    this.lfsr_init(560, POLY_40BIT.getBytes(System.getProperty("file.encoding")), 0);
                    break;
                }
                case 64: {
                    this.lfsr_init(896, POLY_64BIT.getBytes(System.getProperty("file.encoding")), 0);
                    break;
                }
                default: {
                    return -1;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        int i = 0;
        while (i < bits) {
            byte c = data[i >> 3];
            c = (byte)(c >> (i & 7) & 1);
            this.parity_lfsr_shift(c);
            ++i;
        }
        this.get_parity(ecc_code);
        return 0;
    }

    void ecc_data_gen(byte[] data, int len) {
        int i = 0;
        while (i < len / 2) {
            byte value = ~data[i * 2];
            data[i * 2] = ~data[i * 2 + 1];
            data[i * 2 + 1] = value;
            ++i;
        }
    }
}

