/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.nand.ip;

import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.PageType;
import com.vendor.burn.packagers.nand.ecc.ECCBase;
import com.vendor.burn.packagers.nand.ecc.ECCType;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.utilitily.BytesUtils;

public class NandIPV500
extends NandIPCommon {
    private static final int[] oobfree_2k_1bit = new int[]{22, 42};
    private static final int[] oobfree_def = new int[]{2, 30};
    private static final int NFC504_EPM_POS = 28;

    private void make1bitData(byte[] pagebuf, FlashOption option, int oobSize) {
        byte[] buf = null;
        int pagesize = option.getPageType().getPageSize();
        int oobsize = option.getOOBSize();
        ECCBase ecc = new ECCBase();
        if (option.getPageType() == PageType.Size2K) {
            byte[] ecc_buf;
            int i = 0;
            while (i < 4) {
                ecc_buf = BytesUtils.genBytesWithFF(4);
                ecc.ecc_1bit_gen(BytesUtils.genSubBytes(pagebuf, pagesize + i * 16, 16), 16, ecc_buf);
                pagebuf[pagesize + 14 + i * 2] = ecc_buf[0];
                pagebuf[pagesize + 14 + i * 2 + 1] = ecc_buf[1];
                ++i;
            }
            i = 0;
            while (i < pagesize / 512) {
                ecc_buf = BytesUtils.genBytesWithFF(4);
                ecc.ecc_1bit_gen(BytesUtils.genSubBytes(pagebuf, i * 512, 512), 512, ecc_buf);
                pagebuf[pagesize + 2 + i * 3] = ecc_buf[0];
                pagebuf[pagesize + 2 + i * 3 + 1] = ecc_buf[1];
                pagebuf[pagesize + 2 + i * 3 + 2] = ecc_buf[2];
                ++i;
            }
        } else {
            byte[] ecc_buf;
            buf = new byte[4184];
            BytesUtils.copyBytes(buf, pagebuf, 0, 0, pagesize + oobsize);
            int i = 0;
            while (i < 4) {
                ecc_buf = BytesUtils.genBytesWithFF(4);
                ecc.ecc_1bit_gen(BytesUtils.genSubBytes(pagebuf, i * 512, 512), 512, ecc_buf);
                pagebuf[2048 + i * 3] = ecc_buf[0];
                pagebuf[2048 + i * 3 + 1] = ecc_buf[1];
                pagebuf[2048 + i * 3 + 2] = ecc_buf[2];
                ++i;
            }
            BytesUtils.copyBytes(pagebuf, buf, 2060, 2048, 2048);
            i = 0;
            while (i < 4) {
                ecc_buf = BytesUtils.genBytesWithFF(4);
                ecc.ecc_1bit_gen(BytesUtils.genSubBytes(pagebuf, 2048 + i * 512, 512), 512, ecc_buf);
                pagebuf[4108 + i * 3] = ecc_buf[0];
                pagebuf[4108 + i * 3 + 1] = ecc_buf[1];
                pagebuf[4108 + i * 3 + 2] = ecc_buf[2];
                ++i;
            }
            BytesUtils.copyBytes(pagebuf, buf, pagesize + 24, pagesize, 56);
            i = 0;
            while (i < 4) {
                ecc_buf = BytesUtils.genBytesWithFF(4);
                ecc.ecc_1bit_gen(BytesUtils.genSubBytes(pagebuf, pagesize + i * 16, 16), 16, ecc_buf);
                pagebuf[pagesize + 24 + 56 + i * 2] = ecc_buf[0];
                pagebuf[pagesize + 24 + 56 + i * 2 + 1] = ecc_buf[1];
                ++i;
            }
        }
    }

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        return new FlashOption[]{new FlashOption(ECCType.Ecc1bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc16bit1k, PageType.Size2K, 64), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 128), new FlashOption(ECCType.Ecc1bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc16bit1k, PageType.Size4K, 128), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, 368), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, 600)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCBase ecc = new ECCBase();
        if (option.getEccType() == ECCType.Ecc1bit) {
            this.make1bitData(pagebuf, option, oobSize);
            return pagebuf;
        }
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 34, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 46, 14);
            }
        } else if (option.getEccType() == ECCType.Ecc16bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 6, 28);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 14, 28);
            }
        } else if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
        } else if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
        }
        return null;
    }

    public String toString() {
        return "Nand IP V500";
    }

    public static int[] getOobfree2k1bit() {
        return (int[])oobfree_2k_1bit.clone();
    }

    public static int[] getOobfreeDef() {
        return (int[])oobfree_def.clone();
    }

    public static int getNfc504EpmPos() {
        return 28;
    }
}

