/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.nand.ip;

import com.vendor.burn.model.FileSystem;
import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.model.devices.unknown.UDProperties;
import com.vendor.burn.model.devices.unknown.UnknownDevice;
import com.vendor.burn.packagers.nand.BlockType;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.PageType;
import com.vendor.burn.packagers.nand.ReverseBlockSizeSector;
import com.vendor.burn.packagers.nand.ReversePageEccSector;
import com.vendor.burn.packagers.nand.ecc.ECCType;
import com.vendor.burn.packagers.nand.ecc.ECCV600;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import com.vendor.burn.utilitily.BytesUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class NandIPV600
extends NandIPCommon {
    private IBurner burner;
    private String boardType;
    private static int NANDIP_V600 = 1536;
    static final ReversePageEccSector[] fmc100_page_ecc_reverse_sector = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V600, PageType.Size2K, ECCType.Ecc4bit, 0), new ReversePageEccSector(NANDIP_V600, PageType.Size2K, ECCType.Ecc24bit1k, 1), new ReversePageEccSector(NANDIP_V600, PageType.Size4K, ECCType.Ecc4bit, 2), new ReversePageEccSector(NANDIP_V600, PageType.Size4K, ECCType.Ecc24bit1k, 3), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc24bit1k, 4), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc40bit1k, 5), new ReversePageEccSector(NANDIP_V600, PageType.Size16K, ECCType.Ecc40bit1k, 6), new ReversePageEccSector(NANDIP_V600, PageType.Size16K, ECCType.Ecc64bit1k, 7), new ReversePageEccSector(NANDIP_V600, PageType.Size8K, ECCType.Ecc64bit1k, 8)};
    private static final ReverseBlockSizeSector[] fmc100_blocksize_reverse_sector = new ReverseBlockSizeSector[]{new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize64, 0), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize128, 1), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize256, 2), new ReverseBlockSizeSector(NANDIP_V600, BlockType.BlockSize512, 3)};

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        this.burner = burner;
        UDProperties properties = ((UnknownDevice)burner.getBurnContext().getDeviceSetting()).getProperties();
        this.boardType = properties.queryForString("TYPE");
        Integer spiNand = properties.queryForInteger("SPINANDBURN");
        if (this.boardType != null && this.boardType.equalsIgnoreCase("CAM")) {
            if (spiNand != null && spiNand != -1) {
                return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 60), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 116), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200)};
            }
            return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc16bit1k, PageType.Size2K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 128), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc16bit1k, PageType.Size4K, 144), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, 368)};
        }
        return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, 64), new FlashOption(ECCType.Ecc16bit1k, PageType.Size2K, 88), new FlashOption(ECCType.Ecc24bit1k, PageType.Size2K, 128), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, 128), new FlashOption(ECCType.Ecc16bit1k, PageType.Size4K, 144), new FlashOption(ECCType.Ecc24bit1k, PageType.Size4K, 200), new FlashOption(ECCType.Ecc24bit1k, PageType.Size8K, 368), new FlashOption(ECCType.Ecc40bit1k, PageType.Size8K, 600), new FlashOption(ECCType.Ecc40bit1k, PageType.Size16K, 1200)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCV600 ecc = new ECCV600();
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 14);
            }
        }
        if (option.getEccType() == ECCType.Ecc16bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                if (oobSize == 8) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 6, 28);
                }
                if (oobSize == 32) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 88) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (oobSize == 16) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 14, 28);
                }
                if (oobSize == 32) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 128) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
                if (oobSize == 144) {
                    return this.genPageDataBytes(ecc, option, pagebuf, 30, 28);
                }
            }
        } else if (option.getEccType() == ECCType.Ecc24bit1k) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 42);
            }
        } else if (option.getEccType() == ECCType.Ecc40bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 70);
            }
        } else if (option.getEccType() == ECCType.Ecc64bit1k) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 112);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytes(ecc, option, pagebuf, 30, 112);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doEmptyForCAM(FlashOption option, PartitionItem item, int pageCheckSize, RandomAccessFile inRanFile, boolean supportEmpty, byte[] pagebuf) throws IOException {
        boolean isEmptyAndCAM;
        int read = inRanFile.read(pagebuf, 0, pageCheckSize);
        if (read < 0) {
            System.out.println("Read Error.");
        }
        boolean bl = isEmptyAndCAM = this.boardType != null && this.boardType.equalsIgnoreCase("CAM") && supportEmpty;
        if (isEmptyAndCAM) {
            int camPageEmptyFlag = option.getPageType().getPageSize() + 32;
            if (item.getFileSystem() == FileSystem.ubiFs) {
                if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                    pagebuf[camPageEmptyFlag - 1] = 0;
                    pagebuf[camPageEmptyFlag - 2] = 0;
                }
            } else {
                pagebuf[camPageEmptyFlag - 1] = 0;
                pagebuf[camPageEmptyFlag - 2] = 0;
            }
        }
    }

    private boolean setEmptyFlag(FlashOption option, int blockSize, IFastbootProgressMonitor fastbootMonitor, PartitionItem item, int pageCheckSize, int pageCount, RandomAccessFile outRanFile, int pageMakeSize, boolean supportEmpty) {
        boolean isSupportEmpty;
        boolean ret = true;
        boolean bl = isSupportEmpty = this.boardType != null && this.boardType.equalsIgnoreCase("CAM") && supportEmpty;
        if (isSupportEmpty) {
            int page_num_incl_data = pageCount;
            int page_per_block = blockSize / option.getPageType().getPageSize();
            int page_num_total_block = page_num_incl_data & ~(page_per_block - 1);
            int page_num_fill_null = (page_num_total_block += (page_num_incl_data & page_per_block - 1) > 0 ? page_per_block : 0) - page_num_incl_data;
            while (page_num_fill_null-- > 0) {
                byte[] pagebuf = BytesUtils.genBytesWithFF(pageMakeSize);
                int camPageEmptyFlag = option.getPageType().getPageSize() + 32;
                if (item.getFileSystem() == FileSystem.ubiFs) {
                    if (this.checkBufferFF(pagebuf, pageCheckSize)) {
                        pagebuf[camPageEmptyFlag - 1] = 0;
                        pagebuf[camPageEmptyFlag - 2] = 0;
                    }
                } else {
                    pagebuf[camPageEmptyFlag - 1] = 0;
                    pagebuf[camPageEmptyFlag - 2] = 0;
                }
                byte[] data = null;
                try {
                    data = this.genPageData(pagebuf, option, option.getOOBSize());
                    if (data == null) continue;
                    outRanFile.write(data);
                }
                catch (Exception exception) {
                    fastbootMonitor.warnln("FAILED! (Write Empty flag error.)");
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    private ReversePageEccSector getPageSizeEccReverseSectorByInputSector(PageType pagetype, ECCType ecctype, ReversePageEccSector[] sector) {
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getEcctype() == ecctype && sector[i].getPagetype() == pagetype) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private ReverseBlockSizeSector getBlockSizeReverseSector(int blocksize, PageType pageType) {
        int pageNum = blocksize / pageType.getPageSize();
        ReverseBlockSizeSector[] sector = fmc100_blocksize_reverse_sector;
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getBlocktype().getSize() == pageNum) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private static void reverseBuf(byte[] buf, int startOff, int reverseLen) {
        int i = startOff;
        while (i < startOff + reverseLen) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    public boolean checkBufferFF(byte[] pagebuf, int length) {
        int index = 0;
        while (index < length) {
            if (pagebuf[index] != -1) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public String toString() {
        return "Nand IP V600";
    }
}

