/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.burn.packagers.nand.ip;

import com.vendor.burn.model.PartitionItem;
import com.vendor.burn.model.define.IBurner;
import com.vendor.burn.model.define.IFastbootProgressMonitor;
import com.vendor.burn.packagers.nand.FlashOption;
import com.vendor.burn.packagers.nand.PageType;
import com.vendor.burn.packagers.nand.ReversePageEccSector;
import com.vendor.burn.packagers.nand.ecc.ECCType;
import com.vendor.burn.packagers.nand.ecc.ECCV610;
import com.vendor.burn.packagers.nand.ip.NandIPCommon;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class NandIPV610
extends NandIPCommon {
    private static Map<String, Integer> map = new HashMap<String, Integer>();
    private static int NANDIP_V610 = 1552;
    private static final int REVERSE_DATA_LENTH = 32;
    private static final ReversePageEccSector[] nfc610_page_ecc_reverse_sector = new ReversePageEccSector[]{new ReversePageEccSector(NANDIP_V610, PageType.Size8K, ECCType.Ecc24bit, 0), new ReversePageEccSector(NANDIP_V610, PageType.Size4K, ECCType.Ecc24bit, 1), new ReversePageEccSector(NANDIP_V610, PageType.Size8K, ECCType.Ecc41bit, 2), new ReversePageEccSector(NANDIP_V610, PageType.Size16K, ECCType.Ecc41bit, 3), new ReversePageEccSector(NANDIP_V610, PageType.Size2K, ECCType.Ecc4bit, 4), new ReversePageEccSector(NANDIP_V610, PageType.Size4K, ECCType.Ecc4bit, 5), new ReversePageEccSector(NANDIP_V610, PageType.Size2K, ECCType.Ecc24bit, 6), new ReversePageEccSector(NANDIP_V610, PageType.Size16K, ECCType.Ecc60bit, 7), new ReversePageEccSector(NANDIP_V610, PageType.Size8K, ECCType.Ecc60bit, 8), new ReversePageEccSector(NANDIP_V610, PageType.Size16K, ECCType.Ecc80bit, 9), new ReversePageEccSector(NANDIP_V610, PageType.Size32K, ECCType.Ecc41bit, 10), new ReversePageEccSector(NANDIP_V610, PageType.Size32K, ECCType.Ecc60bit, 11), new ReversePageEccSector(NANDIP_V610, PageType.Size8K, ECCType.Ecc80bit, 12), new ReversePageEccSector(NANDIP_V610, PageType.Size32K, ECCType.Ecc80bit, 13)};

    public NandIPV610() {
        map.put("2k4bit", 60);
        map.put("2k13bit", 64);
        map.put("2k24bit", 116);
        map.put("2k27bit", 128);
        map.put("4k4bit", 88);
        map.put("4k13bit", 112);
        map.put("4k24bit", 200);
        map.put("4k27bit", 224);
        map.put("8k24bit", 368);
        map.put("8k27bit", 416);
        map.put("8k41bit", 608);
        map.put("8k60bit", 896);
        map.put("8k80bit", 1152);
        map.put("16k41bit", 1184);
        map.put("16k60bit", 1760);
        map.put("16k80bit", 1376);
    }

    @Override
    public FlashOption[] getAvailableOptions(IBurner burner) {
        return new FlashOption[]{new FlashOption(ECCType.Ecc4bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc13bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc24bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc27bit, PageType.Size2K, -1), new FlashOption(ECCType.Ecc4bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc13bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc27bit, PageType.Size4K, -1), new FlashOption(ECCType.Ecc24bit, PageType.Size8K, -1), new FlashOption(ECCType.Ecc27bit, PageType.Size8K, -1), new FlashOption(ECCType.Ecc41bit, PageType.Size8K, -1), new FlashOption(ECCType.Ecc60bit, PageType.Size8K, -1), new FlashOption(ECCType.Ecc80bit, PageType.Size8K, -1), new FlashOption(ECCType.Ecc41bit, PageType.Size16K, -1), new FlashOption(ECCType.Ecc60bit, PageType.Size16K, -1), new FlashOption(ECCType.Ecc80bit, PageType.Size16K, -1)};
    }

    @Override
    public byte[] genPageData(byte[] pagebuf, FlashOption option, int oobSize) {
        ECCV610 ecc = new ECCV610();
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 14);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 14);
            }
        }
        if (option.getEccType() == ECCType.Ecc13bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 14, 24);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 14, 24);
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 42);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 42);
            }
        }
        if (option.getEccType() == ECCType.Ecc27bit) {
            if (option.getPageType() == PageType.Size2K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 48);
            }
            if (option.getPageType() == PageType.Size4K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 48);
            }
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 48);
            }
        }
        if (option.getEccType() == ECCType.Ecc41bit) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 72);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 72);
            }
            if (option.getPageType() == PageType.Size32K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 62, 72);
            }
        }
        if (option.getEccType() == ECCType.Ecc60bit) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 108);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 108);
            }
            if (option.getPageType() == PageType.Size32K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 62, 108);
            }
        }
        if (option.getEccType() == ECCType.Ecc80bit) {
            if (option.getPageType() == PageType.Size8K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 140);
            }
            if (option.getPageType() == PageType.Size16K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 30, 140);
            }
            if (option.getPageType() == PageType.Size32K) {
                return this.genPageDataBytesFor610(ecc, option, pagebuf, 62, 140);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void make(String outputPath, FlashOption option, List<PartitionItem> partitions, int blockSize, boolean isSelectRandom, IFastbootProgressMonitor fastbootMonitor, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ReversePageEccSector getPageSizeEccReverseSector(PageType pagetype, ECCType ecctype) {
        ReversePageEccSector[] sector = nfc610_page_ecc_reverse_sector;
        int i = 0;
        while (i < sector.length) {
            if (sector[i].getEcctype() == ecctype && sector[i].getPagetype() == pagetype) {
                return sector[i];
            }
            ++i;
        }
        return null;
    }

    private int getUsedOobSize(FlashOption option) {
        int usedOobSize = 0;
        if (option.getEccType() == ECCType.Ecc4bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k4bit") != null) {
                    return map.get("2k4bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k4bit") != null) {
                return map.get("4k4bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc13bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k13bit") != null) {
                    return map.get("2k13bit");
                }
            } else if (option.getPageType() == PageType.Size4K && map.get("4k13bit") != null) {
                return map.get("4k13bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc24bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k24bit") != null) {
                    return map.get("2k24bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k24bit") != null) {
                    return map.get("4k24bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k24bit") != null) {
                return map.get("8k24bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc27bit) {
            if (option.getPageType() == PageType.Size2K) {
                if (map.get("2k27bit") != null) {
                    return map.get("2k27bit");
                }
            } else if (option.getPageType() == PageType.Size4K) {
                if (map.get("4k27bit") != null) {
                    return map.get("4k27bit");
                }
            } else if (option.getPageType() == PageType.Size8K && map.get("8k27bit") != null) {
                return map.get("8k27bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc41bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k41bit") != null) {
                    return map.get("8k41bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k41bit") != null) {
                return map.get("16k41bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc60bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k60bit") != null) {
                    return map.get("8k60bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k60bit") != null) {
                return map.get("16k60bit");
            }
        }
        if (option.getEccType() == ECCType.Ecc80bit) {
            if (option.getPageType() == PageType.Size8K) {
                if (map.get("8k80bit") != null) {
                    return map.get("8k80bit");
                }
            } else if (option.getPageType() == PageType.Size16K && map.get("16k80bit") != null) {
                return map.get("16k80bit");
            }
        }
        return usedOobSize;
    }

    private static void reverseBuf(byte[] buf, int startOff, int reverseLen) {
        int i = startOff;
        while (i < startOff + reverseLen) {
            buf[i] = ~buf[i];
            ++i;
        }
    }

    public String toString() {
        return "Nand IP V610";
    }
}

